/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.hostinfo.impl;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.support.InstalledFileLocatorProvider;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.hostinfo.HostInfoProvider;
import org.netbeans.modules.nativeexecution.support.hostinfo.impl.HostInfoFactory;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Utilities;

public class UnixHostInfoProvider
implements HostInfoProvider {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private static final File hostinfoScript;

    public HostInfo getHostInfo(ExecutionEnvironment executionEnvironment) throws IOException {
        if (hostinfoScript == null) {
            return null;
        }
        boolean bl = executionEnvironment.isLocal();
        if (bl && Utilities.isWindows()) {
            return null;
        }
        Properties properties = executionEnvironment.isLocal() ? this.getLocalHostInfo() : this.getRemoteHostInfo(executionEnvironment);
        return HostInfoFactory.newHostInfo(properties);
    }

    private Properties getLocalHostInfo() throws IOException {
        Properties properties = new Properties();
        try {
            String string = "sh";
            ProcessBuilder processBuilder = new ProcessBuilder(string, hostinfoScript.getAbsolutePath());
            File file = new File(System.getProperty("java.io.tmpdir"));
            String string2 = file.getCanonicalPath();
            processBuilder.environment().put("TMPBASE", string2);
            processBuilder.environment().put("PATH", processBuilder.environment().get("PATH") + File.pathSeparator + "/bin:/usr/bin");
            processBuilder.environment().put("NB_KEY", HostInfoFactory.getNBKey());
            Process process = processBuilder.start();
            List<String> list = ProcessUtils.readProcessError(process);
            int n = process.waitFor();
            if (n != 0) {
                log.log(Level.INFO, "stderr:", list.toArray(new String[0]));
                throw new IOException(hostinfoScript + " rc == " + n);
            }
            properties.load(process.getInputStream());
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new IOException("HostInfo receiving for localhost interrupted " + interruptedException);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Properties getRemoteHostInfo(ExecutionEnvironment executionEnvironment) throws IOException {
        Properties properties;
        block21: {
            InputStream inputStream;
            OutputStream outputStream;
            block19: {
                ConnectionManager connectionManager = ConnectionManager.getInstance();
                if (!connectionManager.isConnectedTo(executionEnvironment)) {
                    connectionManager.connectTo(executionEnvironment);
                }
                properties = new Properties();
                outputStream = null;
                inputStream = null;
                Session session = ConnectionManagerAccessor.getDefault().getConnectionSession(connectionManager, executionEnvironment, true);
                if (session == null) break block19;
                ChannelExec channelExec = null;
                Session session2 = session;
                synchronized (session2) {
                    channelExec = (ChannelExec)session.openChannel("exec");
                    channelExec.setEnv("PATH", "/bin:/usr/bin");
                    channelExec.setCommand("sh -s");
                    channelExec.connect();
                }
                long l = System.currentTimeMillis();
                outputStream = channelExec.getOutputStream();
                inputStream = channelExec.getInputStream();
                outputStream.write(("NB_KEY=" + HostInfoFactory.getNBKey() + '\n').getBytes());
                outputStream.flush();
                BufferedReader bufferedReader = new BufferedReader(new FileReader(hostinfoScript));
                String string = bufferedReader.readLine();
                while (string != null) {
                    outputStream.write((string + '\n').getBytes());
                    outputStream.flush();
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
                properties.load(inputStream);
                long l2 = System.currentTimeMillis();
                properties.put("LOCALTIME", (Object)((l + l2) / 2L));
            }
            Object var15_15 = null;
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block21;
            }
            catch (IOException iOException) {}
            break block21;
            {
                catch (JSchException jSchException) {
                    throw new IOException("Exception while receiving HostInfo for " + ((Object)executionEnvironment).toString() + ": " + (Object)((Object)jSchException));
                }
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return properties;
    }

    static {
        InstalledFileLocator installedFileLocator = InstalledFileLocatorProvider.getDefault();
        hostinfoScript = installedFileLocator.locate("bin/nativeexecution/hostinfo.sh", null, false);
        if (hostinfoScript == null) {
            log.severe("Unable to find hostinfo.sh script!");
        }
    }
}

