/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.filesearch.impl;

import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.filesearch.FileSearchParams;
import org.netbeans.modules.nativeexecution.support.filesearch.FileSearcher;

public class RemoteFileSearcherImpl
implements FileSearcher {
    private static final java.util.logging.Logger log = Logger.getInstance();

    public String searchFile(FileSearchParams fileSearchParams) {
        ExecutionEnvironment executionEnvironment = fileSearchParams.getExecEnv();
        if (executionEnvironment.isLocal()) {
            return null;
        }
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo(executionEnvironment);
            if (hostInfo == null) {
                return null;
            }
            String string = hostInfo.getShell();
            if (string == null) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>(fileSearchParams.getSearchPaths());
            if (fileSearchParams.isSearchInUserPaths()) {
                arrayList.addAll(Arrays.asList(hostInfo.getPath().split(":")));
            }
            NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder(executionEnvironment);
            nativeProcessBuilder.setExecutable(string).setArguments("-s");
            NativeProcess nativeProcess = nativeProcessBuilder.call();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(nativeProcess.getOutputStream());
            for (String string2 : arrayList) {
                if (string2.indexOf(34) >= 0) continue;
                outputStreamWriter.append("/bin/ls \"").append(string2);
                outputStreamWriter.append("/" + fileSearchParams.getFilename() + "\" 2>/dev/null || \\\n");
            }
            outputStreamWriter.append("(echo \"Not Found\" && exit 1)\n");
            outputStreamWriter.append("exit $?\n");
            outputStreamWriter.flush();
            outputStreamWriter.close();
            String string3 = ProcessUtils.readProcessOutputLine(nativeProcess);
            int n = nativeProcess.waitFor();
            return n != 0 || string3 == null || "".equals(string3.trim()) ? null : string3.trim();
        }
        catch (Throwable throwable) {
            log.log(Level.FINE, "Execption in UnixFileSearcherImpl:", throwable);
            return null;
        }
    }
}

