/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeProcessInfo {
    public final MacroExpanderFactory.MacroExpander macroExpander;
    private final ExecutionEnvironment execEnv;
    private final boolean isWindows;
    private final MacroMap environment;
    private final List<String> arguments = new ArrayList<String>();
    private String executable;
    private String commandLine;
    private String workingDirectory;
    private boolean unbuffer;
    private boolean redirectError;
    private boolean x11forwarding;
    private boolean suspend;
    private Collection<ChangeListener> listeners = null;

    public NativeProcessInfo(ExecutionEnvironment executionEnvironment) {
        this.execEnv = executionEnvironment;
        this.executable = null;
        this.unbuffer = false;
        this.workingDirectory = null;
        this.macroExpander = MacroExpanderFactory.getExpander(executionEnvironment);
        this.environment = MacroMap.forExecEnv(executionEnvironment);
        this.isWindows = executionEnvironment.isLocal() && Utilities.isWindows();
        this.redirectError = false;
    }

    public void addNativeProcessListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ChangeListener>();
        }
        this.listeners.add(changeListener);
    }

    public void redirectError(boolean bl) {
        this.redirectError = bl;
    }

    public void setExecutable(String string) {
        this.executable = string;
    }

    public void setCommandLine(String string) {
        this.commandLine = string;
    }

    public void setWorkingDirectory(String string) {
        this.workingDirectory = string;
    }

    public void setUnbuffer(boolean bl) {
        this.unbuffer = bl;
    }

    public boolean isUnbuffer() {
        return this.unbuffer;
    }

    public void setX11Forwarding(boolean bl) {
        this.x11forwarding = bl;
    }

    public boolean getX11Forwarding() {
        return this.x11forwarding;
    }

    public void setInitialSuspend(boolean bl) {
        this.suspend = bl;
    }

    public boolean getInitialSuspend() {
        return this.suspend;
    }

    public void setArguments(String ... stringArray) {
        if (this.commandLine != null) {
            throw new IllegalStateException("commandLine is already defined. No additional parameters can be set");
        }
        this.arguments.clear();
        for (String string : stringArray) {
            this.arguments.add(string.trim());
        }
    }

    public List<String> getCommand() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.commandLine != null) {
            String string;
            try {
                string = this.macroExpander.expandPredefinedMacros(this.commandLine);
            }
            catch (Exception exception) {
                string = this.executable;
            }
            arrayList.add(string);
        } else {
            String string;
            try {
                string = this.macroExpander.expandPredefinedMacros(this.executable);
            }
            catch (Exception exception) {
                string = this.executable;
            }
            arrayList.add(string);
            for (String string2 : this.arguments) {
                if ((string2 = Utilities.escapeParameters((String[])new String[]{string2})).startsWith("'") && string2.endsWith("'") || string2.startsWith("\"") && string2.endsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                arrayList.add('\"' + string2 + '\"');
            }
        }
        return arrayList;
    }

    private String quoteSpecialChars(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.isWindows ? " \"'()" : " \"'()!";
        for (char c : string.toCharArray()) {
            if (string2.indexOf(c) >= 0) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public String getCommandLineForShell() {
        if (this.commandLine != null) {
            return this.commandLine;
        }
        StringBuilder stringBuilder = new StringBuilder();
        List<String> list = this.getCommand();
        String string = list.get(0);
        if (this.isWindows && (string = WindowsSupport.getInstance().convertToShellPath(string)) == null) {
            return null;
        }
        stringBuilder.append(this.quoteSpecialChars(string)).append(' ');
        String[] stringArray = new String[1];
        for (String string2 : this.arguments) {
            boolean bl = false;
            stringArray[0] = string2;
            string2 = Utilities.escapeParameters((String[])stringArray);
            stringBuilder.append('\"');
            if (string2.startsWith("'") && string2.endsWith("'") || string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
                bl = true;
            }
            if (this.isWindows || bl) {
                int n = 120;
                for (int n2 : string2.toCharArray()) {
                    if (n2 == 36 && n != 92) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append((char)n2);
                    n = n2;
                }
            } else {
                stringBuilder.append(string2);
            }
            stringBuilder.append("\" ");
        }
        if (this.redirectError) {
            stringBuilder.append(" 2>&1");
        }
        return stringBuilder.toString().trim();
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.execEnv;
    }

    public Collection<ChangeListener> getListeners() {
        return this.listeners;
    }

    public String getWorkingDirectory(boolean bl) {
        String string = this.workingDirectory;
        if (bl && this.macroExpander != null) {
            try {
                string = this.macroExpander.expandPredefinedMacros(this.workingDirectory);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return string;
    }

    public MacroMap getEnvironment() {
        return this.environment;
    }
}

