/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataTableMetadata {
    private final String name;
    private final List<Column> columns;
    private final List<Column> indexedColumns;
    private final List<String> columnNames;
    private final List<DataTableMetadata> sourceTables;
    private final String statement;

    public DataTableMetadata(String string, List<Column> list, List<Column> list2) {
        this(string, list, list2, null, null);
    }

    public DataTableMetadata(String string, List<Column> list, String string2, List<DataTableMetadata> list2) {
        this(string, list, null, string2, list2);
    }

    private DataTableMetadata(String string, List<Column> list, List<Column> list2, String string2, List<DataTableMetadata> list3) {
        this.name = string;
        this.columns = list;
        this.indexedColumns = list2 == null ? Collections.emptyList() : list2;
        this.statement = string2;
        this.sourceTables = list3;
        this.columnNames = new ArrayList<String>(list.size());
        for (Column column : list) {
            this.columnNames.add(column.getColumnName());
        }
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<DataTableMetadata> getSourceTables() {
        return this.sourceTables;
    }

    public String getName() {
        return this.name;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Column> getIndexedColumns() {
        return this.indexedColumns;
    }

    public String getViewStatement() {
        return this.statement;
    }

    public Column getColumnByName(String string) {
        for (Column column : this.columns) {
            if (!column.getColumnName().equals(string)) continue;
            return column;
        }
        return null;
    }

    public int getColumnsCount() {
        return this.columns.size();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.name);
        stringBuilder.append(' ');
        if (this.columns != null) {
            for (Column column : this.columns) {
                stringBuilder.append("\n\t");
                stringBuilder.append(column);
            }
        }
        return stringBuilder.toString();
    }

    public boolean isProvidedBy(List<DataTableMetadata> list) {
        if (this.sourceTables != null) {
            for (DataTableMetadata dataTableMetadata : this.sourceTables) {
                boolean bl = false;
                for (DataTableMetadata dataTableMetadata2 : list) {
                    if (!dataTableMetadata.getName().equals(dataTableMetadata2.getName())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }
        for (DataTableMetadata dataTableMetadata : list) {
            if (!dataTableMetadata.getName().equals(this.getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Column {
        final String name;
        final Class columnClass;
        final String shortUName;
        final String longUName;
        final String expression;

        public Column(String string, Class clazz) {
            this(string, clazz, string, null);
        }

        public Column(String string, Class clazz, String string2, String string3) {
            this(string, clazz, string2, string2, string3);
        }

        public Column(String string, Class clazz, String string2, String string3, String string4) {
            this.name = string;
            this.columnClass = clazz;
            this.shortUName = string2;
            this.longUName = string3;
            this.expression = string4;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }

        public String getColumnName() {
            return this.name;
        }

        public String getColumnLongUName() {
            return this.longUName;
        }

        public String getColumnUName() {
            return this.shortUName;
        }

        public String getExpression() {
            return this.expression;
        }

        public String toString() {
            return this.name + " : (" + this.getColumnClass().getName() + ")";
        }
    }
}

