/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.procfs.reader.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.dlight.procfs.api.LWPUsage;
import org.netbeans.modules.dlight.procfs.api.PStatus;
import org.netbeans.modules.dlight.procfs.api.PUsage;
import org.netbeans.modules.dlight.procfs.reader.impl.DataModel;
import org.netbeans.modules.dlight.procfs.reader.impl.ProcReaderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalProcReader
extends ProcReaderImpl {
    private final File usageFile;
    private final File statusFile;
    private final File lwpDir;

    public LocalProcReader(int n, ByteOrder byteOrder, DataModel dataModel) {
        super(byteOrder, dataModel);
        this.usageFile = new File("/proc/" + n + "/usage");
        this.statusFile = new File("/proc/" + n + "/status");
        this.lwpDir = new File("/proc/" + n + "/lwp");
    }

    @Override
    public PStatus getProcessStatus() {
        PStatus pStatus = null;
        try {
            pStatus = this.getProcessStatus(new FileInputStream(this.statusFile));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pStatus;
    }

    @Override
    public PUsage getProcessUsage() throws IOException {
        return this.getProcessUsage(new FileInputStream(this.usageFile));
    }

    @Override
    public List<LWPUsage> getThreadsInfo() {
        ArrayList<LWPUsage> arrayList = new ArrayList<LWPUsage>();
        String[] stringArray = this.lwpDir.list();
        if (stringArray == null) {
            return arrayList;
        }
        for (String string : stringArray) {
            try {
                arrayList.add(this.getProcessUsage(new FileInputStream(new File(this.lwpDir, string + "/lwpusage"))));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList;
    }
}

