/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.dd.impl;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import org.netbeans.modules.j2ee.sun.dd.impl.transform.ModAttribute;
import org.netbeans.modules.j2ee.sun.dd.impl.transform.ModElement;
import org.netbeans.modules.j2ee.sun.dd.impl.transform.SubElement;
import org.netbeans.modules.j2ee.sun.dd.impl.transform.Transform;
import org.netbeans.modules.j2ee.sun.dd.impl.transform.Xmltype;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDTreeWalker {
    Document document;
    String downgradeVersion;
    String currentVersion;
    Transform transInfo;
    String DATAFILE = "org/netbeans/modules/j2ee/sun/dd/impl/transform/transform.xml";

    public DDTreeWalker(Document document, String string, String string2) {
        this.document = document;
        this.downgradeVersion = string;
        this.currentVersion = string2;
    }

    public void downgradeSunWebAppDocument() {
        this.transInfo = this.getTransformInfo();
        if (this.transInfo != null) {
            Vector<ModElement> vector = new Vector<ModElement>();
            Xmltype xmltype = null;
            if (this.currentVersion.equals("2.50")) {
                xmltype = this.getXmlType(this.transInfo, "sunWebApp41");
                vector = this.updateModElementsList(vector, xmltype);
            }
            if (this.downgradeVersion.equals("2.40") || this.downgradeVersion.equals("2.30")) {
                xmltype = this.getXmlType(this.transInfo, "sunWebApp40");
                vector = this.updateModElementsList(vector, xmltype);
            }
            if (this.downgradeVersion.equals("2.30")) {
                xmltype = this.getXmlType(this.transInfo, "sunWebApp30");
                vector = this.updateModElementsList(vector, xmltype);
            }
            this.processDocument(vector);
        }
    }

    public void downgradeSunEjbJarDocument() {
        this.transInfo = this.getTransformInfo();
        if (this.transInfo != null) {
            Vector<ModElement> vector = new Vector<ModElement>();
            Xmltype xmltype = null;
            if (this.currentVersion.equals("3.01")) {
                xmltype = this.getXmlType(this.transInfo, "sunEjb300");
                vector = this.updateModElementsList(vector, xmltype);
            }
            if (this.downgradeVersion.equals("3.00") || this.downgradeVersion.equals("2.10") || this.downgradeVersion.equals("2.00")) {
                xmltype = this.getXmlType(this.transInfo, "sunEjb300");
                vector = this.updateModElementsList(vector, xmltype);
            }
            if (this.downgradeVersion.equals("2.10") || this.downgradeVersion.equals("2.00")) {
                xmltype = this.getXmlType(this.transInfo, "sunEjb210");
                vector = this.updateModElementsList(vector, xmltype);
            }
            if (this.downgradeVersion.equals("2.00")) {
                xmltype = this.getXmlType(this.transInfo, "sunEjb200");
                vector = this.updateModElementsList(vector, xmltype);
            }
            this.processDocument(vector);
        }
    }

    public void downgradeSunClientDocument() {
        this.transInfo = this.getTransformInfo();
        if (this.transInfo != null) {
            Vector<ModElement> vector = new Vector<ModElement>();
            Xmltype xmltype = null;
            if (this.currentVersion.equals("5.00")) {
                xmltype = this.getXmlType(this.transInfo, "sunClient41");
                vector = this.updateModElementsList(vector, xmltype);
            }
            if (this.downgradeVersion.equals("1.40") || this.downgradeVersion.equals("1.30")) {
                xmltype = this.getXmlType(this.transInfo, "sunClient40");
                vector = this.updateModElementsList(vector, xmltype);
            }
            if (this.downgradeVersion.equals("1.30")) {
                xmltype = this.getXmlType(this.transInfo, "sunClient30");
                vector = this.updateModElementsList(vector, xmltype);
            }
            this.processDocument(vector);
        }
    }

    public void downgradeSunCmpMappingsDocument() {
        throw new UnsupportedOperationException();
    }

    private Vector<ModElement> updateModElementsList(Vector<ModElement> vector, Xmltype xmltype) {
        if (xmltype != null) {
            ModElement[] modElementArray = xmltype.getModElement();
            vector.addAll(new HashSet<ModElement>(Arrays.asList(modElementArray)));
        }
        return vector;
    }

    private void processDocument(Vector<ModElement> vector) {
        Element element = this.document.getDocumentElement();
        this.visitElement(element, vector);
    }

    private void visitElement(Element element, Vector<ModElement> vector) {
        this.walkElement(element, vector);
        NodeList nodeList = element.getChildNodes();
        block3: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element element2 = (Element)node;
                    String string = element2.getTagName();
                    this.walkElement(element2, vector);
                    this.visitElement(element2, vector);
                    continue block3;
                }
            }
        }
    }

    private void walkElement(Element element, Vector<ModElement> vector) {
        ModElement[] modElementArray = vector.toArray(new ModElement[vector.size()]);
        for (int i = 0; i < modElementArray.length; ++i) {
            ModElement modElement = modElementArray[i];
            if (element == null || !element.getTagName().equals(modElement.getName())) continue;
            ModAttribute[] modAttributeArray = modElement.getModAttribute();
            for (int j = 0; j < modAttributeArray.length; ++j) {
                this.removeAttribute(element, modAttributeArray[j].getName());
            }
            SubElement[] subElementArray = modElement.getSubElement();
            for (int j = 0; j < subElementArray.length; ++j) {
                String string = subElementArray[j].getName();
                this.removeElement(element, string);
            }
        }
    }

    private void removeAttribute(Element element, String string) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!attr.getName().equals(string)) continue;
            element.removeAttributeNode(attr);
        }
    }

    private void removeElement(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        block3: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    Element element2 = (Element)node;
                    if (!element2.getTagName().equals(string)) continue block3;
                    element.removeChild(node);
                }
            }
        }
    }

    public Xmltype getXmlType(Transform transform, String string) {
        Xmltype[] xmltypeArray = transform.getXmltype();
        for (int i = 0; i < xmltypeArray.length; ++i) {
            if (!xmltypeArray[i].getName().equals(string)) continue;
            return xmltypeArray[i];
        }
        return null;
    }

    public Transform getTransformInfo() {
        try {
            InputStream inputStream = Transform.class.getClassLoader().getResourceAsStream(this.DATAFILE);
            this.transInfo = Transform.createGraph(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.transInfo;
    }
}

