/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.ArrayNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallSite;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpElementAsgnNode
extends Node {
    private final Node receiverNode;
    private final Node argsNode;
    private final Node valueNode;
    public final CallSite callAdapter;
    public final CallSite elementAdapter;
    public final CallSite elementAsgnAdapter;

    public OpElementAsgnNode(ISourcePosition iSourcePosition, Node node, String string, Node node2, Node node3) {
        super(iSourcePosition, NodeType.OPELEMENTASGNNODE);
        assert (node != null) : "receiverNode is not null";
        assert (node3 != null) : "valueNode is not null";
        this.receiverNode = node;
        this.argsNode = node2;
        if (node2 instanceof ArrayNode) {
            ((ArrayNode)node2).setLightweight(true);
        }
        this.valueNode = node3;
        this.callAdapter = MethodIndex.getCallSite(string);
        this.elementAdapter = MethodIndex.getFunctionalCallSite("[]");
        this.elementAsgnAdapter = MethodIndex.getFunctionalCallSite("[]=");
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitOpElementAsgnNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public String getOperatorName() {
        return this.callAdapter.methodName;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode, this.valueNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = this.receiverNode.interpret(ruby, threadContext, iRubyObject, block);
        IRubyObject[] iRubyObjectArray = ASTInterpreter.setupArgs(ruby, threadContext, this.argsNode, iRubyObject, block);
        IRubyObject iRubyObject3 = this.elementAdapter.call(threadContext, iRubyObject2, iRubyObjectArray);
        if (this.getOperatorName() == "||") {
            if (iRubyObject3.isTrue()) {
                return iRubyObject3;
            }
            iRubyObject3 = this.valueNode.interpret(ruby, threadContext, iRubyObject, block);
        } else if (this.getOperatorName() == "&&") {
            if (!iRubyObject3.isTrue()) {
                return iRubyObject3;
            }
            iRubyObject3 = this.valueNode.interpret(ruby, threadContext, iRubyObject, block);
        } else {
            iRubyObject3 = this.callAdapter.call(threadContext, iRubyObject3, this.valueNode.interpret(ruby, threadContext, iRubyObject, block));
        }
        IRubyObject[] iRubyObjectArray2 = new IRubyObject[iRubyObjectArray.length + 1];
        System.arraycopy(iRubyObjectArray, 0, iRubyObjectArray2, 0, iRubyObjectArray.length);
        iRubyObjectArray2[iRubyObjectArray2.length - 1] = iRubyObject3;
        this.elementAsgnAdapter.call(threadContext, iRubyObject2, iRubyObjectArray2);
        return iRubyObject3;
    }
}

