/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.sql.analyzer.CreateStatementAnalyzer;
import org.netbeans.modules.db.sql.analyzer.DeleteStatementAnalyzer;
import org.netbeans.modules.db.sql.analyzer.DropStatementAnalyzer;
import org.netbeans.modules.db.sql.analyzer.InsertStatementAnalyzer;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.analyzer.SQLStatement;
import org.netbeans.modules.db.sql.analyzer.SQLStatementKind;
import org.netbeans.modules.db.sql.analyzer.SelectStatement;
import org.netbeans.modules.db.sql.analyzer.SelectStatementAnalyzer;
import org.netbeans.modules.db.sql.analyzer.TablesClause;
import org.netbeans.modules.db.sql.analyzer.UpdateStatementAnalyzer;
import org.netbeans.modules.db.sql.editor.StringUtils;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLStatementAnalyzer {
    protected TokenSequence<SQLTokenId> seq;
    protected SQLIdentifiers.Quoter quoter;
    protected int startOffset;
    protected SQLStatement.Context context = SQLStatement.Context.START;
    protected final SortedMap<Integer, SQLStatement.Context> offset2Context = new TreeMap<Integer, SQLStatement.Context>();
    protected final List<SelectStatement> subqueries = new ArrayList<SelectStatement>();

    protected SQLStatementAnalyzer(TokenSequence<SQLTokenId> tokenSequence, SQLIdentifiers.Quoter quoter) {
        this.seq = tokenSequence;
        this.quoter = quoter;
    }

    public static SQLStatement analyze(TokenSequence<SQLTokenId> tokenSequence, SQLIdentifiers.Quoter quoter) {
        SQLStatementKind sQLStatementKind = SQLStatementAnalyzer.analyzeKind(tokenSequence);
        if (sQLStatementKind == null) {
            return null;
        }
        switch (sQLStatementKind) {
            case SELECT: {
                return SelectStatementAnalyzer.analyze(tokenSequence, quoter);
            }
            case INSERT: {
                return InsertStatementAnalyzer.analyze(tokenSequence, quoter);
            }
            case DROP: {
                return DropStatementAnalyzer.analyze(tokenSequence, quoter);
            }
            case UPDATE: {
                return UpdateStatementAnalyzer.analyze(tokenSequence, quoter);
            }
            case DELETE: {
                return DeleteStatementAnalyzer.analyze(tokenSequence, quoter);
            }
            case CREATE: {
                return CreateStatementAnalyzer.analyze(tokenSequence, quoter);
            }
        }
        return null;
    }

    public static SQLStatementKind analyzeKind(TokenSequence<SQLTokenId> tokenSequence) {
        tokenSequence.moveStart();
        if (!SQLStatementAnalyzer.nextToken(tokenSequence)) {
            return null;
        }
        if (SQLStatementAnalyzer.isKeyword("SELECT", tokenSequence)) {
            return SQLStatementKind.SELECT;
        }
        if (SQLStatementAnalyzer.isKeyword("INSERT", tokenSequence)) {
            return SQLStatementKind.INSERT;
        }
        if (SQLStatementAnalyzer.isKeyword("DROP", tokenSequence)) {
            return SQLStatementKind.DROP;
        }
        if (SQLStatementAnalyzer.isKeyword("UPDATE", tokenSequence)) {
            return SQLStatementKind.UPDATE;
        }
        if (SQLStatementAnalyzer.isKeyword("DELETE", tokenSequence)) {
            return SQLStatementKind.DELETE;
        }
        if (SQLStatementAnalyzer.isKeyword("CREATE", tokenSequence)) {
            return SQLStatementKind.CREATE;
        }
        return null;
    }

    public static boolean isKeyword(CharSequence charSequence, TokenSequence<SQLTokenId> tokenSequence) {
        return tokenSequence.token().id() == SQLTokenId.KEYWORD && StringUtils.textEqualsIgnoreCase(tokenSequence.token().text(), charSequence);
    }

    private static boolean nextToken(TokenSequence<SQLTokenId> tokenSequence) {
        boolean bl;
        block3: while (bl = tokenSequence.moveNext()) {
            switch ((SQLTokenId)tokenSequence.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: {
                    continue block3;
                }
            }
            break;
        }
        return bl;
    }

    protected boolean nextToken() {
        boolean bl = SQLStatementAnalyzer.nextToken(this.seq);
        if (bl && (!(this instanceof SelectStatementAnalyzer) || this.context.isAfter(SQLStatement.Context.SELECT)) && this.context != SQLStatement.Context.BEGIN) {
            return this.parseSubquery();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseSubquery() {
        boolean bl = true;
        if (SQLStatementAnalyzer.isKeyword("SELECT", this.seq)) {
            int n = this.seq.offset();
            int n2 = 1;
            block4: while (bl = this.seq.moveNext()) {
                switch ((SQLTokenId)this.seq.token().id()) {
                    case LPAREN: {
                        ++n2;
                        break;
                    }
                    case RPAREN: {
                        if (--n2 == 0) break block4;
                    }
                }
            }
            if (n2 == 0 || !bl && n2 > 0) {
                TokenSequence tokenSequence;
                SelectStatement selectStatement;
                int n3 = this.seq.offset();
                if (!bl && n2 > 0) {
                    n3 += this.seq.token().length();
                }
                if ((selectStatement = SelectStatementAnalyzer.analyze((TokenSequence<SQLTokenId>)(tokenSequence = this.seq.subSequence(n, n3)), this.quoter)) != null) {
                    this.subqueries.add(selectStatement);
                }
            }
        }
        return bl;
    }

    protected QualIdent parseIdentifier() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getUnquotedIdentifier());
        boolean bl = false;
        block4: while (this.nextToken()) {
            switch ((SQLTokenId)this.seq.token().id()) {
                case DOT: {
                    bl = true;
                    continue block4;
                }
                case IDENTIFIER: {
                    if (bl) {
                        bl = false;
                        arrayList.add(this.getUnquotedIdentifier());
                        continue block4;
                    }
                    this.seq.movePrevious();
                    break block4;
                }
                default: {
                    this.seq.movePrevious();
                    break block4;
                }
            }
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (((String)iterator.next()).length() != 0) continue;
            iterator.remove();
        }
        if (!arrayList.isEmpty()) {
            return new QualIdent(arrayList);
        }
        return null;
    }

    protected String getUnquotedIdentifier() {
        return this.quoter.unquote(((Object)this.seq.token().text()).toString());
    }

    protected void moveToContext(SQLStatement.Context context) {
        this.context = context;
        this.offset2Context.put(this.seq.offset() + this.seq.token().length(), context);
    }

    TableIdent parseTableIdent() {
        QualIdent qualIdent = this.parseIdentifier();
        if (qualIdent == null) {
            return null;
        }
        String string = this.parseAlias();
        return new TableIdent(qualIdent, string);
    }

    private String parseAlias() {
        String string = null;
        block4: while (this.nextToken()) {
            switch ((SQLTokenId)this.seq.token().id()) {
                case IDENTIFIER: {
                    string = this.getUnquotedIdentifier();
                    continue block4;
                }
                case KEYWORD: {
                    if (SQLStatementAnalyzer.isKeyword("AS", this.seq)) continue block4;
                    this.seq.movePrevious();
                    break block4;
                }
                default: {
                    this.seq.movePrevious();
                    break block4;
                }
            }
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    protected TablesClause createTablesClause(List<TableIdent> list) {
        HashSet<QualIdent> hashSet = new HashSet<QualIdent>();
        HashMap<String, QualIdent> hashMap = new HashMap<String, QualIdent>();
        for (TableIdent tableIdent : list) {
            if (tableIdent.getAlias() == null) {
                hashSet.add(tableIdent.getTableName());
                continue;
            }
            if (hashMap.containsKey(tableIdent.getAlias())) continue;
            hashMap.put(tableIdent.getAlias(), tableIdent.getTableName());
        }
        return new TablesClause(Collections.unmodifiableSet(hashSet), Collections.unmodifiableMap(hashMap));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableIdent
    implements Comparable<TableIdent> {
        private final QualIdent tableName;
        private final String alias;

        public TableIdent(QualIdent qualIdent, String string) {
            this.tableName = qualIdent;
            this.alias = string;
        }

        public QualIdent getTableName() {
            return this.tableName;
        }

        public String getAlias() {
            return this.alias;
        }

        @Override
        public int compareTo(TableIdent tableIdent) {
            if (this.getAlias() != null && tableIdent.getAlias() != null) {
                return this.getAlias().compareToIgnoreCase(tableIdent.getAlias());
            }
            return this.getTableName().compareTo(tableIdent.getTableName());
        }

        public String toString() {
            String string = this.getAlias() == null ? "" : this.getAlias() + " alias to ";
            return string + this.getTableName().toString();
        }
    }
}

