/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.api;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HudsonVersion
implements Comparable<HudsonVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\b.*");
    public static final HudsonVersion SUPPORTED_VERSION = new HudsonVersion("1.291");
    private final int major;
    private final int minor;

    public HudsonVersion(String string) {
        Matcher matcher = VERSION_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(string);
        }
        this.major = Integer.parseInt(matcher.group(1));
        this.minor = Integer.parseInt(matcher.group(2));
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HudsonVersion)) {
            return false;
        }
        HudsonVersion hudsonVersion = (HudsonVersion)object;
        return this.major == hudsonVersion.major && this.minor == hudsonVersion.minor;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(HudsonVersion hudsonVersion) {
        if (this.equals(hudsonVersion)) {
            return 0;
        }
        return this.major < hudsonVersion.major ? -1 : (this.major > hudsonVersion.major ? 1 : (this.minor < hudsonVersion.minor ? -1 : (this.minor > hudsonVersion.minor ? 1 : 0)));
    }
}

