/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils;

import java.io.File;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public final class MIMESupport {
    private static final String[] SOURCE_MIME_TYPES = new String[]{"text/x-c++", "text/x-c", "text/x-h", "text/x-fortran", "text/x-asm"};

    private MIMESupport() {
    }

    public static String getFileMIMEType(FileObject fileObject) {
        Parameters.notNull((CharSequence)"file object", (Object)fileObject);
        String string = FileUtil.getMIMEType((FileObject)fileObject, (String[])SOURCE_MIME_TYPES);
        if (string == null) {
            string = FileUtil.getMIMEType((FileObject)fileObject);
        }
        return string;
    }

    public static String getFileMIMEType(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)CndFileUtils.normalizeFile(file));
        String string = fileObject != null ? MIMESupport.getFileMIMEType(fileObject) : MIMESupport.getKnownMIMETypeByExtension(file.getPath());
        return string != null ? string : "content/unknown";
    }

    public static String getKnownMIMETypeByExtension(String string) {
        String string2 = FileUtil.getExtension((String)string);
        for (String string3 : SOURCE_MIME_TYPES) {
            if (!MIMEExtensions.isRegistered(string3, string2)) continue;
            return string3;
        }
        return null;
    }
}

