/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.form.palette.AddToPaletteWizard;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChooseProjectWizardPanel
implements WizardDescriptor.Panel<AddToPaletteWizard> {
    private JFileChooser projectChooser;
    private static String lastDirectoryUsed;
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    ChooseProjectWizardPanel() {
    }

    public Component getComponent() {
        if (this.projectChooser == null) {
            this.projectChooser = ProjectChooser.projectChooser();
            this.projectChooser.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.projectChooser.setName(PaletteUtils.getBundleString("CTL_SelectProject_Caption"));
            this.projectChooser.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
            if (lastDirectoryUsed != null) {
                this.projectChooser.setCurrentDirectory(new File(lastDirectoryUsed));
            }
            this.projectChooser.setControlButtonsAreShown(false);
            this.projectChooser.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    if ("SelectedFileChangedProperty".equals(string) || "directoryChanged".equals(string)) {
                        ChooseProjectWizardPanel.this.cs.fireChange();
                    }
                }
            });
        }
        return this.projectChooser;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("beans.adding");
    }

    public boolean isValid() {
        FileObject fileObject;
        File file;
        if (this.projectChooser != null && (file = this.projectChooser.getSelectedFile()) != null && (fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file))) != null) {
            try {
                Project project = ProjectManager.getDefault().findProject(fileObject);
                if (project != null) {
                    lastDirectoryUsed = this.projectChooser.getCurrentDirectory().getAbsolutePath();
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public void readSettings(AddToPaletteWizard addToPaletteWizard) {
    }

    public void storeSettings(AddToPaletteWizard addToPaletteWizard) {
        if (this.projectChooser == null) {
            return;
        }
        File file = this.projectChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject == null) {
            return;
        }
        Project project = null;
        try {
            project = ProjectManager.getDefault().findProject(fileObject);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        if (project == null) {
            return;
        }
        ArrayList<ClassSource.ProjectEntry> arrayList = new ArrayList<ClassSource.ProjectEntry>();
        for (AntArtifact antArtifact : AntArtifactQuery.findArtifactsByType((Project)project, (String)"jar")) {
            arrayList.add(new ClassSource.ProjectEntry(antArtifact));
        }
        addToPaletteWizard.setJARFiles(arrayList);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }
}

