/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.fakepeer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import org.netbeans.modules.form.fakepeer.FakePeer;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;

public class FakePeerContainer
extends Container {
    public FakePeerContainer() {
        this.setFont(FakePeerSupport.getDefaultAWTFont());
    }

    public void addNotify() {
        FakePeerSupport.attachFakePeerRecursively(this);
        super.addNotify();
    }

    protected void addImpl(Component component, Object object, int n) {
        FakePeerSupport.attachFakePeer(component);
        super.addImpl(component, object, n);
    }

    public void update(Graphics graphics) {
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        SystemColor systemColor = SystemColor.control;
        graphics.setColor(systemColor);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        super.paint(graphics);
        FakePeerContainer.paintFakePeersRecursively(graphics, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void paintFakePeersRecursively(Graphics graphics, Container container) {
        if (!container.isVisible()) {
            return;
        }
        Component[] componentArray = FakePeerSupport.getComponents(container);
        int n = componentArray.length;
        Rectangle rectangle = graphics.getClipBounds();
        for (int i = 0; i < n; ++i) {
            Graphics graphics2;
            Rectangle rectangle2;
            Component component = componentArray[i];
            if (component != null && component.getPeer() instanceof FakePeer && component.isVisible()) {
                rectangle2 = component.getBounds();
                if (rectangle == null || rectangle2.intersects(rectangle)) {
                    graphics2 = graphics.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    graphics2.setFont(component.getFont());
                    try {
                        component.getPeer().paint(graphics2);
                    }
                    finally {
                        graphics2.dispose();
                    }
                }
            }
            if (!(component instanceof Container)) continue;
            rectangle2 = component.getBounds();
            if (rectangle != null && !rectangle2.intersects(rectangle)) continue;
            graphics2 = graphics.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            FakePeerContainer.paintFakePeersRecursively(graphics2, (Container)component);
            graphics2.dispose();
        }
    }
}

