/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.modules.form.ComponentChooserEditor;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADConnectionPropertyEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormPropertyEditorManager {
    private static Map<Class, Class>[] editorClassCache;
    private static Map<Class, List<Class>> expliciteEditors;
    private static Logger logger;

    public static synchronized PropertyEditor findEditor(FormProperty formProperty) {
        FormModel formModel;
        Class clazz = formProperty.getValueType();
        List<PropertyEditor> list = FormPropertyEditorManager.findEditors(clazz, formModel = formProperty.getPropertyContext().getFormModel(), false);
        return list.isEmpty() ? null : list.get(0);
    }

    public static synchronized PropertyEditor[] getAllEditors(FormProperty formProperty) {
        Class clazz = formProperty.getValueType();
        FormModel formModel = formProperty.getPropertyContext().getFormModel();
        List<PropertyEditor> list = FormPropertyEditorManager.findEditors(clazz, formModel, true);
        return list.toArray(new PropertyEditor[list.size()]);
    }

    public static synchronized void registerEditor(Class clazz, Class clazz2) {
        List<Class> list;
        if (expliciteEditors != null) {
            list = expliciteEditors.get(clazz);
        } else {
            list = null;
            expliciteEditors = new HashMap<Class, List<Class>>();
        }
        if (list == null) {
            list = new LinkedList<Class>();
            list.add(clazz2);
            expliciteEditors.put(clazz, list);
        } else if (!list.contains(clazz2)) {
            list.add(clazz2);
        }
    }

    private static List<Class> getRegisteredEditorClasses(Class clazz) {
        List list = expliciteEditors != null ? expliciteEditors.get(clazz) : null;
        return list != null ? list : Collections.EMPTY_LIST;
    }

    private static List<PropertyEditor> findEditors(Class clazz, FormModel formModel, boolean bl) {
        Object object;
        ArrayList<PropertyEditor> arrayList = new ArrayList<PropertyEditor>(5);
        if (FormPropertyEditorManager.isEditorInCache(clazz, 0)) {
            FormPropertyEditorManager.createEditorFromCache(clazz, 0, arrayList);
        } else {
            Object object2 = object = clazz != Object.class && !FormPropertyEditorManager.hasWrappingEditor(clazz) ? PropertyEditorManager.findEditor(clazz) : null;
            if (object != null) {
                arrayList.add((PropertyEditor)object);
            }
            FormPropertyEditorManager.addEditorToCache(clazz, (PropertyEditor)object, 0);
        }
        if (!bl && !arrayList.isEmpty()) {
            return arrayList;
        }
        if (FormPropertyEditorManager.isEditorInCache(clazz, 1)) {
            FormPropertyEditorManager.createEditorFromCache(clazz, 1, arrayList);
        } else {
            object = clazz.getSimpleName();
            if (!((String)object).contains("[")) {
                Class clazz2 = null;
                for (String string : FormLoaderSettings.getInstance().getEditorSearchPath()) {
                    String string2 = string + "." + object + "Editor";
                    try {
                        clazz2 = FormUtils.loadClass(string2, formModel);
                        if (FormPropertyEditorManager.createEditorInstance(clazz2, arrayList)) break;
                        clazz2 = null;
                    }
                    catch (Exception exception) {
                    }
                    catch (LinkageError linkageError) {
                        // empty catch block
                    }
                }
                FormPropertyEditorManager.addEditorClassToCache(clazz, clazz2, 1);
            }
        }
        if (!bl && !arrayList.isEmpty()) {
            return arrayList;
        }
        for (Class clazz2 : FormPropertyEditorManager.getRegisteredEditorClasses(clazz)) {
            FormPropertyEditorManager.createEditorInstance(clazz2, arrayList);
            if (bl) continue;
            return arrayList;
        }
        if (arrayList.isEmpty() && FormPropertyEditorManager.isComponentType(clazz)) {
            arrayList.add(new ComponentChooserEditor(new Class[]{clazz}));
            if (!bl) {
                return arrayList;
            }
        }
        arrayList.add(new RADConnectionPropertyEditor(clazz, RADConnectionPropertyEditor.Type.FormConnection));
        arrayList.add(new RADConnectionPropertyEditor(clazz, RADConnectionPropertyEditor.Type.CustomCode));
        return arrayList;
    }

    private static boolean isEditorInCache(Class clazz, int n) {
        return FormPropertyEditorManager.getEditorClassCache(n).containsKey(clazz);
    }

    private static void createEditorFromCache(Class clazz, int n, List<PropertyEditor> list) {
        Class clazz2 = FormPropertyEditorManager.getEditorClassCache(n).get(clazz);
        if (clazz2 != null) {
            FormPropertyEditorManager.createEditorInstance(clazz2, list);
        }
    }

    private static void addEditorToCache(Class clazz, PropertyEditor propertyEditor, int n) {
        if (propertyEditor == null) {
            FormPropertyEditorManager.addEditorClassToCache(clazz, null, n);
        } else {
            Class<?> clazz2 = propertyEditor.getClass();
            try {
                Constructor<?> constructor = clazz2.getConstructor(new Class[0]);
                if (constructor != null && (constructor.getModifiers() & 1) == 1) {
                    FormPropertyEditorManager.addEditorClassToCache(clazz, clazz2, n);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    private static void addEditorClassToCache(Class clazz, Class clazz2, int n) {
        FormPropertyEditorManager.getEditorClassCache(n).put(clazz, clazz2);
    }

    private static Map<Class, Class> getEditorClassCache(int n) {
        if (editorClassCache == null) {
            editorClassCache = new Map[]{new WeakHashMap(), new WeakHashMap()};
        }
        return editorClassCache[n];
    }

    private static boolean hasWrappingEditor(Class clazz) {
        return clazz == String.class || clazz == Font.class || clazz == Color.class || clazz == Icon.class;
    }

    private static boolean isComponentType(Class clazz) {
        return !clazz.equals(Object.class) && !clazz.equals(String.class) && !clazz.isEnum() && !clazz.isPrimitive() && !Number.class.isAssignableFrom(clazz);
    }

    private static boolean createEditorInstance(Class clazz, List<PropertyEditor> list) {
        try {
            list.add((PropertyEditor)clazz.newInstance());
            return true;
        }
        catch (Exception exception) {
            FormPropertyEditorManager.log(exception, "Error instantiating property editor: " + clazz.getName());
        }
        catch (LinkageError linkageError) {
            FormPropertyEditorManager.log(linkageError, "Error instantiating property editor: " + clazz.getName());
        }
        return false;
    }

    private static void log(Throwable throwable, String string) {
        if (logger == null) {
            logger = Logger.getLogger(FormPropertyEditorManager.class.getName());
        }
        logger.log(Level.INFO, string, throwable);
    }
}

