/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.openide.ErrorManager;

public class FormEvents {
    static final Event[] NO_EVENTS = new Event[0];
    private Map<String, ListenerInfo> usedListeners = new HashMap<String, ListenerInfo>();
    private Map<String, List<Event>> usedMethods = new HashMap<String, List<Event>>();
    private Map<String, List<Event>> eventHandlers = new HashMap<String, List<Event>>();
    private FormModel formModel;

    FormEvents(FormModel formModel) {
        this.formModel = formModel;
    }

    public boolean hasEventsInCEDL() {
        return !this.usedListeners.isEmpty();
    }

    public Class[] getCEDLTypes() {
        Collection<ListenerInfo> collection = this.usedListeners.values();
        Class[] classArray = new Class[collection.size()];
        int n = 0;
        Iterator<ListenerInfo> iterator = collection.iterator();
        while (iterator.hasNext()) {
            classArray[n++] = iterator.next().listenerType;
        }
        return classArray;
    }

    public Event[] getEventsForCEDLMethod(Method method) {
        List<Event> list = this.usedMethods.get(FormEvents.fullMethodName(method));
        if (list == null) {
            return NO_EVENTS;
        }
        Event[] eventArray = new Event[list.size()];
        list.toArray(eventArray);
        return eventArray;
    }

    public Event[] getEventsForHandler(String string) {
        List<Event> list = this.eventHandlers.get(string);
        Event[] eventArray = new Event[list.size()];
        list.toArray(eventArray);
        return eventArray;
    }

    public Method getOriginalListenerMethod(String string) {
        List<Event> list = this.eventHandlers.get(string);
        return list != null ? list.get(0).getListenerMethod() : null;
    }

    public String[] getAllEventHandlers() {
        Set<String> set = this.eventHandlers.keySet();
        String[] stringArray = new String[set.size()];
        set.toArray(stringArray);
        return stringArray;
    }

    public void attachEvent(Event event, String string, String string2) {
        this.attachEvent(event, string, string2, null);
    }

    public void attachEvent(Event event, String string, String string2, String string3) {
        boolean bl = false;
        if (string == null && event.hasEventHandlers()) {
            string = (String)event.getEventHandlerList().get(0);
            event = null;
        } else {
            List<Event> list;
            if (string != null) {
                list = this.eventHandlers.get(string);
                if (list != null) {
                    this.checkCompatibility(event, list.get(0));
                }
            } else {
                list = null;
                string = this.findFreeHandlerName(event, event.getComponent());
            }
            if (list == null) {
                list = new ArrayList<Event>(3);
                this.eventHandlers.put(string, list);
                bl = true;
            }
            if (!event.isInCEDL()) {
                this.registerEventInCEDL(event);
            }
            if (event.addEventHandler(string)) {
                list.add(event);
            } else {
                event = null;
            }
        }
        this.formModel.fireEventHandlerAdded(event, string, string2, string3, bl);
    }

    public void detachEvent(Event event, String string) {
        if (event.removeEventHandler(string)) {
            if (!event.hasEventHandlers()) {
                this.unregisterEventFromCEDL(event);
            }
            this.detachEventHandler(event, string);
        }
    }

    public void detachEvent(Event event) {
        this.unregisterEventFromCEDL(event);
        String[] stringArray = event.getEventHandlers();
        for (int i = 0; i < stringArray.length; ++i) {
            event.removeEventHandler(stringArray[i]);
            this.detachEventHandler(event, stringArray[i]);
        }
    }

    public void renameEventHandler(String string, String string2) {
        if (string == null || string2 == null || string.equals(string2)) {
            return;
        }
        List<Event> list = this.eventHandlers.get(string);
        if (list == null) {
            return;
        }
        if (this.eventHandlers.get(string2) == null) {
            for (int i = 0; i < list.size(); ++i) {
                Event event = list.get(i);
                event.renameEventHandler(string, string2);
            }
        } else {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot rename handler");
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, FormUtils.getBundleString("MSG_CannotRename"));
            throw illegalArgumentException;
        }
        this.eventHandlers.remove(string);
        this.eventHandlers.put(string2, list);
        this.formModel.fireEventHandlerRenamed(string, string2);
    }

    public String findFreeHandlerName(Event event, RADComponent rADComponent) {
        String string = rADComponent == this.formModel.getTopRADComponent() ? "form" : rADComponent.getName();
        String string2 = event.getListenerMethod().getName();
        return this.findFreeHandlerName(string + string2.substring(0, 1).toUpperCase() + string2.substring(1));
    }

    public String findFreeHandlerName(String string) {
        String string2 = string;
        int n = 0;
        while (this.eventHandlers.get(string2) != null) {
            string2 = string + ++n;
        }
        return string2;
    }

    static String getEventIdName(Method method) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("$");
        stringBuffer.append(method.getDeclaringClass().getName());
        stringBuffer.append(".");
        stringBuffer.append(method.getName());
        stringBuffer.append("(");
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(classArray[i].getName());
            if (i + 1 >= classArray.length) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void registerEventInCEDL(Event event) {
        Class<?> clazz = event.getEventSetDescriptor().getListenerType();
        if (!clazz.isInterface()) {
            return;
        }
        Class<?>[] classArray = event.getListenerMethod().getParameterTypes();
        if (classArray.length == 0 || !EventObject.class.isAssignableFrom(classArray[0])) {
            return;
        }
        if (!this.addEventToMethod(event)) {
            return;
        }
        String string = clazz.getName();
        ListenerInfo listenerInfo = this.usedListeners.get(string);
        if (listenerInfo == null) {
            listenerInfo = new ListenerInfo(clazz);
            this.usedListeners.put(string, listenerInfo);
        } else {
            listenerInfo.listenerType = clazz;
        }
        ++listenerInfo.useCount;
        event.setInCEDL(true);
    }

    private void unregisterEventFromCEDL(Event event) {
        if (this.removeEventFromMethod(event)) {
            String string = event.getEventSetDescriptor().getListenerType().getName();
            ListenerInfo listenerInfo = this.usedListeners.get(string);
            if (listenerInfo != null && --listenerInfo.useCount == 0) {
                this.usedListeners.remove(string);
            }
            event.setInCEDL(false);
        }
    }

    private boolean addEventToMethod(Event event) {
        String string = FormEvents.fullMethodName(event.getListenerMethod());
        List<Event> list = this.usedMethods.get(string);
        if (list == null) {
            list = new ArrayList<Event>();
            list.add(event);
            this.usedMethods.put(string, list);
        } else {
            for (Event event2 : list) {
                if (event2.getComponent() != event.getComponent()) continue;
                return false;
            }
            list.add(event);
        }
        return true;
    }

    private boolean removeEventFromMethod(Event event) {
        boolean bl;
        String string = FormEvents.fullMethodName(event.getListenerMethod());
        List<Event> list = this.usedMethods.get(string);
        if (list != null) {
            bl = list.remove(event);
            if (list.size() == 0) {
                this.usedMethods.remove(string);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private void detachEventHandler(Event event, String string) {
        List<Event> list = this.eventHandlers.get(string);
        list.remove(event);
        if (list.size() == 0) {
            this.eventHandlers.remove(string);
        }
        this.formModel.fireEventHandlerRemoved(event, string, list.size() == 0);
    }

    private void checkCompatibility(Event event, Event event2) {
        boolean bl;
        Class<?>[] classArray;
        Method method = event.getListenerMethod();
        Method method2 = event2.getListenerMethod();
        Class<?>[] classArray2 = method.getParameterTypes();
        if (classArray2.length == (classArray = method2.getParameterTypes()).length) {
            bl = true;
            for (int i = 0; i < classArray2.length; ++i) {
                if (classArray2[i].getName().equals(classArray[i].getName())) continue;
                bl = false;
                break;
            }
            if (bl) {
                bl = method.getReturnType().equals(method2.getReturnType());
            }
        } else {
            bl = false;
        }
        if (!bl) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Incompatible event");
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, FormUtils.getBundleString("MSG_CannotAttach"));
            throw illegalArgumentException;
        }
    }

    private static String fullMethodName(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(method.getName());
        stringBuffer.append("(");
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(classArray[i].getName());
            if (i + 1 >= classArray.length) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static class ListenerInfo {
        Class listenerType;
        int useCount;

        ListenerInfo(Class clazz) {
            this.listenerType = clazz;
        }
    }
}

