/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.ui.support;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class NodeFactorySupport {
    private static NodeListKeyWrapper LOADING_KEY = new NodeListKeyWrapper(null, null);

    private NodeFactorySupport() {
    }

    public static Children createCompositeChildren(Project project, String string) {
        return new DelegateChildren(project, string);
    }

    public static NodeList fixedNodeList(Node ... nodeArray) {
        return new FixedNodeList(nodeArray);
    }

    static Node createWaitNode() {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        abstractNode.setIconBaseWithExtension("org/openide/nodes/wait.gif");
        abstractNode.setDisplayName(NbBundle.getMessage(ChildFactory.class, (String)"LBL_WAIT"));
        return abstractNode;
    }

    private static class NodeListKeyWrapper {
        NodeList nodeList;
        Object object;

        NodeListKeyWrapper(Object object, NodeList nodeList) {
            this.nodeList = nodeList;
            this.object = object;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NodeListKeyWrapper nodeListKeyWrapper = (NodeListKeyWrapper)object;
            if (!(this.nodeList == nodeListKeyWrapper.nodeList || this.nodeList != null && this.nodeList.equals(nodeListKeyWrapper.nodeList))) {
                return false;
            }
            return this.object == nodeListKeyWrapper.object || this.object != null && this.object.equals(nodeListKeyWrapper.object);
        }

        public int hashCode() {
            int n = 3;
            n = 67 * n + (this.nodeList != null ? this.nodeList.hashCode() : 0);
            n = 67 * n + (this.object != null ? this.object.hashCode() : 0);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DelegateChildren
    extends Children.Keys<NodeListKeyWrapper>
    implements LookupListener,
    ChangeListener {
        private String folderPath;
        private Project project;
        private List<NodeList<?>> nodeLists = new ArrayList();
        private List<NodeFactory> factories = new ArrayList<NodeFactory>();
        private Lookup.Result<NodeFactory> result;
        private final HashMap<NodeList<?>, List<NodeListKeyWrapper>> keys;
        private RequestProcessor.Task task;

        public DelegateChildren(Project project, String string) {
            this.folderPath = string;
            this.project = project;
            this.keys = new HashMap();
        }

        protected Lookup createLookup() {
            return Lookups.forPath((String)this.folderPath);
        }

        protected Node[] createNodes(NodeListKeyWrapper nodeListKeyWrapper) {
            if (nodeListKeyWrapper == LOADING_KEY) {
                return new Node[]{NodeFactorySupport.createWaitNode()};
            }
            Node node = nodeListKeyWrapper.nodeList.node(nodeListKeyWrapper.object);
            if (node != null) {
                return new Node[]{node};
            }
            return new Node[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<NodeListKeyWrapper> createKeys() {
            ArrayList<NodeListKeyWrapper> arrayList = new ArrayList<NodeListKeyWrapper>();
            assert (!Thread.holdsLock(this.keys));
            DelegateChildren delegateChildren = this;
            synchronized (delegateChildren) {
                for (NodeList<?> nodeList : this.nodeLists) {
                    List<NodeListKeyWrapper> list;
                    HashMap<NodeList<?>, List<NodeListKeyWrapper>> hashMap = this.keys;
                    synchronized (hashMap) {
                        list = this.keys.get(nodeList);
                    }
                    if (list == null) continue;
                    arrayList.addAll(list);
                }
            }
            return arrayList;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(Collections.singleton(LOADING_KEY));
            this.task = RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    DelegateChildren delegateChildren = DelegateChildren.this;
                    synchronized (delegateChildren) {
                        DelegateChildren.this.result = DelegateChildren.this.createLookup().lookupResult(NodeFactory.class);
                        for (NodeFactory nodeFactory : DelegateChildren.this.result.allInstances()) {
                            NodeList<?> nodeList = nodeFactory.createNodes(DelegateChildren.this.project);
                            assert (nodeList != null) : "Factory " + nodeFactory.getClass() + " has broken the NodeFactory contract.";
                            nodeList.addNotify();
                            List<?> list = nodeList.keys();
                            HashMap hashMap = DelegateChildren.this.keys;
                            synchronized (hashMap) {
                                DelegateChildren.this.nodeLists.add(nodeList);
                                DelegateChildren.this.addKeys(nodeList, list);
                            }
                            nodeList.addChangeListener(DelegateChildren.this);
                            DelegateChildren.this.factories.add(nodeFactory);
                        }
                        DelegateChildren.this.result.addLookupListener((LookupListener)DelegateChildren.this);
                    }
                    DelegateChildren.this.setKeys(DelegateChildren.this.createKeys());
                    DelegateChildren.this.task = null;
                }
            });
        }

        public Node[] getNodes(boolean bl) {
            Node[] nodeArray = super.getNodes(bl);
            RequestProcessor.Task task = this.task;
            if (bl && task != null) {
                task.waitFinished();
                nodeArray = super.getNodes(bl);
            }
            return nodeArray;
        }

        public int getNodesCount(boolean bl) {
            int n = super.getNodesCount(bl);
            RequestProcessor.Task task = this.task;
            if (bl && task != null) {
                task.waitFinished();
                n = super.getNodesCount(bl);
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeNotify() {
            super.removeNotify();
            this.setKeys(Collections.emptySet());
            DelegateChildren delegateChildren = this;
            synchronized (delegateChildren) {
                for (NodeList<?> nodeList : this.nodeLists) {
                    nodeList.removeChangeListener(this);
                    nodeList.removeNotify();
                }
                HashMap<NodeList<?>, List<NodeListKeyWrapper>> hashMap = this.keys;
                synchronized (hashMap) {
                    this.keys.clear();
                    this.nodeLists.clear();
                }
                this.factories.clear();
                if (this.result != null) {
                    this.result.removeLookupListener((LookupListener)this);
                    this.result = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            NodeList nodeList = (NodeList)changeEvent.getSource();
            List list = nodeList.keys();
            Object object = this.keys;
            synchronized (object) {
                this.removeKeys(nodeList);
                this.addKeys(nodeList, list);
            }
            object = this.createKeys();
            EventQueue.invokeLater(new RunnableImpl(this, (Collection<NodeListKeyWrapper>)object));
        }

        private void addKeys(NodeList nodeList, List list) {
            assert (Thread.holdsLock(this.keys));
            ArrayList<NodeListKeyWrapper> arrayList = new ArrayList<NodeListKeyWrapper>();
            for (Object e : list) {
                arrayList.add(new NodeListKeyWrapper(e, nodeList));
            }
            this.keys.put(nodeList, arrayList);
        }

        private void removeKeys(NodeList nodeList) {
            assert (Thread.holdsLock(this.keys));
            this.keys.remove(nodeList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent lookupEvent) {
            int n = 0;
            DelegateChildren delegateChildren = this;
            synchronized (delegateChildren) {
                Lookup.Result result = (Lookup.Result)lookupEvent.getSource();
                for (Object e : result.allInstances()) {
                    Object object;
                    Object object2;
                    NodeFactory nodeFactory = (NodeFactory)e;
                    if (!this.factories.contains(nodeFactory)) {
                        this.factories.add(n, nodeFactory);
                        object2 = nodeFactory.createNodes(this.project);
                        assert (object2 != null);
                        object = object2.keys();
                        HashMap<NodeList<?>, List<NodeListKeyWrapper>> hashMap = this.keys;
                        synchronized (hashMap) {
                            this.nodeLists.add(n, (NodeList<?>)object2);
                            this.addKeys((NodeList)object2, (List)object);
                        }
                        object2.addNotify();
                        object2.addChangeListener(this);
                    } else {
                        while (!nodeFactory.equals(this.factories.get(n))) {
                            this.factories.remove(n);
                            object2 = this.keys;
                            synchronized (object2) {
                                object = this.nodeLists.remove(n);
                                this.removeKeys((NodeList)object);
                                object.removeNotify();
                                object.removeChangeListener(this);
                            }
                        }
                    }
                    ++n;
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DelegateChildren.this.setKeys(DelegateChildren.this.createKeys());
                }
            });
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class RunnableImpl
        implements Runnable {
            private Collection<NodeListKeyWrapper> ks;
            private DelegateChildren ch;

            public RunnableImpl(DelegateChildren delegateChildren, Collection<NodeListKeyWrapper> collection) {
                this.ks = collection;
                this.ch = delegateChildren;
            }

            @Override
            public void run() {
                this.ch.setKeys(this.ks);
                this.ch = null;
                this.ks = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedNodeList
    implements NodeList<Node> {
        private List<Node> nodes;

        FixedNodeList(Node ... nodeArray) {
            this.nodes = Arrays.asList(nodeArray);
        }

        @Override
        public List<Node> keys() {
            return this.nodes;
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void addNotify() {
        }

        @Override
        public void removeNotify() {
        }

        @Override
        public Node node(Node node) {
            return node;
        }
    }
}

