/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.toolsui;

import java.awt.Component;
import java.awt.Image;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.dlight.toolsui.DLightConfigurationUIWrapper;
import org.netbeans.modules.dlight.toolsui.DLightToolUIWrapper;
import org.openide.util.ImageUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolsTable
extends JTable {
    private final List<DLightToolUIWrapper> allDLightTools;
    private final DLightConfigurationUIWrapper dlightConfigurationUIWrapper;

    public ToolsTable(DLightConfigurationUIWrapper dLightConfigurationUIWrapper, List<DLightToolUIWrapper> list, ListSelectionListener listSelectionListener) {
        this.allDLightTools = list;
        this.dlightConfigurationUIWrapper = dLightConfigurationUIWrapper;
        if (this.getRowHeight() < 20) {
            this.setRowHeight(20);
        }
        this.setModel(new MyTableModel());
        this.getAccessibleContext().setAccessibleDescription("");
        this.getAccessibleContext().setAccessibleName("");
        this.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.getColumnModel().getColumn(0).setMaxWidth(30);
        this.setTableHeader(null);
        this.getSelectionModel().setSelectionMode(0);
        this.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void initSelection() {
        int n = 0;
        for (DLightToolUIWrapper dLightToolUIWrapper : this.allDLightTools) {
            if (dLightToolUIWrapper.isEnabled()) {
                this.getSelectionModel().setSelectionInterval(n, n);
                return;
            }
            ++n;
        }
    }

    @Override
    public boolean getShowHorizontalLines() {
        return false;
    }

    @Override
    public boolean getShowVerticalLines() {
        return false;
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        return new MyTableCellRenderer();
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        if (n2 == 0) {
            DLightToolUIWrapper dLightToolUIWrapper = this.allDLightTools.get(n);
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setSelected(dLightToolUIWrapper.isEnabled());
            jCheckBox.setEnabled(dLightToolUIWrapper.canEnable());
            return new DefaultCellEditor(jCheckBox);
        }
        return super.getCellEditor(n, n2);
    }

    class MyTableModel
    extends DefaultTableModel {
        MyTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return ToolsTable.this.allDLightTools.size();
        }

        public Object getValueAt(int n, int n2) {
            return ToolsTable.this.allDLightTools.get(n);
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                DLightToolUIWrapper dLightToolUIWrapper = (DLightToolUIWrapper)ToolsTable.this.allDLightTools.get(n);
                return dLightToolUIWrapper.canEnable();
            }
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                DLightToolUIWrapper dLightToolUIWrapper = (DLightToolUIWrapper)ToolsTable.this.allDLightTools.get(n);
                ToolsTable.this.dlightConfigurationUIWrapper.setToolEnabled(dLightToolUIWrapper, !dLightToolUIWrapper.isEnabled());
            }
        }
    }

    class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        Image emptyImage = ImageUtilities.loadImage((String)"/org/openide/resources/actions/empty.gif");

        MyTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            DLightToolUIWrapper dLightToolUIWrapper = (DLightToolUIWrapper)ToolsTable.this.allDLightTools.get(n);
            if (n2 == 0) {
                JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.setSelected(dLightToolUIWrapper.isEnabled());
                jCheckBox.setBackground(jLabel.getBackground());
                jCheckBox.setEnabled(dLightToolUIWrapper.canEnable());
                return jCheckBox;
            }
            jLabel.setText(dLightToolUIWrapper.getDLightTool().getName());
            Image image = null;
            if (dLightToolUIWrapper.getDLightTool().hasIcon()) {
                image = ImageUtilities.loadImage((String)dLightToolUIWrapper.getDLightTool().getIconPath());
            }
            if (image == null) {
                image = this.emptyImage;
            }
            jLabel.setIcon(ImageUtilities.image2Icon((Image)image));
            jLabel.setToolTipText(null);
            return jLabel;
        }
    }
}

