/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.swing.JOptionPane;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.ui.RefactoringActionsProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PackagetoTreePathHandleTask
implements Runnable,
CancellableTask<CompilationController> {
    private static final String JAVA_EXTENSION = "java";
    public CompilationInfo cinfo;
    private final Collection<FileObject> javaFileObjects = new HashSet<FileObject>();
    private final Collection<TreePathHandle> handles = new ArrayList<TreePathHandle>();

    public PackagetoTreePathHandleTask(Collection<? extends Node> collection) {
        for (Node node : collection) {
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            FileObject fileObject = dataObject.getPrimaryFile();
            this.javaFileObjects.addAll(PackagetoTreePathHandleTask.findJavaSourceFiles(fileObject));
        }
    }

    public void cancel() {
    }

    public void run(CompilationController compilationController) throws Exception {
        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        this.cinfo = compilationController;
        CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
        for (Tree tree : compilationUnitTree.getTypeDecls()) {
            Element element = compilationController.getTrees().getElement(TreePath.getPath(compilationUnitTree, tree));
            if (element == null || !element.getKind().isClass() && !element.getKind().isInterface() || element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            TreePathHandle treePathHandle = TreePathHandle.create((TreePath)TreePath.getPath(compilationUnitTree, tree), (CompilationInfo)compilationController);
            this.handles.add(treePathHandle);
        }
    }

    @Override
    public void run() {
        FileObject fileObject2;
        for (FileObject fileObject2 : this.javaFileObjects) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject2);
            assert (javaSource != null);
            try {
                javaSource.runUserActionTask((Task)this, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        fileObject2 = this.createRefactoringUI(this.handles, this.cinfo);
        if (fileObject2 != null) {
            UI.openRefactoringUI((RefactoringUI)fileObject2, (TopComponent)topComponent);
        } else {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_CannotRenameKeyword"));
        }
    }

    protected final FileObject[] getFileHandles() {
        return this.javaFileObjects.toArray(new FileObject[0]);
    }

    protected abstract RefactoringUI createRefactoringUI(Collection<TreePathHandle> var1, CompilationInfo var2);

    public static Collection<FileObject> findJavaSourceFiles(FileObject fileObject) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        PackagetoTreePathHandleTask.addSourcesInPackage(fileObject, arrayList);
        return arrayList;
    }

    private static void addSourcesInPackage(FileObject fileObject, Collection<FileObject> collection) {
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (!fileObject2.isData() || !JAVA_EXTENSION.equalsIgnoreCase(fileObject2.getExt())) continue;
            collection.add(fileObject2);
        }
    }
}

