/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.kenai;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.PasswordAuthentication;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.MissingResourceException;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.RepositoryUser;
import org.netbeans.modules.bugtracking.util.KenaiUtil;
import org.netbeans.modules.bugtracking.util.TextUtils;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.kenai.KenaiConfiguration;
import org.netbeans.modules.bugzilla.kenai.KenaiQuery;
import org.netbeans.modules.bugzilla.kenai.KenaiQueryController;
import org.netbeans.modules.bugzilla.query.QueryParameter;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.ui.api.NbModuleOwnerSupport;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KenaiRepository
extends BugzillaRepository
implements PropertyChangeListener {
    static final String ICON_PATH = "org/netbeans/modules/bugtracking/ui/resources/kenai-small.png";
    private String urlParam;
    private Image icon;
    private final String product;
    private KenaiQuery myIssues;
    private KenaiQuery allIssues;
    private String host;
    private final Object kenaiProject;

    KenaiRepository(KenaiProject kenaiProject, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        super(KenaiRepository.getRepositoryId(string, string2), string, string2, string4, string5, null, null);
        this.urlParam = string6;
        this.icon = ImageUtilities.loadImage((String)ICON_PATH, (boolean)true);
        this.product = string7;
        this.host = string3;
        assert (kenaiProject != null);
        this.kenaiProject = kenaiProject;
        Kenai.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public KenaiRepository(KenaiProject kenaiProject, String string, String string2, String string3, String string4, String string5) {
        this(kenaiProject, string, string2, string3, KenaiRepository.getKenaiUser(), KenaiRepository.getKenaiPassword(), string4, string5);
    }

    @Override
    public Image getIcon() {
        return this.icon;
    }

    @Override
    public Query createQuery() {
        KenaiQuery kenaiQuery = new KenaiQuery(null, (BugzillaRepository)this, null, this.product, false, false);
        return kenaiQuery;
    }

    @Override
    public Issue createIssue() {
        return super.createIssue();
    }

    @Override
    public synchronized Query[] getQueries() {
        Query[] queryArray = super.getQueries();
        Query[] queryArray2 = this.getDefinedQueries();
        Query[] queryArray3 = new Query[queryArray.length + queryArray2.length];
        System.arraycopy(queryArray, 0, queryArray3, 0, queryArray.length);
        System.arraycopy(queryArray2, 0, queryArray3, queryArray.length, queryArray2.length);
        return queryArray3;
    }

    private Query[] getDefinedQueries() {
        Query query;
        ArrayList<Query> arrayList = new ArrayList<Query>();
        Query query2 = this.getMyIssuesQuery();
        if (query2 != null) {
            arrayList.add(query2);
        }
        if ((query = this.getAllIssuesQuery()) != null) {
            arrayList.add(query);
        }
        return arrayList.toArray(new Query[arrayList.size()]);
    }

    synchronized Query getAllIssuesQuery() throws MissingResourceException {
        if (!this.providePredefinedQueries() || BugzillaUtil.isNbRepository(this)) {
            return null;
        }
        if (this.allIssues == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer = new StringBuffer();
            stringBuffer.append(this.urlParam);
            stringBuffer.append(MessageFormat.format("&product={0}&bug_status=UNCONFIRMED&bug_status=NEW&bug_status=ASSIGNED&bug_status=REOPENED", this.product));
            this.allIssues = new KenaiQuery(NbBundle.getMessage(KenaiRepository.class, (String)"LBL_AllIssues"), (BugzillaRepository)this, stringBuffer.toString(), this.product, true, true);
        }
        return this.allIssues;
    }

    synchronized Query getMyIssuesQuery() throws MissingResourceException {
        if (!this.providePredefinedQueries()) {
            return null;
        }
        if (this.myIssues == null) {
            String string = this.getQueryUrl();
            this.myIssues = new KenaiQuery(NbBundle.getMessage(KenaiRepository.class, (String)"LBL_MyIssues"), (BugzillaRepository)this, string.toString(), this.product, true, true);
        }
        return this.myIssues;
    }

    private String getQueryUrl() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.urlParam);
        String string = KenaiRepository.getKenaiUser();
        if (string == null) {
            string = "";
        }
        String string2 = string + "@" + this.host;
        stringBuffer.append(MessageFormat.format("&product={0}&bug_status=UNCONFIRMED&bug_status=NEW&bug_status=ASSIGNED&bug_status=REOPENED&emailassigned_to1=1&emailreporter1=1&emailtype1=exact&email1={1}", this.product, string2));
        return stringBuffer.toString();
    }

    @Override
    public synchronized void refreshConfiguration() {
        KenaiConfiguration kenaiConfiguration = (KenaiConfiguration)this.getConfiguration();
        kenaiConfiguration.reset();
        super.refreshConfiguration();
    }

    @Override
    protected BugzillaConfiguration createConfiguration(boolean bl) {
        KenaiConfiguration kenaiConfiguration = new KenaiConfiguration(this, this.product);
        kenaiConfiguration.initialize(this, bl);
        return kenaiConfiguration;
    }

    protected void setCredentials(String string, String string2) {
        super.setTaskRepository(this.getDisplayName(), this.getUrl(), string, string2, null, null, this.isShortUsernamesEnabled());
    }

    @Override
    public boolean authenticate(String string) {
        PasswordAuthentication passwordAuthentication = KenaiUtil.getPasswordAuthentication((boolean)true);
        if (passwordAuthentication == null) {
            return false;
        }
        String string2 = passwordAuthentication.getUserName();
        char[] cArray = passwordAuthentication.getPassword();
        this.setCredentials(string2, new String(cArray));
        return true;
    }

    @Override
    protected Object[] getLookupObjects() {
        Object[] objectArray = super.getLookupObjects();
        Object[] objectArray2 = new Object[objectArray.length + 2];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray2.length - 2] = this.kenaiProject;
        objectArray2[objectArray2.length - 1] = Bugzilla.getInstance().getKenaiSupport();
        return objectArray2;
    }

    public String getProductName() {
        return this.product;
    }

    private static String getKenaiUser() {
        PasswordAuthentication passwordAuthentication = KenaiUtil.getPasswordAuthentication((boolean)false);
        if (passwordAuthentication != null) {
            return passwordAuthentication.getUserName();
        }
        return "";
    }

    private static String getKenaiPassword() {
        PasswordAuthentication passwordAuthentication = KenaiUtil.getPasswordAuthentication((boolean)false);
        if (passwordAuthentication != null) {
            return new String(passwordAuthentication.getPassword());
        }
        return "";
    }

    @Override
    protected QueryParameter[] getSimpleSearchParameters() {
        List list;
        ArrayList<QueryParameter.SimpleQueryParameter> arrayList = new ArrayList<QueryParameter.SimpleQueryParameter>();
        arrayList.add(new QueryParameter.SimpleQueryParameter("product", new String[]{this.product}));
        Node[] nodeArray = WindowManager.getDefault().getRegistry().getActivatedNodes();
        NbModuleOwnerSupport.OwnerInfo ownerInfo = this.getOwnerInfo(nodeArray);
        if (ownerInfo != null && ownerInfo.getOwner().equals(this.product) && (list = ownerInfo.getExtraData()) != null && list.size() > 0) {
            arrayList.add(new QueryParameter.SimpleQueryParameter("component", new String[]{(String)list.get(0)}));
        }
        return arrayList.toArray(new QueryParameter[arrayList.size()]);
    }

    @Override
    public Collection<RepositoryUser> getUsers() {
        return KenaiUtil.getProjectMembers((String)this.product.toLowerCase());
    }

    public String getHost() {
        return this.host;
    }

    private static String getRepositoryId(String string, String string2) {
        return TextUtils.encodeURL((String)string2) + ":" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("login")) {
            String string;
            String string2;
            PasswordAuthentication passwordAuthentication = KenaiUtil.getPasswordAuthentication((boolean)false);
            if (passwordAuthentication != null) {
                string2 = passwordAuthentication.getUserName();
                string = new String(passwordAuthentication.getPassword());
            } else {
                string2 = "";
                string = "";
            }
            this.setCredentials(string2, string);
            KenaiRepository kenaiRepository = this;
            synchronized (kenaiRepository) {
                if (propertyChangeEvent.getNewValue() != null && this.myIssues != null) {
                    KenaiQueryController kenaiQueryController = (KenaiQueryController)this.myIssues.getController();
                    String string3 = this.getQueryUrl();
                    kenaiQueryController.populate(string3);
                    this.myIssues.setUrlParameters(string3);
                }
            }
        }
    }

    @Override
    public NbModuleOwnerSupport.OwnerInfo getOwnerInfo(Node[] nodeArray) {
        NbModuleOwnerSupport.OwnerInfo ownerInfo = super.getOwnerInfo(nodeArray);
        if (ownerInfo != null) {
            if (ownerInfo.getOwner().equals(this.product)) {
                return ownerInfo;
            }
            Bugzilla.LOG.warning(" returned owner [" + ownerInfo.getOwner() + "] for " + nodeArray[0] + " is different then product [" + this.product + "]");
            return null;
        }
        return null;
    }

    private boolean providePredefinedQueries() {
        String string = System.getProperty("org.netbeans.modules.bugzilla.noPredefinedQueries");
        return !"true".equals(string);
    }
}

