/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.project.ui.groups.Group;
import org.openide.NotificationLineSupport;
import org.openide.util.NbBundle;

public abstract class GroupEditPanel
extends JPanel {
    private NotificationLineSupport supp;

    public abstract void applyChanges();

    void setNotificationLineSupport(NotificationLineSupport notificationLineSupport) {
        this.supp = notificationLineSupport;
    }

    NotificationLineSupport getNotificationLineSupport() {
        return this.supp;
    }

    void startPerformingNameChecks(final JTextField jTextField, final String string) {
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.doCheck();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.doCheck();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.doCheck();
            }

            private void doCheck() {
                GroupEditPanel.this.getNotificationLineSupport().clearMessages();
                String string2 = jTextField.getText();
                if (!string2.equals(string)) {
                    for (Group group : Group.allGroups()) {
                        if (!string2.equals(group.getNameOrNull())) continue;
                        GroupEditPanel.this.getNotificationLineSupport().setWarningMessage(NbBundle.getBundle(GroupEditPanel.class).getString("WARN_GroupExists"));
                    }
                }
            }
        });
    }
}

