/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Vector;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.expressions.ExpressionJavaPrinter;
import oracle.toplink.essentials.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.essentials.internal.expressions.SQLSelectStatement;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.InMemoryQueryIndirectionPolicy;

public class ConstantExpression
extends Expression {
    protected Object value;
    protected Expression localBase;

    public ConstantExpression() {
    }

    public ConstantExpression(Object newValue, Expression baseExpression) {
        this.value = newValue;
        this.localBase = baseExpression;
    }

    public String descriptionOfNodeType() {
        return "Constant";
    }

    public ExpressionBuilder getBuilder() {
        return this.getLocalBase().getBuilder();
    }

    protected Expression getLocalBase() {
        return this.localBase;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isConstantExpression() {
        return true;
    }

    public boolean isValueExpression() {
        return true;
    }

    protected void postCopyIn(Dictionary alreadyDone) {
        super.postCopyIn(alreadyDone);
        this.localBase = this.localBase.copiedVersionFrom(alreadyDone);
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        Object value = this.getLocalBase().getFieldValue(this.getValue());
        if (value == null) {
            printer.printNull(this);
        } else {
            printer.printPrimitive(value);
        }
    }

    public void printSQLWithoutConversion(ExpressionSQLPrinter printer) {
        printer.printPrimitive(this.getValue());
    }

    public void printJava(ExpressionJavaPrinter printer) {
        printer.printJava(this.getValue());
    }

    public Expression rebuildOn(Expression newBase) {
        ConstantExpression result = (ConstantExpression)this.clone();
        ((Expression)result).setLocalBase(this.getLocalBase().rebuildOn(newBase));
        return result;
    }

    public void setLocalBase(Expression e) {
        this.localBase = e;
    }

    public Expression twistedForBaseAndContext(Expression newBase, Expression context) {
        return (Expression)this.clone();
    }

    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, InMemoryQueryIndirectionPolicy valueHolderPolicy, boolean isObjectUnregistered) {
        return this.getLocalBase().getFieldValue(this.getValue());
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(String.valueOf(this.getValue()));
    }

    public void writeFields(ExpressionSQLPrinter printer, Vector newFields, SQLSelectStatement statement) {
        if (printer.isFirstElementPrinted()) {
            printer.printString(", ");
        } else {
            printer.setIsFirstElementPrinted(true);
        }
        newFields.addElement(new DatabaseField("*"));
        this.printSQL(printer);
    }
}

