/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.spi.model.TypesProvider;
import org.openide.util.Lookup;

public final class CsmTypes {
    private static TypesProvider provider;

    private CsmTypes() {
    }

    public static CsmType createType(CsmClassifier csmClassifier, TypeDescriptor typeDescriptor, OffsetDescriptor offsetDescriptor) {
        return CsmTypes.getProvider().createType(csmClassifier, typeDescriptor, offsetDescriptor);
    }

    public static CsmType createType(CsmType csmType, TypeDescriptor typeDescriptor) {
        return CsmTypes.getProvider().createType(csmType, typeDescriptor);
    }

    public static CsmType createSimpleType(CsmClassifier csmClassifier, OffsetDescriptor offsetDescriptor) {
        return CsmTypes.getProvider().createType(csmClassifier, new TypeDescriptor(false, false, 0, 0), offsetDescriptor);
    }

    public static CsmType createConstType(CsmType csmType) {
        return CsmTypes.getProvider().createType(csmType, new TypeDescriptor(true, csmType.isReference(), csmType.getPointerDepth(), csmType.getArrayDepth()));
    }

    public static CsmType createDereferencedType(CsmType csmType) {
        int n = csmType.getArrayDepth();
        int n2 = csmType.getPointerDepth();
        if (n2 > 0) {
            --n2;
        } else {
            n = Math.max(n - 1, 0);
        }
        return CsmTypes.getProvider().createType(csmType, new TypeDescriptor(csmType.isConst(), csmType.isReference(), n2, n));
    }

    private static TypesProvider getProvider() {
        if (ProviderInstanceHolder.provider == null) {
            throw new IllegalStateException("no any avaiable org.netbeans.modules.cnd.spi.model.TypesProvider instances");
        }
        return ProviderInstanceHolder.provider;
    }

    private static final class ProviderInstanceHolder {
        private static final TypesProvider provider = (TypesProvider)Lookup.getDefault().lookup(TypesProvider.class);

        private ProviderInstanceHolder() {
        }
    }

    public static final class TypeDescriptor {
        private final boolean _const;
        private final boolean _reference;
        private final int _ptrDepth;
        private final int _arrDepth;

        public TypeDescriptor(boolean bl, boolean bl2, int n, int n2) {
            this._const = bl;
            this._reference = bl2;
            this._ptrDepth = n;
            this._arrDepth = n2;
        }

        public int getArrDepth() {
            return this._arrDepth;
        }

        public boolean isConst() {
            return this._const;
        }

        public int getPtrDepth() {
            return this._ptrDepth;
        }

        public boolean isReference() {
            return this._reference;
        }
    }

    public static final class OffsetDescriptor {
        private final CsmFile container;
        private final int start;
        private final int end;

        public OffsetDescriptor(CsmFile csmFile, int n, int n2) {
            this.container = csmFile;
            this.start = n;
            this.end = n2;
        }

        public CsmFile getContainer() {
            return this.container;
        }

        public int getEndOffset() {
            return this.end;
        }

        public int getStartOffset() {
            return this.start;
        }
    }
}

