/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpModuleProperties;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.api.PhpLanguageOptions;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.TransferFile;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.modules.php.project.ui.actions.DownloadCommand;
import org.netbeans.modules.php.project.ui.actions.RemoteCommand;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.wizards.CancelablePanel;
import org.netbeans.modules.php.project.ui.wizards.ConfigureProjectPanel;
import org.netbeans.modules.php.project.ui.wizards.PhpFrameworksPanel;
import org.netbeans.modules.php.project.ui.wizards.RemoteConfirmationPanel;
import org.netbeans.modules.php.project.ui.wizards.RunConfigurationPanel;
import org.netbeans.modules.php.project.util.PhpProjectGenerator;
import org.netbeans.modules.php.spi.phpmodule.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleExtender;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewPhpProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    private final WizardType wizardType;
    private WizardDescriptor descriptor;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private int index;

    public NewPhpProjectWizardIterator() {
        this(WizardType.NEW);
    }

    private NewPhpProjectWizardIterator(WizardType wizardType) {
        this.wizardType = wizardType;
    }

    public static NewPhpProjectWizardIterator existing() {
        return new NewPhpProjectWizardIterator(WizardType.EXISTING);
    }

    public static NewPhpProjectWizardIterator remote() {
        return new NewPhpProjectWizardIterator(WizardType.REMOTE);
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.descriptor = wizardDescriptor;
        this.index = 0;
        this.panels = this.createPanels();
        this.initDescriptor(wizardDescriptor);
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        WizardDescriptor.Panel<WizardDescriptor> panel = this.current();
        if (panel instanceof CancelablePanel) {
            ((CancelablePanel)panel).cancel();
        }
        this.panels = null;
        this.descriptor = null;
    }

    public Set<FileObject> instantiate() throws IOException {
        assert (false) : "Cannot call this method if implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public Set<FileObject> instantiate(ProgressHandle progressHandle) throws IOException {
        final HashSet<FileObject> hashSet = new HashSet<FileObject>();
        final Map<PhpFrameworkProvider, PhpModuleExtender> map = this.getFrameworkExtenders();
        final PhpProjectGenerator.ProjectProperties projectProperties = new PhpProjectGenerator.ProjectProperties().setProjectDirectory(this.getProjectDirectory()).setSourcesDirectory(NewPhpProjectWizardIterator.getSources(this.descriptor)).setName((String)this.descriptor.getProperty("projectName")).setRunAsType(this.wizardType == WizardType.REMOTE ? PhpProjectProperties.RunAsType.REMOTE : this.getRunAsType()).setPhpVersion((PhpLanguageOptions.PhpVersion)((Object)this.descriptor.getProperty("phpVersion"))).setCharset((Charset)this.descriptor.getProperty("encoding")).setUrl(this.getUrl()).setIndexFile(this.wizardType == WizardType.REMOTE ? null : this.getIndexFile(map)).setDescriptor(this.descriptor).setCopySources(this.isCopyFiles()).setCopySourcesTarget(this.getCopySrcTarget()).setRemoteConfiguration((RemoteConfiguration)this.descriptor.getProperty("remoteConnection")).setRemoteDirectory((String)this.descriptor.getProperty("remoteDirectory")).setUploadFiles(this.wizardType == WizardType.REMOTE ? PhpProjectProperties.UploadFiles.ON_SAVE : (PhpProjectProperties.UploadFiles)((Object)this.descriptor.getProperty("remoteUpload"))).setFrameworkExtenders(map);
        PhpProjectGenerator.Monitor monitor = null;
        switch (this.wizardType) {
            case NEW: 
            case EXISTING: {
                monitor = new LocalProgressMonitor(progressHandle, map);
                break;
            }
            case REMOTE: {
                monitor = new RemoteProgressMonitor(progressHandle);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown wizard type: " + (Object)((Object)this.wizardType));
            }
        }
        final AntProjectHelper antProjectHelper = PhpProjectGenerator.createProject(projectProperties, monitor);
        hashSet.add(antProjectHelper.getProjectDirectory());
        final Project project = ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
        assert (project instanceof PhpProject);
        final PhpModule phpModule = (PhpModule)project.getLookup().lookup(PhpModule.class);
        assert (phpModule != null) : "PHP module must exist!";
        FileObject fileObject = FileUtil.toFileObject((File)projectProperties.getSourcesDirectory());
        hashSet.add(fileObject);
        switch (this.wizardType) {
            case NEW: {
                this.extendPhpModule(phpModule, map, monitor, hashSet);
                break;
            }
            case REMOTE: {
                this.downloadRemoteFiles((PhpProject)project, this.getRemoteFiles(), projectProperties, monitor);
            }
        }
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws MutexException {
                    try {
                        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                        EditableProperties editableProperties2 = antProjectHelper.getProperties("nbproject/private/private.properties");
                        List list = NewPhpProjectWizardIterator.this.getPhpModuleProperties(phpModule, map);
                        FileObject fileObject = NewPhpProjectWizardIterator.this.setIndexFile(projectProperties, editableProperties, editableProperties2, list);
                        if (fileObject != null && fileObject.isValid()) {
                            hashSet.add(fileObject);
                        }
                        NewPhpProjectWizardIterator.this.setWebRoot(projectProperties, editableProperties, editableProperties2, list);
                        NewPhpProjectWizardIterator.this.setTests(projectProperties, editableProperties, editableProperties2, list);
                        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                        antProjectHelper.putProperties("nbproject/private/private.properties", editableProperties2);
                        ProjectManager.getDefault().saveProject(project);
                    }
                    catch (IOException iOException) {
                        throw new MutexException((Exception)iOException);
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            Exception exception = mutexException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            Exceptions.printStackTrace((Throwable)mutexException);
        }
        return hashSet;
    }

    public String name() {
        return NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_IteratorName", (Object)(this.index + 1), (Object)this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        this.setTitle();
        return this.panels[this.index];
    }

    private void setTitle() {
        if (this.descriptor != null) {
            String string = null;
            switch (this.wizardType) {
                case NEW: {
                    string = "TXT_PhpProject";
                    break;
                }
                case EXISTING: {
                    string = "TXT_ExistingPhpProject";
                    break;
                }
                case REMOTE: {
                    string = "TXT_RemotePhpProject";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown wizard type: " + (Object)((Object)this.wizardType));
                }
            }
            this.descriptor.putProperty("NewProjectWizard_Title", (Object)NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)string));
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] createPanels() {
        String string = null;
        String string2 = null;
        switch (this.wizardType) {
            case NEW: {
                string = "LBL_RunConfiguration";
                string2 = "LBL_Frameworks";
                break;
            }
            case EXISTING: {
                string = "LBL_RunConfiguration";
                break;
            }
            case REMOTE: {
                string = "LBL_RemoteConfiguration";
                string2 = "LBL_RemoteConfirmation";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown wizard type: " + (Object)((Object)this.wizardType));
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_ProjectNameLocation"));
        arrayList.add(NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)string));
        if (string2 != null) {
            arrayList.add(NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)string2));
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        WizardDescriptor.Panel<WizardDescriptor> panel = null;
        switch (this.wizardType) {
            case NEW: {
                panel = new PhpFrameworksPanel(stringArray);
                break;
            }
            case EXISTING: {
                break;
            }
            case REMOTE: {
                panel = new RemoteConfirmationPanel(stringArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown wizard type: " + (Object)((Object)this.wizardType));
            }
        }
        ConfigureProjectPanel configureProjectPanel = new ConfigureProjectPanel(stringArray, this.wizardType);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(arrayList.size());
        arrayList2.add(configureProjectPanel);
        arrayList2.add(new RunConfigurationPanel(stringArray, configureProjectPanel, this.wizardType));
        if (panel != null) {
            arrayList2.add(panel);
        }
        WizardDescriptor.Panel[] panelArray = (WizardDescriptor.Panel[])Array.newInstance(WizardDescriptor.Panel.class, arrayList2.size());
        return arrayList2.toArray(panelArray);
    }

    private void initDescriptor(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("isProjectDirUsed", null);
        wizardDescriptor.putProperty("projectDir", null);
        wizardDescriptor.putProperty("projectName", null);
        wizardDescriptor.putProperty("sourcesFolder", null);
        wizardDescriptor.putProperty("localServers", null);
        wizardDescriptor.putProperty("phpVersion", null);
        wizardDescriptor.putProperty("encoding", null);
        wizardDescriptor.putProperty("RunConfigurationPanel.valid", null);
        wizardDescriptor.putProperty("run.as", null);
        wizardDescriptor.putProperty("copySrcFiles", null);
        wizardDescriptor.putProperty("copySrcTarget", null);
        wizardDescriptor.putProperty("copySrcTargets", null);
        wizardDescriptor.putProperty("url", null);
        wizardDescriptor.putProperty("indexFile", null);
        wizardDescriptor.putProperty("remoteConnection", null);
        wizardDescriptor.putProperty("remoteDirectory", null);
        wizardDescriptor.putProperty("remoteUpload", null);
        wizardDescriptor.putProperty("PhpFrameworksPanel.valid", null);
        wizardDescriptor.putProperty("frameworks", null);
        wizardDescriptor.putProperty("remoteFiles", null);
    }

    private File getProjectDirectory() {
        if (((Boolean)this.descriptor.getProperty("isProjectDirUsed")).booleanValue()) {
            return (File)this.descriptor.getProperty("projectDir");
        }
        return null;
    }

    static File getSources(WizardDescriptor wizardDescriptor) {
        LocalServer localServer = (LocalServer)wizardDescriptor.getProperty("sourcesFolder");
        return new File(localServer.getSrcRoot());
    }

    private PhpProjectProperties.RunAsType getRunAsType() {
        return (PhpProjectProperties.RunAsType)((Object)this.descriptor.getProperty("run.as"));
    }

    private String getUrl() {
        String string = (String)this.descriptor.getProperty("url");
        if (string == null) {
            string = RunConfigurationPanel.getUrlForSources(this.wizardType, this.descriptor);
        }
        return string;
    }

    private String getIndexFile(Map<PhpFrameworkProvider, PhpModuleExtender> map) {
        if (map != null && !map.isEmpty()) {
            return null;
        }
        String string = (String)this.descriptor.getProperty("indexFile");
        if (string == null) {
            string = "index.php";
        }
        return string;
    }

    private Boolean isCopyFiles() {
        PhpProjectProperties.RunAsType runAsType = this.getRunAsType();
        if (runAsType == null) {
            return null;
        }
        boolean bl = false;
        switch (runAsType) {
            case LOCAL: {
                Boolean bl2 = (Boolean)this.descriptor.getProperty("copySrcFiles");
                if (bl2 == null || !bl2.booleanValue()) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private File getCopySrcTarget() {
        if (this.getRunAsType() == null) {
            return null;
        }
        LocalServer localServer = (LocalServer)this.descriptor.getProperty("copySrcTarget");
        if (StringUtils.hasText((String)localServer.getSrcRoot())) {
            return new File(localServer.getSrcRoot());
        }
        return null;
    }

    private void extendPhpModule(PhpModule phpModule, Map<PhpFrameworkProvider, PhpModuleExtender> map, PhpProjectGenerator.Monitor monitor, Set<FileObject> set) {
        assert (this.wizardType == WizardType.NEW) : "Extending not allowed for: " + (Object)((Object)this.wizardType);
        assert (monitor instanceof LocalProgressMonitor);
        LocalProgressMonitor localProgressMonitor = (LocalProgressMonitor)monitor;
        if (!map.isEmpty()) {
            localProgressMonitor.startingExtending();
            for (Map.Entry<PhpFrameworkProvider, PhpModuleExtender> entry : map.entrySet()) {
                PhpFrameworkProvider phpFrameworkProvider = entry.getKey();
                assert (phpFrameworkProvider != null);
                localProgressMonitor.extending(phpFrameworkProvider.getName());
                PhpModuleExtender phpModuleExtender = entry.getValue();
                if (phpModuleExtender == null) continue;
                try {
                    Set set2 = phpModuleExtender.extend(phpModule);
                    assert (set2 != null);
                    set.addAll(set2);
                }
                catch (PhpModuleExtender.ExtendingException extendingException) {
                    this.warnUser(extendingException.getFailureMessage());
                }
            }
        }
        localProgressMonitor.finishingExtending();
    }

    private void warnUser(String string) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
    }

    private Set<TransferFile> getRemoteFiles() {
        return (Set)this.descriptor.getProperty("remoteFiles");
    }

    private void downloadRemoteFiles(PhpProject phpProject, Set<TransferFile> set, PhpProjectGenerator.ProjectProperties projectProperties, PhpProjectGenerator.Monitor monitor) {
        assert (this.wizardType == WizardType.REMOTE) : "Download not allowed for: " + (Object)((Object)this.wizardType);
        assert (monitor instanceof RemoteProgressMonitor);
        assert (set != null);
        assert (!set.isEmpty());
        RemoteProgressMonitor remoteProgressMonitor = (RemoteProgressMonitor)monitor;
        remoteProgressMonitor.startingDownload();
        FileObject fileObject = FileUtil.toFileObject((File)projectProperties.getSourcesDirectory());
        RemoteConfiguration remoteConfiguration = projectProperties.getRemoteConfiguration();
        InputOutput inputOutput = RemoteCommand.getRemoteLog(remoteConfiguration.getDisplayName());
        RemoteCommand.DefaultOperationMonitor defaultOperationMonitor = new RemoteCommand.DefaultOperationMonitor("LBL_Downloading");
        RemoteClient remoteClient = new RemoteClient(remoteConfiguration, new RemoteClient.AdvancedProperties().setInputOutput(inputOutput).setOperationMonitor(defaultOperationMonitor).setAdditionalInitialSubdirectory(projectProperties.getRemoteDirectory()).setPreservePermissions(false).setPhpVisibilityQuery(PhpVisibilityQuery.forProject(phpProject)));
        DownloadCommand.download(remoteClient, inputOutput, defaultOperationMonitor, projectProperties.getName(), fileObject, set);
        remoteProgressMonitor.finishingDownload();
    }

    private Map<PhpFrameworkProvider, PhpModuleExtender> getFrameworkExtenders() {
        Map<PhpFrameworkProvider, PhpModuleExtender> map = (Map<PhpFrameworkProvider, PhpModuleExtender>)this.descriptor.getProperty("frameworks");
        if (map == null) {
            map = Collections.emptyMap();
        }
        return map;
    }

    private List<PhpModuleProperties> getPhpModuleProperties(PhpModule phpModule, Map<PhpFrameworkProvider, PhpModuleExtender> map) {
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PhpModuleProperties> arrayList = new ArrayList<PhpModuleProperties>(map.size());
        for (PhpFrameworkProvider phpFrameworkProvider : map.keySet()) {
            arrayList.add(phpFrameworkProvider.getPhpModuleProperties(phpModule));
        }
        return arrayList;
    }

    private FileObject setIndexFile(PhpProjectGenerator.ProjectProperties projectProperties, EditableProperties editableProperties, EditableProperties editableProperties2, List<PhpModuleProperties> list) {
        String string = projectProperties.getIndexFile();
        block0 : switch (this.wizardType) {
            case NEW: {
                if (string != null) break;
                for (PhpModuleProperties phpModuleProperties : list) {
                    FileObject fileObject = phpModuleProperties.getIndexFile();
                    if (fileObject == null) continue;
                    string = PropertyUtils.relativizeFile((File)projectProperties.getSourcesDirectory(), (File)FileUtil.toFile((FileObject)fileObject));
                    assert (!string.startsWith("../"));
                    break block0;
                }
                break;
            }
            case REMOTE: {
                string = this.getIndexFile(null);
            }
        }
        if (string == null) {
            return null;
        }
        editableProperties2.setProperty("index.file", string);
        return FileUtil.toFileObject((File)projectProperties.getSourcesDirectory()).getFileObject(string);
    }

    private void setWebRoot(PhpProjectGenerator.ProjectProperties projectProperties, EditableProperties editableProperties, EditableProperties editableProperties2, List<PhpModuleProperties> list) {
        for (PhpModuleProperties phpModuleProperties : list) {
            FileObject fileObject = phpModuleProperties.getWebRoot();
            if (fileObject == null) continue;
            String string = PropertyUtils.relativizeFile((File)projectProperties.getSourcesDirectory(), (File)FileUtil.toFile((FileObject)fileObject));
            assert (string != null && !string.startsWith("../")) : "WebRoot must be underneath Sources";
            editableProperties.setProperty("web.root", string);
            break;
        }
    }

    private void setTests(PhpProjectGenerator.ProjectProperties projectProperties, EditableProperties editableProperties, EditableProperties editableProperties2, List<PhpModuleProperties> list) {
        if (list.isEmpty()) {
            return;
        }
        File file = projectProperties.getProjectDirectory();
        if (file == null) {
            file = projectProperties.getSourcesDirectory();
        }
        assert (file != null);
        for (PhpModuleProperties phpModuleProperties : list) {
            FileObject fileObject = phpModuleProperties.getTests();
            if (fileObject == null) continue;
            File file2 = FileUtil.toFile((FileObject)fileObject);
            String string = PropertyUtils.relativizeFile((File)file, (File)file2);
            if (string == null) {
                string = file2.getAbsolutePath();
            }
            editableProperties.setProperty("test.src.dir", string);
            break;
        }
    }

    private static final class RemoteProgressMonitor
    implements PhpProjectGenerator.Monitor {
        private final ProgressHandle handle;

        public RemoteProgressMonitor(ProgressHandle progressHandle) {
            assert (progressHandle != null);
            this.handle = progressHandle;
        }

        public void starting() {
            this.handle.start(10);
            String string = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_CreatingProject");
            this.handle.progress(string, 2);
        }

        public void creatingIndexFile() {
            assert (false) : "Should not get here";
        }

        public void finishing() {
        }

        public void startingDownload() {
            String string = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_StartingDownload");
            this.handle.progress(string, 5);
        }

        public void finishingDownload() {
            String string = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_PreparingToOpen");
            this.handle.progress(string, 10);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LocalProgressMonitor
    implements PhpProjectGenerator.Monitor {
        private final ProgressHandle handle;
        private final int units;
        private int unit = 0;

        private LocalProgressMonitor(ProgressHandle progressHandle, Map<PhpFrameworkProvider, PhpModuleExtender> map) {
            assert (progressHandle != null);
            assert (map != null);
            this.handle = progressHandle;
            this.units = 5 + 2 * map.size();
        }

        @Override
        public void starting() {
            this.handle.start(this.units);
            String string = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_CreatingProject");
            this.handle.progress(string, 2);
        }

        @Override
        public void creatingIndexFile() {
            String string = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_CreatingIndexFile");
            this.handle.progress(string, 4);
        }

        @Override
        public void finishing() {
        }

        public void startingExtending() {
            this.unit = 5;
            String string = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_StartingExtending");
            this.handle.progress(string, this.unit);
        }

        public void extending(String string) {
            this.unit += 2;
            String string2 = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_Extending", (Object)string);
            this.handle.progress(string2, this.unit);
        }

        public void finishingExtending() {
            String string = NbBundle.getMessage(NewPhpProjectWizardIterator.class, (String)"LBL_NewPhpProjectWizardIterator_WizardProgress_PreparingToOpen");
            this.handle.progress(string, this.units);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WizardType {
        NEW,
        EXISTING,
        REMOTE;

    }
}

