/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.spi.XDebugStarter;
import org.netbeans.modules.php.project.ui.actions.support.AskForUrlPanel;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.actions.support.XDebugStarterFactory;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.web.client.tools.api.JSToNbJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.LocationMappersFactory;
import org.netbeans.modules.web.client.tools.api.NbJSToJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionException;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class ConfigActionLocal
extends ConfigAction {
    private final FileObject webRoot;

    protected ConfigActionLocal(PhpProject phpProject) {
        super(phpProject);
        this.webRoot = ProjectPropertiesSupport.getWebRootDirectory(phpProject);
        assert (this.webRoot != null);
    }

    public boolean isValid(boolean bl) {
        boolean bl2 = true;
        if (bl && !this.isIndexFileValid(this.webRoot)) {
            bl2 = false;
        } else if (RunAsValidator.validateWebFields(ProjectPropertiesSupport.getUrl(this.project), FileUtil.toFile((FileObject)this.webRoot), null, ProjectPropertiesSupport.getArguments(this.project)) != null) {
            bl2 = false;
        }
        if (!bl2) {
            this.showCustomizer();
        }
        return bl2;
    }

    public boolean isRunFileEnabled(Lookup lookup) {
        FileObject fileObject = CommandUtils.fileForContextOrSelectedNodes(lookup, this.webRoot);
        return fileObject != null;
    }

    public boolean isDebugFileEnabled(Lookup lookup) {
        if (XDebugStarterFactory.getInstance() == null) {
            return false;
        }
        return this.isRunFileEnabled(lookup);
    }

    public void runProject() {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(CommandUtils.urlForProject(this.project));
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
    }

    public void debugProject() {
        boolean bl;
        final URL[] uRLArray = new URL[1];
        try {
            uRLArray[0] = this.getUrlToShow(CommandUtils.urlForDebugProject(this.project), CommandUtils.urlForProject(this.project));
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
        catch (StopDebuggingException stopDebuggingException) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    if (uRLArray[0] != null) {
                        if (CommandUtils.getDebugInfo((PhpProject)ConfigActionLocal.this.project).debugClient) {
                            try {
                                ConfigActionLocal.this.launchJavaScriptDebugger(uRLArray[0]);
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                Exceptions.printStackTrace((Throwable)uRISyntaxException);
                            }
                        } else {
                            HtmlBrowser.URLDisplayer.getDefault().showURL(uRLArray[0]);
                        }
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Exceptions.printStackTrace((Throwable)malformedURLException);
                }
            }
        };
        boolean bl2 = WebClientToolsSessionStarterService.isAvailable();
        if (bl2 && !(bl = WebClientToolsProjectUtils.showDebugDialog((Project)this.project))) {
            return;
        }
        if (!bl2 || WebClientToolsProjectUtils.getServerDebugProperty((Project)this.project)) {
            XDebugStarter xDebugStarter = XDebugStarterFactory.getInstance();
            if (xDebugStarter != null) {
                if (xDebugStarter.isAlreadyRunning()) {
                    if (CommandUtils.warnNoMoreDebugSession()) {
                        xDebugStarter.stop();
                        this.debugProject();
                    }
                } else {
                    FileObject fileObject = CommandUtils.fileForProject(this.project, this.webRoot);
                    if (fileObject != null) {
                        this.startDebugger(xDebugStarter, runnable, fileObject);
                    } else {
                        String string = ProjectPropertiesSupport.getIndexFile(this.project);
                        String string2 = NbBundle.getMessage(ConfigActionLocal.class, (String)"ERR_Missing_IndexFile", (Object)string);
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        ((CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class)).showCustomizer("Run");
                    }
                }
            }
        } else {
            runnable.run();
        }
    }

    public void runFile(Lookup lookup) {
        try {
            URL uRL = CommandUtils.urlForContext(this.project, lookup);
            assert (uRL != null);
            this.preShowUrl(lookup);
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
    }

    public void debugFile(Lookup lookup) {
        URL uRL = null;
        try {
            uRL = this.getUrlToShow(CommandUtils.urlForDebugContext(this.project, lookup), CommandUtils.urlForContext(this.project, lookup));
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return;
        }
        catch (StopDebuggingException stopDebuggingException) {
            return;
        }
        this.preShowUrl(lookup);
        this.debugFile(CommandUtils.fileForContextOrSelectedNodes(lookup, this.webRoot), uRL);
    }

    URL getUrlToShow(URL uRL, URL uRL2) throws MalformedURLException, StopDebuggingException {
        URL uRL3 = null;
        PhpProjectProperties.DebugUrl debugUrl = ProjectPropertiesSupport.getDebugUrl(this.project);
        switch (debugUrl) {
            case DEFAULT_URL: {
                uRL3 = uRL;
                assert (uRL3 != null);
                break;
            }
            case ASK_FOR_URL: {
                AskForUrlPanel askForUrlPanel = new AskForUrlPanel(this.project, uRL2);
                if (!askForUrlPanel.open()) {
                    throw new StopDebuggingException();
                }
                uRL3 = askForUrlPanel.getUrl();
                assert (uRL3 != null);
                uRL3 = CommandUtils.createDebugUrl(uRL3);
                break;
            }
            case DO_NOT_OPEN_BROWSER: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state for debug URL: " + (Object)((Object)debugUrl));
            }
        }
        return uRL3;
    }

    void debugFile(FileObject fileObject, final URL uRL) {
        boolean bl;
        assert (fileObject != null);
        Runnable runnable = new Runnable(){

            public void run() {
                if (uRL != null) {
                    try {
                        if (CommandUtils.getDebugInfo((PhpProject)ConfigActionLocal.this.project).debugClient) {
                            try {
                                ConfigActionLocal.this.launchJavaScriptDebugger(uRL);
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                Exceptions.printStackTrace((Throwable)uRISyntaxException);
                            }
                        } else {
                            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        Exceptions.printStackTrace((Throwable)malformedURLException);
                    }
                }
            }
        };
        boolean bl2 = WebClientToolsSessionStarterService.isAvailable();
        if (bl2 && !(bl = WebClientToolsProjectUtils.showDebugDialog((Project)this.project))) {
            return;
        }
        if (!bl2 || WebClientToolsProjectUtils.getServerDebugProperty((Project)this.project)) {
            XDebugStarter xDebugStarter = XDebugStarterFactory.getInstance();
            if (xDebugStarter != null) {
                if (xDebugStarter.isAlreadyRunning()) {
                    if (CommandUtils.warnNoMoreDebugSession()) {
                        xDebugStarter.stop();
                        this.debugFile(fileObject, uRL);
                    }
                } else {
                    this.startDebugger(xDebugStarter, runnable, fileObject);
                }
            }
        } else {
            runnable.run();
        }
    }

    protected void preShowUrl(Lookup lookup) {
    }

    private void startDebugger(XDebugStarter xDebugStarter, Runnable runnable, FileObject fileObject) {
        Cancellable cancellable = new Cancellable(){

            public boolean cancel() {
                return true;
            }
        };
        Callable<Cancellable> callable = Executors.callable(runnable, cancellable);
        XDebugStarter.Properties properties = XDebugStarter.Properties.create(fileObject, false, ProjectPropertiesSupport.getDebugPathMapping(this.project), ProjectPropertiesSupport.getDebugProxy(this.project));
        xDebugStarter.start(this.project, callable, properties);
    }

    private void launchJavaScriptDebugger(URL uRL) throws MalformedURLException, URISyntaxException {
        HtmlBrowser.Factory factory;
        URI uRI;
        LocationMappersFactory locationMappersFactory = (LocationMappersFactory)Lookup.getDefault().lookup(LocationMappersFactory.class);
        Lookup lookup = null;
        if (locationMappersFactory != null) {
            uRI = CommandUtils.getBaseURL(this.project).toURI();
            factory = PhpProjectUtils.getSourceObjects(this.project);
            JSToNbJSLocationMapper jSToNbJSLocationMapper = locationMappersFactory.getJSToNbJSLocationMapper((FileObject[])factory, uRI, null);
            NbJSToJSLocationMapper nbJSToJSLocationMapper = locationMappersFactory.getNbJSToJSLocationMapper((FileObject[])factory, uRI, null);
            lookup = Lookups.fixed((Object[])new Object[]{jSToNbJSLocationMapper, nbJSToJSLocationMapper, this.project});
        } else {
            lookup = Lookups.fixed((Object[])new Object[]{this.project});
        }
        uRI = uRL.toURI();
        factory = null;
        factory = WebClientToolsProjectUtils.isInternetExplorer((Project)this.project) ? WebClientToolsProjectUtils.getInternetExplorerBrowser() : WebClientToolsProjectUtils.getFirefoxBrowser();
        if (factory == null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
        } else {
            try {
                WebClientToolsSessionStarterService.startSession((URI)uRI, (HtmlBrowser.Factory)factory, (Lookup)lookup);
            }
            catch (WebClientToolsSessionException webClientToolsSessionException) {
                Exceptions.printStackTrace((Throwable)webClientToolsSessionException);
            }
        }
    }

    private static final class StopDebuggingException
    extends Exception {
        private static final long serialVersionUID = -22807171434417714L;

        private StopDebuggingException() {
        }
    }
}

