/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

public final class Time {
    public static final Time INDEFINITE = new Time(-1L);
    public static final Time UNRESOLVED = new Time(-2L);
    long value;

    public Time(long value) {
        this.value = value;
    }

    public boolean greaterThan(Time cmp) {
        if (this == UNRESOLVED) {
            return true;
        }
        if (this == INDEFINITE) {
            return cmp != UNRESOLVED;
        }
        if (cmp == UNRESOLVED || cmp == INDEFINITE) {
            return false;
        }
        return this.value >= cmp.value;
    }

    public boolean isResolved() {
        return this != INDEFINITE && this != UNRESOLVED;
    }

    public boolean isSameTime(Time cmp) {
        if (cmp == null) {
            return false;
        }
        if (cmp == this) {
            return true;
        }
        return cmp.value == this.value;
    }

    public String toString() {
        if (this == UNRESOLVED) {
            return "Time[UNRESOLVED]";
        }
        if (this == INDEFINITE) {
            return "Time[INDEFINITE]";
        }
        return "Time[RESOLVED, " + this.value + "]";
    }

    protected static String toStringTrait(Time t) {
        if (t == null || INDEFINITE == t) {
            return "indefinite";
        }
        if (UNRESOLVED.isSameTime(t)) {
            throw new IllegalArgumentException();
        }
        return (float)t.value / 1000.0f + "s";
    }
}

