/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.j2d;

import com.sun.perseus.j2d.Curve;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

final class Order2
extends Curve {
    private double x0;
    private double y0;
    private double cx0;
    private double cy0;
    private double x1;
    private double y1;
    private double xmin;
    private double xmax;
    private double xcoeff0;
    private double xcoeff1;
    private double xcoeff2;
    private double ycoeff0;
    private double ycoeff1;
    private double ycoeff2;

    public static void insert(Vector curves, double[] tmp, double x0, double y0, double cx0, double cy0, double x1, double y1, int direction) {
        int numparams = Order2.getHorizontalParams(y0, cy0, y1, tmp);
        if (numparams == 0) {
            curves.add(new Order2(x0, y0, cx0, cy0, x1, y1, direction));
            return;
        }
        double t = tmp[0];
        tmp[0] = x0;
        tmp[1] = y0;
        tmp[2] = cx0;
        tmp[3] = cy0;
        tmp[4] = x1;
        tmp[5] = y1;
        Order2.split(tmp, 0, t);
        Order2 c1 = Order2.getInstance(x0, y0, tmp[2], tmp[3], tmp[4], tmp[5], direction);
        Order2 c2 = Order2.getInstance(tmp[4], tmp[5], tmp[6], tmp[7], x1, y1, direction);
        if (direction == 1) {
            curves.add(c1);
            curves.add(c2);
        } else {
            curves.add(c2);
            curves.add(c1);
        }
    }

    public static Order2 getInstance(double x0, double y0, double cx0, double cy0, double x1, double y1, int direction) {
        if (y0 > y1) {
            return new Order2(x1, y1, cx0, cy0, x0, y0, -direction);
        }
        return new Order2(x0, y0, cx0, cy0, x1, y1, direction);
    }

    public static void getEqn(double[] eqn, double c0, double cp, double c1) {
        eqn[0] = c0;
        eqn[1] = cp + cp - c0 - c0;
        eqn[2] = c0 - cp - cp + c1;
    }

    public static int getHorizontalParams(double c0, double cp, double c1, double[] ret) {
        if (c0 <= cp && cp <= c1) {
            return 0;
        }
        double denom = (c0 -= cp) + (c1 -= cp);
        if (denom == 0.0) {
            return 0;
        }
        double t = c0 / denom;
        if (t <= 0.0 || t >= 1.0) {
            return 0;
        }
        ret[0] = t;
        return 1;
    }

    public static void split(double[] coords, int pos, double t) {
        double y1;
        double x1;
        coords[pos + 8] = x1 = coords[pos + 4];
        coords[pos + 9] = y1 = coords[pos + 5];
        double cx = coords[pos + 2];
        double cy = coords[pos + 3];
        x1 = cx + (x1 - cx) * t;
        y1 = cy + (y1 - cy) * t;
        double x0 = coords[pos + 0];
        double y0 = coords[pos + 1];
        x0 += (cx - x0) * t;
        y0 += (cy - y0) * t;
        cx = x0 + (x1 - x0) * t;
        cy = y0 + (y1 - y0) * t;
        coords[pos + 2] = x0;
        coords[pos + 3] = y0;
        coords[pos + 4] = cx;
        coords[pos + 5] = cy;
        coords[pos + 6] = x1;
        coords[pos + 7] = y1;
    }

    public Order2(double x0, double y0, double cx0, double cy0, double x1, double y1, int direction) {
        super(direction);
        if (cy0 < y0) {
            cy0 = y0;
        } else if (cy0 > y1) {
            cy0 = y1;
        }
        this.x0 = x0;
        this.y0 = y0;
        this.cx0 = cx0;
        this.cy0 = cy0;
        this.x1 = x1;
        this.y1 = y1;
        this.xmin = Math.min(Math.min(x0, x1), cx0);
        this.xmax = Math.max(Math.max(x0, x1), cx0);
        this.xcoeff0 = x0;
        this.xcoeff1 = cx0 + cx0 - x0 - x0;
        this.xcoeff2 = x0 - cx0 - cx0 + x1;
        this.ycoeff0 = y0;
        this.ycoeff1 = cy0 + cy0 - y0 - y0;
        this.ycoeff2 = y0 - cy0 - cy0 + y1;
    }

    public int getOrder() {
        return 2;
    }

    public double getXTop() {
        return this.x0;
    }

    public double getYTop() {
        return this.y0;
    }

    public double getXBot() {
        return this.x1;
    }

    public double getYBot() {
        return this.y1;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getX0() {
        return this.direction == 1 ? this.x0 : this.x1;
    }

    public double getY0() {
        return this.direction == 1 ? this.y0 : this.y1;
    }

    public double getCX0() {
        return this.cx0;
    }

    public double getCY0() {
        return this.cy0;
    }

    public double getX1() {
        return this.direction == -1 ? this.x0 : this.x1;
    }

    public double getY1() {
        return this.direction == -1 ? this.y0 : this.y1;
    }

    public double XforY(double y) {
        if (y == this.y0) {
            return this.x0;
        }
        if (y == this.y1) {
            return this.x1;
        }
        return this.XforT(this.TforY(y));
    }

    public double TforY(double y) {
        double[] eqn = new double[3];
        Order2.getEqn(eqn, this.y0, this.cy0, this.y1);
        eqn[0] = eqn[0] - y;
        int numroots = QuadCurve2D.solveQuadratic(eqn, eqn);
        return Order2.firstValidRoot(eqn, numroots);
    }

    public double XforT(double t) {
        return (this.xcoeff2 * t + this.xcoeff1) * t + this.xcoeff0;
    }

    public double YforT(double t) {
        return (this.ycoeff2 * t + this.ycoeff1) * t + this.ycoeff0;
    }

    public double dXforT(double t, int deriv) {
        switch (deriv) {
            case 0: {
                return (this.xcoeff2 * t + this.xcoeff1) * t + this.xcoeff0;
            }
            case 1: {
                return 2.0 * this.xcoeff2 * t + this.xcoeff1;
            }
            case 2: {
                return 2.0 * this.xcoeff2;
            }
        }
        return 0.0;
    }

    public double dYforT(double t, int deriv) {
        switch (deriv) {
            case 0: {
                return (this.ycoeff2 * t + this.ycoeff1) * t + this.ycoeff0;
            }
            case 1: {
                return 2.0 * this.ycoeff2 * t + this.ycoeff1;
            }
            case 2: {
                return 2.0 * this.ycoeff2;
            }
        }
        return 0.0;
    }

    public double nextVertical(double t0, double t1) {
        double t = -this.ycoeff1 / (2.0 * this.ycoeff2);
        if (t > t0 && t < t1) {
            return t;
        }
        return t1;
    }

    public void enlarge(Rectangle2D r) {
        r.add(this.x0, this.y0);
        double t = -this.xcoeff1 / (2.0 * this.xcoeff2);
        if (t > 0.0 && t < 1.0) {
            r.add(this.XforT(t), this.YforT(t));
        }
        r.add(this.x1, this.y1);
    }

    public Curve getSubCurve(double ystart, double yend, int dir) {
        double t1;
        int numroots;
        double t0;
        if (ystart == this.y0 && yend == this.y1) {
            return this.getWithDirection(dir);
        }
        double[] eqn = new double[10];
        if (ystart == this.y0) {
            t0 = 0.0;
        } else {
            Order2.getEqn(eqn, this.y0, this.cy0, this.y1);
            eqn[0] = eqn[0] - ystart;
            numroots = QuadCurve2D.solveQuadratic(eqn, eqn);
            t0 = Order2.firstValidRoot(eqn, numroots);
        }
        if (yend == this.y1) {
            t1 = 1.0;
        } else {
            Order2.getEqn(eqn, this.y0, this.cy0, this.y1);
            eqn[0] = eqn[0] - yend;
            numroots = QuadCurve2D.solveQuadratic(eqn, eqn);
            t1 = Order2.firstValidRoot(eqn, numroots);
        }
        eqn[0] = this.x0;
        eqn[1] = this.y0;
        eqn[2] = this.cx0;
        eqn[3] = this.cy0;
        eqn[4] = this.x1;
        eqn[5] = this.y1;
        if (t1 < 1.0) {
            Order2.split(eqn, 0, t1);
        }
        if (t0 <= 0.0) {
            return new Order2(eqn[0], ystart, eqn[2], eqn[3], eqn[4], yend, dir);
        }
        Order2.split(eqn, 0, t0 / t1);
        return new Order2(eqn[4], ystart, eqn[6], eqn[7], eqn[8], yend, dir);
    }

    public Curve getReversedCurve() {
        return new Order2(this.x0, this.y0, this.cx0, this.cy0, this.x1, this.y1, -this.direction);
    }

    public int getSegment(double[] coords) {
        coords[0] = this.cx0;
        coords[1] = this.cy0;
        if (this.direction == 1) {
            coords[2] = this.x1;
            coords[3] = this.y1;
        } else {
            coords[2] = this.x0;
            coords[3] = this.y0;
        }
        return 2;
    }

    public String controlPointString() {
        return "(" + Order2.round(this.cx0) + ", " + Order2.round(this.cy0) + "), ";
    }
}

