/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.samples.depot;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.ruby.samples.depot.DepotWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class DepotPanelVisual
extends JPanel
implements DocumentListener {
    public static final String PROP_PROJECT_NAME = "projectName";
    private DepotWizardPanel panel;
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;

    public DepotPanelVisual(DepotWizardPanel depotWizardPanel) {
        this.initComponents();
        this.panel = depotWizardPanel;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(DepotPanelVisual.class, (String)"DepotPanelVisual.project.name"));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(DepotPanelVisual.class, (String)"DepotPanelVisual.project.location"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(DepotPanelVisual.class, (String)"DepotPanelVisual.browse"));
        this.browseButton.setActionCommand("BROWSE");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DepotPanelVisual.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(DepotPanelVisual.class, (String)"DepotPanelVisual.project.folder"));
        this.createdFolderTextField.setEditable(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectNameLabel).add((Component)this.projectLocationLabel).add((Component)this.createdFolderLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.projectNameTextField, -1, 268, Short.MAX_VALUE).add(2, (Component)this.projectLocationTextField, -1, 268, Short.MAX_VALUE).add(2, (Component)this.createdFolderTextField, -1, 268, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.browseButton).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectNameLabel).add((Component)this.projectNameTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLocationLabel).add((Component)this.projectLocationTextField, -2, -1, -2).add((Component)this.browseButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.createdFolderLabel).add((Component)this.createdFolderTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("BROWSE".equals(string)) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
            jFileChooser.setDialogTitle(DepotPanelVisual.getMessage("DepotPanelVisual.project.select.location"));
            jFileChooser.setFileSelectionMode(1);
            String string2 = this.projectLocationTextField.getText();
            if (string2.length() > 0 && (file = new File(string2)).exists()) {
                jFileChooser.setSelectedFile(file);
            }
            if (0 == jFileChooser.showOpenDialog(this)) {
                file = jFileChooser.getSelectedFile();
                this.projectLocationTextField.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File file;
        File file2;
        if (this.projectNameTextField.getText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)DepotPanelVisual.getMessage("DepotPanelVisual.project.name.invalid"));
            return false;
        }
        File file3 = FileUtil.normalizeFile((File)new File(this.projectLocationTextField.getText()).getAbsoluteFile());
        if (!file3.isDirectory()) {
            String string = DepotPanelVisual.getMessage("DepotPanelVisual.project.folder.invalid");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
            return false;
        }
        for (file2 = file = FileUtil.normalizeFile((File)new File(this.createdFolderTextField.getText()).getAbsoluteFile()); file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
        }
        if (file2 == null || !file2.canWrite()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)DepotPanelVisual.getMessage("DepotPanelVisual.project.folder.cannot.create"));
            return false;
        }
        if (FileUtil.toFileObject((File)file2) == null) {
            String string = DepotPanelVisual.getMessage("DepotPanelVisual.project.folder.invalid");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
            return false;
        }
        File[] fileArray = file.listFiles();
        if (file.exists() && fileArray != null && fileArray.length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)DepotPanelVisual.getMessage("DepotPanelVisual.project.folder.exists"));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    void store(WizardDescriptor wizardDescriptor) {
        String string = this.projectNameTextField.getText().trim();
        String string2 = this.createdFolderTextField.getText().trim();
        wizardDescriptor.putProperty("projdir", (Object)new File(string2));
        wizardDescriptor.putProperty("name", (Object)string);
    }

    void read(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty("projdir");
        file = file == null || file.getParentFile() == null || !file.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : file.getParentFile();
        this.projectLocationTextField.setText(file.getAbsolutePath());
        String string = (String)wizardDescriptor.getProperty("name");
        if (string == null) {
            string = "Depot";
        }
        this.projectNameTextField.setText(string);
        this.projectNameTextField.selectAll();
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    private void updateTexts(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.projectNameTextField.getDocument() || document == this.projectLocationTextField.getDocument()) {
            String string = this.projectNameTextField.getText();
            String string2 = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(string2 + File.separatorChar + string);
        }
        this.panel.fireChangeEvent();
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(DepotPanelVisual.class, (String)string);
    }
}

