/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyLineConvertorFactory;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutionUtils {
    private static final Logger LOGGER = Logger.getLogger(ExecutionUtils.class.getName());
    private static final Pattern[] LOCATION_RECOGNIZER_PATTERNS = new Pattern[]{RubyLineConvertorFactory.RAILS_RECOGNIZER, RubyLineConvertorFactory.RUBY_COMPILER_WIN_MY, RubyLineConvertorFactory.JRUBY_COMPILER, RubyLineConvertorFactory.RUBY_COMPILER, RubyLineConvertorFactory.RUBY_COMPILER_WIN};
    private static final boolean SYNC_RUBY_STDIO = System.getProperty("ruby.no.sync-stdio") == null;
    private static final boolean LAUNCH_JRUBY_SCRIPT = System.getProperty("ruby.use.jruby.script") != null;

    private ExecutionUtils() {
    }

    public static boolean launchJRubyScript() {
        return LAUNCH_JRUBY_SCRIPT;
    }

    public static List<? extends String> getRubyArgs(RubyPlatform rubyPlatform) {
        RubyExecutionDescriptor rubyExecutionDescriptor = new RubyExecutionDescriptor(rubyPlatform);
        return ExecutionUtils.getRubyArgs(rubyPlatform.getHome().getAbsolutePath(), rubyPlatform.getInterpreterFile().getName(), rubyExecutionDescriptor, null);
    }

    private static List<? extends String> getRubyArgs(String string, String string2, RubyExecutionDescriptor rubyExecutionDescriptor, String string3) {
        int n;
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!ExecutionUtils.launchJRubyScript() && string2.startsWith("jruby")) {
            String[] stringArray;
            String string4 = ExecutionUtils.getJavaHome();
            arrayList.add(string4 + File.separator + "bin" + File.separator + "java");
            arrayList.add("-Xverify:none");
            arrayList.add("-da");
            object2 = "-Xmx512m";
            object = "-Xss1024k";
            String[] stringArray2 = stringArray = rubyExecutionDescriptor == null ? null : rubyExecutionDescriptor.getJVMArguments();
            if (stringArray != null) {
                for (String string5 : stringArray) {
                    if (string5.contains("-Xmx")) {
                        object2 = null;
                    }
                    if (string5.contains("-Xss")) {
                        object = null;
                    }
                    arrayList.add(string5);
                }
            }
            if (object2 != null) {
                arrayList.add(object2);
            }
            if (object != null) {
                arrayList.add(object);
            }
            arrayList.add("-classpath");
            Object object3 = null;
            try {
                object3 = new File(string);
                object3 = ((File)object3).getCanonicalFile();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            if (!((File)object3).isDirectory()) {
                throw new IllegalArgumentException(((File)object3).getAbsolutePath() + " does not exist.");
            }
            File file = new File((File)object3, "lib");
            if (!file.isDirectory()) {
                throw new AssertionError((Object)('\"' + file.getAbsolutePath() + "\" exists (\"" + string2 + "\" is not valid JRuby executable?)"));
            }
            arrayList.add(ExecutionUtils.computeJRubyClassPath(rubyExecutionDescriptor == null ? null : rubyExecutionDescriptor.getClassPath(), file));
            arrayList.add("-Djruby.base=" + object3);
            arrayList.add("-Djruby.home=" + object3);
            arrayList.add("-Djruby.lib=" + file);
            if (Utilities.isWindows()) {
                arrayList.add("-Djruby.shell=\"cmd.exe\"");
                arrayList.add("-Djruby.script=jruby.bat");
            } else {
                arrayList.add("-Djruby.shell=/bin/sh");
                arrayList.add("-Djruby.script=jruby");
            }
            arrayList.add("org.jruby.Main");
        }
        if (SYNC_RUBY_STDIO && string2.startsWith("ruby") && ((n = string2.indexOf(46)) == -1 || n == 4 || n == 5)) {
            object2 = InstalledFileLocator.getDefault();
            object = object2.locate("modules/org-netbeans-modules-ruby-project.jar", null, false);
            if (object == null) {
                throw new RuntimeException("Can't find cluster");
            }
            object = new File(((File)object).getParentFile().getParentFile().getAbsolutePath() + File.separator + "sync-stdio.rb");
            try {
                object = ((File)object).getCanonicalFile();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            arrayList.add("-r" + ((File)object).getAbsolutePath());
        }
        return arrayList;
    }

    static String computeJRubyClassPath(String string, File file) {
        StringBuilder stringBuilder = new StringBuilder();
        File[] fileArray = file.listFiles();
        for (File file2 : fileArray) {
            if (!file2.getName().endsWith(".jar")) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparatorChar);
            }
            stringBuilder.append(file2.getAbsolutePath());
        }
        if (string != null && File.pathSeparatorChar != ':') {
            StringBuilder stringBuilder2 = new StringBuilder();
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == ':' && n != 1) {
                    stringBuilder2.append(File.pathSeparatorChar);
                    n = 0;
                    continue;
                }
                ++n;
                stringBuilder2.append(c);
            }
            string = stringBuilder2.toString();
        }
        if (string == null) {
            string = System.getenv("JRUBY_EXTRA_CLASSPATH");
        }
        if (string != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparatorChar);
            }
            stringBuilder.append(string);
        }
        return Utilities.isWindows() ? "\"" + stringBuilder.toString() + "\"" : stringBuilder.toString();
    }

    public static void setupProcessEnvironment(Map<String, String> map, String string, boolean bl) {
        String string2;
        Object object;
        String string3 = string;
        if (!Utilities.isWindows()) {
            string3 = string3.replace(" ", "\\ ");
        }
        String string4 = "PATH";
        if (Utilities.isWindows()) {
            string4 = "Path";
            object = map.keySet().iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                if (!"PATH".equals(string2.toUpperCase())) continue;
                string4 = string2;
                break;
            }
        }
        if ((object = map.get(string4)) == null) {
            object = "";
        }
        object = string3 + File.pathSeparator + (String)object;
        if (bl) {
            string2 = System.getProperty("jruby.java.home");
            if (string2 == null) {
                string2 = System.getProperty("jdk.home");
            }
            String string5 = string2 + File.separator + "bin";
            if (!Utilities.isWindows()) {
                string5 = string5.replace(" ", "\\ ");
            }
            object = (String)object + File.pathSeparator + string5;
        }
        map.put(string4, (String)object);
    }

    public static String getJavaHome() {
        String string = System.getProperty("jruby.java.home");
        if (string == null) {
            string = System.getProperty("java.home");
        }
        return string;
    }

    public static void logProcess(ProcessBuilder processBuilder) {
        if (LOGGER.isLoggable(Level.FINE)) {
            File file = processBuilder.directory();
            String string = file == null ? "" : "(basedir: " + file.getAbsolutePath() + ") ";
            LOGGER.fine("Running: " + string + '\"' + ExecutionUtils.getProcessAsString(processBuilder.command()) + '\"');
            LOGGER.fine("Environment: " + processBuilder.environment());
        }
    }

    private static String getProcessAsString(List<? extends String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string).append(' ');
        }
        return stringBuilder.toString().trim();
    }

    public static FileLocation getLocation(String string) {
        if (string.length() > 400) {
            return null;
        }
        for (Pattern pattern : LOCATION_RECOGNIZER_PATTERNS) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            String string2 = null;
            int n = -1;
            string2 = matcher.group(1);
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1);
            }
            if (string2.startsWith("./")) {
                string2 = string2.substring(2);
            }
            if (!RubyLineConvertorFactory.EXT_RE.matcher(string2).matches() && !new File(string2).isFile()) {
                return null;
            }
            String string3 = matcher.group(2);
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Exceptions.printStackTrace((Throwable)numberFormatException);
                n = 0;
            }
            return new FileLocation(string2, n);
        }
        return null;
    }

    public static final class FileLocation {
        public final String file;
        public final int line;

        public FileLocation(String string, int n) {
            this.file = string;
            this.line = n;
        }
    }
}

