/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;

final class FileObjectKeeper
implements FileChangeListener {
    private static final Logger LOG = Logger.getLogger(FileObjectKeeper.class.getName());
    private Set<FileObject> kept;
    private Collection<FileChangeListener> listeners;
    private final FolderObj root;
    private long timeStamp;

    public FileObjectKeeper(FolderObj folderObj) {
        this.root = folderObj;
    }

    public synchronized void addRecursiveListener(FileChangeListener fileChangeListener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArraySet<FileChangeListener>();
        }
        if (this.listeners.isEmpty()) {
            this.listenToAll();
        }
        this.listeners.add(fileChangeListener);
    }

    public synchronized void removeRecursiveListener(FileChangeListener fileChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(fileChangeListener);
        if (this.listeners.isEmpty()) {
            this.listenNoMore();
        }
    }

    public void init(long l, FileObjectFactory fileObjectFactory, boolean bl) {
        File file = this.root.getFileName().getFile();
        File[] fileArray = file.listFiles();
        long l2 = 0L;
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) continue;
                long l3 = file2.lastModified();
                LOG.log(Level.FINE, "  check {0} for {1}", new Object[]{l3, file2});
                if (l3 > l2) {
                    l2 = l3;
                }
                if (l3 <= l || fileObjectFactory == null) continue;
                BaseFileObj baseFileObj = fileObjectFactory.getCachedOnly(file2);
                if (baseFileObj == null) {
                    BaseFileObj baseFileObj2 = fileObjectFactory.getValidFileObject(file2, FileObjectFactory.Caller.Others);
                    if (baseFileObj2 != null) {
                        LOG.log(Level.FINE, "External change detected {0}", (Object)baseFileObj2);
                        baseFileObj2.fireFileChangedEvent(bl);
                        continue;
                    }
                    LOG.log(Level.FINE, "Cannot get valid FileObject. File probably removed: {0}", file2);
                    continue;
                }
                baseFileObj.refresh(bl, true);
            }
        }
        this.timeStamp = l2;
        LOG.log(Level.FINE, "Testing {0}, time {1}", new Object[]{file, this.timeStamp});
    }

    private final void listenToAll() {
        assert (Thread.holdsLock(this));
        assert (this.kept == null);
        this.kept = new HashSet<FileObject>();
        this.root.addFileChangeListener(this);
        Enumeration enumeration = this.root.getChildren(true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject = (FileObject)enumeration.nextElement();
            if (!(fileObject instanceof FolderObj)) continue;
            FolderObj folderObj = (FolderObj)fileObject;
            folderObj.addFileChangeListener(this);
            this.kept.add(folderObj);
            folderObj.getKeeper();
        }
    }

    private final void listenNoMore() {
        assert (Thread.holdsLock(this));
        this.root.removeFileChangeListener(this);
        Set<FileObject> set = this.kept;
        if (set != null) {
            for (FileObject fileObject : set) {
                fileObject.removeFileChangeListener((FileChangeListener)this);
            }
            this.kept = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileFolderCreated(FileEvent fileEvent) {
        Collection<FileChangeListener> collection = this.listeners;
        if (collection == null) {
            return;
        }
        FileObject fileObject = fileEvent.getFile();
        if (fileObject instanceof FolderObj) {
            FileObjectKeeper fileObjectKeeper = this;
            synchronized (fileObjectKeeper) {
                this.kept.add(fileObject);
                fileObject.addFileChangeListener((FileChangeListener)this);
                Enumeration object = fileObject.getChildren(true);
                while (object.hasMoreElements()) {
                    FileObject fileObject2 = (FileObject)object.nextElement();
                    if (!(fileObject2 instanceof FolderObj)) continue;
                    fileObject2.addFileChangeListener((FileChangeListener)this);
                }
            }
        }
        for (FileChangeListener fileChangeListener : collection) {
            fileChangeListener.fileFolderCreated(fileEvent);
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        Collection<FileChangeListener> collection = this.listeners;
        if (collection == null) {
            return;
        }
        for (FileChangeListener fileChangeListener : collection) {
            fileChangeListener.fileDataCreated(fileEvent);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
        Collection<FileChangeListener> collection = this.listeners;
        if (collection == null) {
            return;
        }
        for (FileChangeListener fileChangeListener : collection) {
            fileChangeListener.fileChanged(fileEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileDeleted(FileEvent fileEvent) {
        Collection<FileChangeListener> collection = this.listeners;
        if (collection == null) {
            return;
        }
        FileObject fileObject = fileEvent.getFile();
        if (fileObject.isFolder() && fileEvent.getSource() == fileObject && fileObject != this.root) {
            return;
        }
        for (FileChangeListener fileChangeListener : collection) {
            fileChangeListener.fileDeleted(fileEvent);
        }
        if (fileObject instanceof FolderObj) {
            FileObjectKeeper fileObjectKeeper = this;
            synchronized (fileObjectKeeper) {
                if (this.kept != null) {
                    this.kept.remove(fileObject);
                }
                fileObject.removeFileChangeListener((FileChangeListener)this);
            }
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        Collection<FileChangeListener> collection = this.listeners;
        if (collection == null) {
            return;
        }
        FileObject fileObject = fileRenameEvent.getFile();
        if (fileObject.isFolder() && fileRenameEvent.getSource() == fileObject && fileObject != this.root) {
            return;
        }
        for (FileChangeListener fileChangeListener : collection) {
            fileChangeListener.fileRenamed(fileRenameEvent);
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        Collection<FileChangeListener> collection = this.listeners;
        if (collection == null) {
            return;
        }
        for (FileChangeListener fileChangeListener : collection) {
            fileChangeListener.fileAttributeChanged(fileAttributeEvent);
        }
    }

    long childrenLastModified() {
        return this.timeStamp;
    }
}

