/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.properties;

import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.api.properties.GroupValue;

final class SaveToModelSupport {
    private SaveToModelSupport() {
    }

    public static void saveToModel(final DesignComponent designComponent, final GroupValue groupValue, final DesignPropertyEditor designPropertyEditor) {
        if (designComponent == null || groupValue == null) {
            throw new IllegalArgumentException("Null argument exception");
        }
        designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

            public void run() {
                if (designPropertyEditor != null && designPropertyEditor.isExecuteInsideWriteTransactionUsed() && !designPropertyEditor.executeInsideWriteTransaction()) {
                    return;
                }
                for (String string : groupValue.getPropertyNames()) {
                    if (groupValue.getValue(string) instanceof PropertyValue) {
                        designComponent.writeProperty(string, (PropertyValue)groupValue.getValue(string));
                        continue;
                    }
                    if (groupValue.getValue(string) == null) {
                        designComponent.writeProperty(string, PropertyValue.createNull());
                        continue;
                    }
                    if (groupValue.getValue(string) instanceof DesignComponent) {
                        designComponent.writeProperty(string, PropertyValue.createComponentReference((DesignComponent)((DesignComponent)groupValue.getValue(string))));
                        continue;
                    }
                    designComponent.writeProperty(string, PropertyValue.createValue((String)designComponent.getDocument().getDocumentInterface().getProjectType(), (TypeID)SaveToModelSupport.getComponentTypeID(designComponent, string), (Object)groupValue.getValue(string)));
                }
            }
        });
    }

    private static TypeID getComponentTypeID(DesignComponent designComponent, String string) {
        return designComponent.getComponentDescriptor().getPropertyDescriptor(string).getType();
    }
}

