/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.quicksearch.AbstractQuickSearchComboBar;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class QuickSearchComboBar
extends AbstractQuickSearchComboBar {
    private final ImageIcon findIcon = new ImageIcon(this.getClass().getResource("/org/netbeans/modules/quicksearch/resources/find.png"));
    private final Timer animationTimer = new Timer(100, new ActionListener(){
        ImageIcon[] icons;
        int index = 0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.icons == null) {
                this.icons = new ImageIcon[8];
                for (int i = 0; i < 8; ++i) {
                    this.icons[i] = ImageUtilities.loadImageIcon((String)("org/netbeans/modules/quicksearch/resources/progress_" + i + ".png"), (boolean)false);
                }
            }
            QuickSearchComboBar.this.jLabel2.setIcon(this.icons[this.index]);
            this.index = (this.index + 1) % 8;
        }
    });
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;

    public QuickSearchComboBar(KeyStroke keyStroke) {
        super(keyStroke);
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jSeparator1 = new JSeparator();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setBackground(QuickSearchComboBar.getTextBackground());
        this.jPanel1.setBorder(BorderFactory.createLineBorder(QuickSearchComboBar.getComboBorderColor()));
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel2.setIcon(this.findIcon);
        this.jLabel2.setToolTipText(NbBundle.getMessage(QuickSearchComboBar.class, (String)"QuickSearchComboBar.jLabel2.toolTipText"));
        this.jLabel2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jLabel2.setName("jLabel2");
        this.jLabel2.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                QuickSearchComboBar.this.jLabel2MousePressed(mouseEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 2, 1, 1);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.jScrollPane1.setViewportBorder(null);
        this.jScrollPane1.setMinimumSize(new Dimension(2, 18));
        this.jScrollPane1.setName("jScrollPane1");
        this.jScrollPane1.setViewportView(this.command);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jSeparator1.setOrientation(1);
        this.jSeparator1.setName("jSeparator1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.jPanel1.add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void jLabel2MousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    protected JTextComponent createCommandField() {
        DynamicWidthTA dynamicWidthTA = new DynamicWidthTA();
        dynamicWidthTA.setRows(1);
        dynamicWidthTA.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        for (InputMap inputMap = dynamicWidthTA.getInputMap(0); inputMap != null; inputMap = inputMap.getParent()) {
            inputMap.remove(KeyStroke.getKeyStroke(79, 192));
        }
        return dynamicWidthTA;
    }

    protected JComponent getInnerComponent() {
        return this.jPanel1;
    }

    void startProgressAnimation() {
        if (this.animationTimer != null && !this.animationTimer.isRunning()) {
            this.animationTimer.start();
        }
    }

    void stopProgressAnimation() {
        if (this.animationTimer != null && this.animationTimer.isRunning()) {
            this.animationTimer.stop();
            this.jLabel2.setIcon(this.findIcon);
        }
    }

    private final class DynamicWidthTA
    extends JTextArea {
        private Dimension prefWidth;

        private DynamicWidthTA() {
        }

        public Dimension getPreferredSize() {
            if (this.prefWidth == null) {
                Dimension dimension = super.getPreferredSize();
                this.prefWidth = new Dimension(QuickSearchComboBar.this.computePrefWidth(), dimension.height);
            }
            return this.prefWidth;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }
}

