/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManagerEvent;
import org.netbeans.modules.java.source.usages.ClassIndexManagerListener;
import org.netbeans.modules.java.source.usages.PersistentClassIndex;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassIndexManager {
    private static final byte OP_ADD = 1;
    private static final byte OP_REMOVE = 2;
    private static ClassIndexManager instance;
    private final Map<URL, ClassIndexImpl> instances = new HashMap<URL, ClassIndexImpl>();
    private final ReentrantReadWriteLock lock;
    private final InternalLock internalLock;
    private final List<ClassIndexManagerListener> listeners = new CopyOnWriteArrayList<ClassIndexManagerListener>();
    private boolean invalid;
    private Set<URL> added;
    private Set<URL> removed;
    private int depth = 0;

    private ClassIndexManager() {
        this.lock = new ReentrantReadWriteLock(false);
        this.internalLock = new InternalLock();
    }

    public void addClassIndexManagerListener(ClassIndexManagerListener classIndexManagerListener) {
        assert (classIndexManagerListener != null);
        this.listeners.add(classIndexManagerListener);
    }

    public void removeClassIndexManagerListener(ClassIndexManagerListener classIndexManagerListener) {
        assert (classIndexManagerListener != null);
        this.listeners.remove(classIndexManagerListener);
    }

    @Deprecated
    public <T> T writeLock(final ExceptionAction<T> exceptionAction) throws IOException, InterruptedException {
        return this.prepareWriteLock(new ExceptionAction<T>(){

            @Override
            public T run() throws IOException, InterruptedException {
                return ClassIndexManager.this.takeWriteLock(exceptionAction);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public <T> T prepareWriteLock(ExceptionAction<T> exceptionAction) throws IOException, InterruptedException {
        InternalLock internalLock2 = this.internalLock;
        // MONITORENTER : internalLock2
        ++this.depth;
        if (this.depth == 1) {
            this.added = new HashSet<URL>();
            this.removed = new HashSet<URL>();
        }
        // MONITOREXIT : internalLock2
        try {
            HashSet<URL> hashSet;
            HashSet<URL> hashSet2;
            try {
                internalLock2 = exceptionAction.run();
                Object var5_3 = null;
                hashSet2 = null;
                hashSet = null;
                InternalLock internalLock = this.internalLock;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                HashSet<URL> hashSet3 = null;
                HashSet<URL> hashSet22 = null;
                InternalLock internalLock3 = this.internalLock;
                // MONITORENTER : internalLock3
                if (this.depth == 1) {
                    if (!this.removed.isEmpty()) {
                        hashSet22 = new HashSet<URL>(this.removed);
                        this.removed.clear();
                    }
                    if (!this.added.isEmpty()) {
                        hashSet3 = new HashSet<URL>(this.added);
                        this.added.clear();
                    }
                }
                // MONITOREXIT : internalLock3
                if (hashSet22 != null) {
                    this.fire(hashSet22, (byte)2);
                }
                if (hashSet3 == null) throw throwable;
                this.fire(hashSet3, (byte)1);
                throw throwable;
            }
            if (this.depth == 1) {
                if (!this.removed.isEmpty()) {
                    hashSet = new HashSet<URL>(this.removed);
                    this.removed.clear();
                }
                if (!this.added.isEmpty()) {
                    hashSet2 = new HashSet<URL>(this.added);
                    this.added.clear();
                }
            }
            // MONITOREXIT : internalLock
            if (hashSet != null) {
                this.fire(hashSet, (byte)2);
            }
            if (hashSet2 != null) {
                this.fire(hashSet2, (byte)1);
            }
            Object var11_11 = null;
            InternalLock internalLock = this.internalLock;
            // MONITORENTER : internalLock
            --this.depth;
            // MONITOREXIT : internalLock
            return (T)internalLock2;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            InternalLock internalLock = this.internalLock;
            // MONITORENTER : internalLock
            --this.depth;
            // MONITOREXIT : internalLock
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T takeWriteLock(ExceptionAction<T> exceptionAction) throws IOException, InterruptedException {
        T t;
        this.lock.writeLock().lock();
        try {
            t = exceptionAction.run();
            Object var4_3 = null;
            this.lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.writeLock().unlock();
            throw throwable;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readLock(ExceptionAction<T> exceptionAction) throws IOException, InterruptedException {
        T t;
        this.lock.readLock().lock();
        try {
            t = exceptionAction.run();
            Object var4_3 = null;
            this.lock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.readLock().unlock();
            throw throwable;
        }
        return t;
    }

    public boolean holdsWriteLock() {
        return this.lock.isWriteLockedByCurrentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassIndexImpl getUsagesQuery(URL uRL) {
        InternalLock internalLock = this.internalLock;
        synchronized (internalLock) {
            assert (uRL != null);
            if (this.invalid) {
                return null;
            }
            return this.instances.get(uRL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassIndexImpl createUsagesQuery(URL uRL, boolean bl) throws IOException {
        assert (uRL != null);
        InternalLock internalLock = this.internalLock;
        synchronized (internalLock) {
            if (this.invalid) {
                return null;
            }
            ClassIndexImpl classIndexImpl = this.instances.get(uRL);
            if (classIndexImpl == null) {
                classIndexImpl = PersistentClassIndex.create(uRL, JavaIndex.getIndex(uRL), bl);
                this.instances.put(uRL, classIndexImpl);
                if (this.added != null) {
                    this.added.add(uRL);
                }
            } else if (bl && !classIndexImpl.isSource()) {
                classIndexImpl.close();
                classIndexImpl = PersistentClassIndex.create(uRL, JavaIndex.getIndex(uRL), bl);
                this.instances.put(uRL, classIndexImpl);
                if (this.added != null) {
                    this.added.add(uRL);
                }
            }
            return classIndexImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoot(URL uRL) throws IOException {
        InternalLock internalLock = this.internalLock;
        synchronized (internalLock) {
            ClassIndexImpl classIndexImpl = this.instances.remove(uRL);
            if (classIndexImpl != null) {
                classIndexImpl.close();
                if (this.removed != null) {
                    this.removed.add(uRL);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        InternalLock internalLock = this.internalLock;
        synchronized (internalLock) {
            this.invalid = true;
            for (ClassIndexImpl classIndexImpl : this.instances.values()) {
                try {
                    classIndexImpl.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    private void fire(Set<? extends URL> set, byte by) {
        if (!this.listeners.isEmpty()) {
            ClassIndexManagerEvent classIndexManagerEvent = new ClassIndexManagerEvent(this, set);
            for (ClassIndexManagerListener classIndexManagerListener : this.listeners) {
                if (by == 1) {
                    classIndexManagerListener.classIndexAdded(classIndexManagerEvent);
                    continue;
                }
                if (by == 2) {
                    classIndexManagerListener.classIndexRemoved(classIndexManagerEvent);
                    continue;
                }
                assert (false) : "Unknown op: " + by;
            }
        }
    }

    public static synchronized ClassIndexManager getDefault() {
        if (instance == null) {
            instance = new ClassIndexManager();
        }
        return instance;
    }

    private static final class InternalLock {
        private InternalLock() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExceptionAction<T> {
        public T run() throws IOException, InterruptedException;
    }
}

