/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.CachingArchive;
import org.netbeans.modules.java.source.parsing.FileObjectArchive;
import org.netbeans.modules.java.source.parsing.FolderArchive;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingArchiveProvider {
    private static CachingArchiveProvider instance;
    HashMap<URL, Archive> archives = new HashMap();

    public static synchronized CachingArchiveProvider getDefault() {
        if (instance == null) {
            instance = new CachingArchiveProvider();
        }
        return instance;
    }

    CachingArchiveProvider() {
    }

    public synchronized Archive getArchive(URL uRL, boolean bl) {
        Archive archive = this.archives.get(uRL);
        if (archive == null && (archive = CachingArchiveProvider.create(uRL, bl)) != null) {
            this.archives.put(uRL, archive);
        }
        return archive;
    }

    public synchronized Iterable<Archive> getArchives(URL[] uRLArray, boolean bl) {
        ArrayList<Archive> arrayList = new ArrayList<Archive>(uRLArray.length);
        for (int i = 0; i < uRLArray.length; ++i) {
            Archive archive = this.getArchive(uRLArray[i], bl);
            if (archive == null) continue;
            arrayList.add(archive);
        }
        return arrayList;
    }

    public synchronized Iterable<Archive> getArchives(ClassPath classPath, boolean bl) {
        List list = classPath.entries();
        ArrayList<Archive> arrayList = new ArrayList<Archive>(list.size());
        for (ClassPath.Entry entry : list) {
            Archive archive = this.getArchive(entry.getURL(), bl);
            if (archive == null) continue;
            arrayList.add(archive);
        }
        return arrayList;
    }

    public synchronized void removeArchive(URL uRL) {
        Archive archive = this.archives.remove(uRL);
        if (archive != null) {
            archive.clear();
        }
    }

    public synchronized void clearArchive(URL uRL) {
        Archive archive = this.archives.get(uRL);
        if (archive != null) {
            archive.clear();
        }
    }

    private static Archive create(URL uRL, boolean bl) {
        URL uRL2;
        String string = uRL.getProtocol();
        if ("file".equals(string)) {
            File file = new File(URI.create(uRL.toExternalForm()));
            if (file.isDirectory()) {
                return new FolderArchive(file);
            }
            return null;
        }
        if ("jar".equals(string) && "file".equals(string = (uRL2 = FileUtil.getArchiveFile((URL)uRL)).getProtocol())) {
            File file = new File(URI.create(uRL2.toExternalForm()));
            if (file.isFile()) {
                return new CachingArchive(file, bl);
            }
            return null;
        }
        uRL2 = URLMapper.findFileObject((URL)uRL);
        if (uRL2 != null) {
            return new FileObjectArchive((FileObject)uRL2);
        }
        return null;
    }

    void clear() {
        this.archives.clear();
    }
}

