/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.indexing.CompileWorker;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.indexing.JavaParsingContext;
import org.netbeans.modules.java.source.indexing.MultiPassCompileWorker;
import org.netbeans.modules.java.source.indexing.OnePassCompileWorker;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.netbeans.modules.java.source.tasklist.TaskCache;
import org.netbeans.modules.java.source.tasklist.TasklistSettings;
import org.netbeans.modules.java.source.usages.BuildArtifactMapperImpl;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.java.source.usages.VirtualSourceProviderQuery;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCustomIndexer
extends CustomIndexer {
    private static final String SOURCE_LEVEL_ROOT = "sourceLevel";
    private static final String DIRTY_ROOT = "dirty";
    private static final Pattern ANONYMOUS = Pattern.compile("\\$[0-9]");
    private static final ClassPath EMPTY = ClassPathSupport.createClassPath((URL[])new URL[0]);
    private static final CompileWorker[] WORKERS = new CompileWorker[]{new OnePassCompileWorker(), new MultiPassCompileWorker()};

    protected void index(Iterable<? extends Indexable> iterable, final Context context) {
        JavaIndex.LOG.log(Level.FINE, context.isSupplementaryFilesIndexing() ? "index suplementary({0})" : "index({0})", context.isAllFilesIndexing() ? context.getRootURI() : iterable);
        try {
            FileObject fileObject = context.getRoot();
            if (fileObject == null) {
                JavaIndex.LOG.fine("Ignoring request with no root");
                return;
            }
            String string = SourceLevelQuery.getSourceLevel((FileObject)fileObject);
            if (JavaIndex.ensureAttributeValue(context.getRootURI(), SOURCE_LEVEL_ROOT, string)) {
                JavaIndex.LOG.fine("forcing reindex due to source level change");
                IndexingManager.getDefault().refreshIndex(context.getRootURI(), null);
                return;
            }
            if (JavaIndex.ensureAttributeValue(context.getRootURI(), DIRTY_ROOT, null) && !context.isAllFilesIndexing()) {
                JavaIndex.LOG.fine("forcing reindex due to dirty root");
                IndexingManager.getDefault().refreshIndex(context.getRootURI(), null);
                return;
            }
            final ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            final ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
            final ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
            if (classPath == null || classPath2 == null || classPath3 == null) {
                JavaIndex.LOG.warning("Ignoring root with no ClassPath: " + FileUtil.getFileDisplayName((FileObject)fileObject));
                return;
            }
            if (!Arrays.asList(classPath.getRoots()).contains(fileObject)) {
                JavaIndex.LOG.warning("Source root: " + FileUtil.getFileDisplayName((FileObject)fileObject) + " is not on its sourcepath");
                return;
            }
            final ArrayList arrayList = new ArrayList();
            final Collection<? extends CompileTuple> collection = JavaCustomIndexer.translateVirtualSources(JavaCustomIndexer.splitSources(iterable, arrayList), context.getRootURI());
            ClassIndexManager.getDefault().prepareWriteLock(new ClassIndexManager.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, InterruptedException {
                    return TaskCache.getDefault().refreshTransaction(new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            Object object22;
                            JavaParsingContext javaParsingContext = new JavaParsingContext(context, classPath2, classPath3, classPath, collection);
                            if (javaParsingContext.uq == null) {
                                return null;
                            }
                            HashSet hashSet = new HashSet();
                            HashSet<File> hashSet2 = new HashSet<File>();
                            ArrayList<CompileTuple> arrayList = new ArrayList<CompileTuple>(arrayList.size() + collection.size());
                            javaParsingContext.uq.setDirty(null);
                            for (Object object22 : arrayList) {
                                CompileTuple compileTuple = JavaCustomIndexer.createTuple(context, javaParsingContext, (Indexable)object22);
                                if (compileTuple != null) {
                                    arrayList.add(compileTuple);
                                }
                                JavaCustomIndexer.clear(context, javaParsingContext, object22.getRelativePath(), hashSet, hashSet2);
                            }
                            for (Object object22 : collection) {
                                JavaCustomIndexer.clear(context, javaParsingContext, ((CompileTuple)object22).indexable.getRelativePath(), hashSet, hashSet2);
                            }
                            arrayList.addAll(collection);
                            Object object3 = null;
                            for (CompileWorker object4 : WORKERS) {
                                if ((object3 = object4.compile((CompileWorker.ParsingOutput)object3, context, javaParsingContext, (Iterable<? extends CompileTuple>)arrayList)) == null || context.isCancelled()) {
                                    return null;
                                }
                                if (((CompileWorker.ParsingOutput)object3).success) break;
                            }
                            assert (object3 != null);
                            object22 = new HashSet<ElementHandle<TypeElement>>(((CompileWorker.ParsingOutput)object3).addedTypes);
                            HashSet hashSet3 = new HashSet(hashSet);
                            object22.removeAll(hashSet);
                            hashSet3.removeAll(((CompileWorker.ParsingOutput)object3).addedTypes);
                            ((CompileWorker.ParsingOutput)object3).addedTypes.retainAll(hashSet);
                            if (!context.isSupplementaryFilesIndexing() && !context.isCancelled()) {
                                ((CompileWorker.ParsingOutput)object3).modifiedTypes.addAll(hashSet3);
                                Map map = JavaCustomIndexer.findDependent(context.getRootURI(), ((CompileWorker.ParsingOutput)object3).modifiedTypes, !object22.isEmpty());
                                Set set = (Set)map.get(context.getRootURI());
                                if (set != null) {
                                    if (context.isAllFilesIndexing()) {
                                        map.remove(context.getRootURI());
                                    } else {
                                        for (CompileTuple compileTuple : arrayList) {
                                            set.remove(compileTuple.indexable.getURL());
                                        }
                                        if (set.isEmpty()) {
                                            map.remove(context.getRootURI());
                                        }
                                    }
                                }
                                for (Map.Entry entry : map.entrySet()) {
                                    context.addSupplementaryFiles((URL)entry.getKey(), (Collection)entry.getValue());
                                }
                            }
                            javaParsingContext.checkSums.store();
                            javaParsingContext.sa.store();
                            javaParsingContext.uq.typesEvent((Collection<? extends ElementHandle<TypeElement>>)object22, hashSet3, ((CompileWorker.ParsingOutput)object3).addedTypes);
                            if (!context.checkForEditorModifications()) {
                                BuildArtifactMapperImpl.classCacheUpdated(context.getRootURI(), JavaIndex.getClassFolder(context.getRootURI()), hashSet2, ((CompileWorker.ParsingOutput)object3).createdFiles, false);
                            }
                            return null;
                        }
                    });
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static final List<? extends Indexable> splitSources(Iterable<? extends Indexable> iterable, List<? super Indexable> list) {
        LinkedList<Indexable> linkedList = new LinkedList<Indexable>();
        for (Indexable indexable : iterable) {
            if (indexable.getURL() == null) continue;
            if (VirtualSourceProviderQuery.hasVirtualSource(indexable)) {
                linkedList.add(indexable);
                continue;
            }
            list.add((Indexable)indexable);
        }
        return linkedList;
    }

    private static Collection<? extends CompileTuple> translateVirtualSources(Collection<? extends Indexable> collection, URL uRL) throws IOException {
        if (collection.isEmpty()) {
            return Collections.emptySet();
        }
        try {
            File file = new File(URI.create(uRL.toString()));
            return VirtualSourceProviderQuery.translate(collection, file);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JavaIndex.LOG.warning("Virtual sources in the root: " + uRL + " are ignored due to: " + illegalArgumentException.getMessage());
            return Collections.emptySet();
        }
    }

    private static CompileTuple createTuple(Context context, JavaParsingContext javaParsingContext, Indexable indexable) {
        FileObject fileObject;
        File file = null;
        if (!context.checkForEditorModifications() && "file".equals(indexable.getURL().getProtocol()) && (file = FileUtil.toFile((FileObject)context.getRoot())) != null) {
            try {
                File file2 = new File(indexable.getURL().toURI().getPath());
                return new CompileTuple(FileObjects.fileFileObject(file2, file, null, javaParsingContext.encoding), indexable);
            }
            catch (Exception exception) {
            }
            catch (AssertionError assertionError) {
                throw (AssertionError)((Object)Exceptions.attachMessage((Throwable)((Object)assertionError), (String)("Root FileObject: " + FileUtil.getFileDisplayName((FileObject)context.getRoot()) + " Indexable URL: " + indexable.getURL() + " Normalized root: " + FileUtil.normalizeFile((File)file).getAbsolutePath())));
            }
        }
        return (fileObject = URLMapper.findFileObject((URL)indexable.getURL())) != null ? new CompileTuple(SourceFileObject.create(fileObject, context.getRoot()), indexable) : null;
    }

    private static void clearFiles(final Context context, final Iterable<? extends Indexable> iterable) {
        try {
            if (context.getRoot() == null) {
                JavaIndex.LOG.fine("Ignoring request with no root");
                return;
            }
            ClassIndexManager.getDefault().prepareWriteLock(new ClassIndexManager.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, InterruptedException {
                    return TaskCache.getDefault().refreshTransaction(new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            JavaParsingContext javaParsingContext = new JavaParsingContext(context);
                            if (javaParsingContext.uq == null) {
                                return null;
                            }
                            HashSet hashSet = new HashSet();
                            HashSet<File> hashSet2 = new HashSet<File>();
                            for (Indexable object : iterable) {
                                JavaCustomIndexer.clear(context, javaParsingContext, object.getRelativePath(), hashSet, hashSet2);
                                TaskCache.getDefault().dumpErrors(context.getRootURI(), object.getURL(), Collections.emptyList());
                                javaParsingContext.checkSums.remove(object.getURL());
                            }
                            for (Map.Entry entry : JavaCustomIndexer.findDependent(context.getRootURI(), hashSet, false).entrySet()) {
                                context.addSupplementaryFiles((URL)entry.getKey(), (Collection)entry.getValue());
                            }
                            javaParsingContext.checkSums.store();
                            javaParsingContext.sa.store();
                            BuildArtifactMapperImpl.classCacheUpdated(context.getRootURI(), JavaIndex.getClassFolder(context.getRootURI()), hashSet2, Collections.<File>emptySet(), false);
                            javaParsingContext.uq.typesEvent(null, hashSet, null);
                            return null;
                        }
                    });
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static void clear(Context context, JavaParsingContext javaParsingContext, String string, Set<ElementHandle<TypeElement>> set, Set<File> set2) throws IOException {
        Object object;
        Object object2;
        boolean bl;
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
        File file = JavaIndex.getClassFolder(context);
        String string2 = FileObjects.getExtension(string);
        String string3 = FileObjects.stripExtension(string);
        boolean bl2 = VirtualSourceProviderQuery.hasVirtualSource(string2);
        File file2 = bl2 ? new File(file, string + '.' + "rx") : new File(file, string3 + '.' + "rs");
        boolean bl3 = bl = !bl2;
        if (file2.exists()) {
            bl = false;
            try {
                object2 = FileObjects.getBinaryName(file2, file);
                for (String string4 : JavaCustomIndexer.readRSFile(file2, file)) {
                    object = new File(file, FileObjects.convertPackage2Folder(string4) + '.' + "sig");
                    if (!((String)object2).equals(string4)) {
                        arrayList.add(Pair.of(string4, string));
                        set.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, string4));
                        set2.add((File)object);
                        ((File)object).delete();
                        continue;
                    }
                    bl = !bl2;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            file2.delete();
        }
        if (bl && (file2 = new File(file, string3 + '.' + "sig")).exists()) {
            object2 = file2.getName();
            object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(46));
            final String[] stringArray = new String[]{(String)object2 + '.', (String)object2 + '$'};
            File file3 = file2.getParentFile();
            object = new FilenameFilter(){

                public boolean accept(File file, String string) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string.startsWith(stringArray[i])) continue;
                        return true;
                    }
                    return false;
                }
            };
            for (File file4 : file3.listFiles((FilenameFilter)object)) {
                String string5 = FileObjects.getBinaryName(file4, file);
                arrayList.add(Pair.of(string5, null));
                set.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, string5));
                set2.add(file4);
                file4.delete();
            }
        }
        for (Pair pair : arrayList) {
            javaParsingContext.sa.delete(pair);
        }
    }

    private static void markDirtyFiles(Context context, Iterable<? extends Indexable> iterable) {
        ClassIndexImpl classIndexImpl = ClassIndexManager.getDefault().getUsagesQuery(context.getRootURI());
        if (classIndexImpl != null) {
            for (Indexable indexable : iterable) {
                classIndexImpl.setDirty(indexable.getURL());
            }
        }
    }

    public static void verifySourceLevel(URL uRL, String string) throws IOException {
        if (JavaIndex.ensureAttributeValue(uRL, SOURCE_LEVEL_ROOT, string)) {
            JavaIndex.LOG.fine("forcing reindex due to source level change");
            IndexingManager.getDefault().refreshIndex(uRL, null);
        }
    }

    public static Collection<? extends ElementHandle<TypeElement>> getRelatedTypes(File file, File file2) throws IOException {
        String string;
        boolean bl;
        LinkedList<ElementHandle> linkedList = new LinkedList<ElementHandle>();
        File file3 = JavaIndex.getClassFolder(file2);
        String string2 = FileObjects.getRelativePath(file2, file);
        String string3 = FileObjects.getExtension(string2);
        String string4 = FileObjects.stripExtension(string2);
        boolean bl2 = VirtualSourceProviderQuery.hasVirtualSource(string3);
        File file4 = bl2 ? new File(file3, string2 + '.' + "rx") : new File(file3, string4 + '.' + "rs");
        boolean bl3 = bl = !bl2;
        if (file4.exists()) {
            bl = false;
            try {
                string = FileObjects.getBinaryName(file4, file3);
                for (String object : JavaCustomIndexer.readRSFile(file4, file3)) {
                    if (!string.equals(object)) {
                        linkedList.add(ElementHandleAccessor.INSTANCE.create(ElementKind.CLASS, object));
                        continue;
                    }
                    bl = !bl2;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (bl && (file4 = new File(file3, string4 + '.' + "sig")).exists()) {
            string = file4.getName();
            string = string.substring(0, string.lastIndexOf(46));
            final String[] stringArray = new String[]{string + '.', string + '$'};
            File file5 = file4.getParentFile();
            FilenameFilter filenameFilter = new FilenameFilter(){

                public boolean accept(File file, String string) {
                    if (!string.endsWith("sig")) {
                        return false;
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string.startsWith(stringArray[i])) continue;
                        return true;
                    }
                    return false;
                }
            };
            for (File file6 : file5.listFiles(filenameFilter)) {
                String string5 = FileObjects.getBinaryName(file6, file3);
                linkedList.add(ElementHandleAccessor.INSTANCE.create(ElementKind.CLASS, string5));
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readRSFile(File file, File file2) throws IOException {
        LinkedList<String> linkedList = new LinkedList<String>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                linkedList.add(string);
            }
        }
        finally {
            bufferedReader.close();
        }
        return linkedList;
    }

    private static Map<URL, Set<URL>> findDependent(URL uRL, Collection<ElementHandle<TypeElement>> collection, boolean bl) throws IOException {
        Map map = IndexingController.getDefault().getRootDependencies();
        HashMap<URL, List<URL>> hashMap = new HashMap<URL, List<URL>>();
        for (Map.Entry entry : map.entrySet()) {
            URL uRL2 = (URL)entry.getKey();
            List list = (List)entry.getValue();
            for (URL uRL3 : list) {
                ArrayList<URL> arrayList = (ArrayList<URL>)hashMap.get(uRL3);
                if (arrayList == null) {
                    arrayList = new ArrayList<URL>();
                    hashMap.put(uRL3, arrayList);
                }
                arrayList.add(uRL2);
            }
        }
        return JavaCustomIndexer.findDependent(uRL, map, hashMap, collection, bl);
    }

    public static Map<URL, Set<URL>> findDependent(URL uRL, Map<URL, List<URL>> map, Map<URL, List<URL>> map2, Collection<ElementHandle<TypeElement>> collection, boolean bl) throws IOException {
        Project project;
        ArrayList<URL> arrayList22;
        LinkedHashMap<URL, Set<URL>> linkedHashMap = new LinkedHashMap<URL, Set<URL>>();
        List list = collection.iterator();
        while (list.hasNext()) {
            if (!ANONYMOUS.matcher(list.next().getBinaryName()).find()) continue;
            list.remove();
        }
        if (collection.isEmpty() && !bl) {
            return linkedHashMap;
        }
        list = map2.get(uRL);
        try {
            switch (TasklistSettings.getDependencyTracking()) {
                case DISABLED: {
                    if (list == null) {
                        JavaIndex.setAttribute(uRL, DIRTY_ROOT, Boolean.TRUE.toString());
                    } else {
                        for (URL uRL2 : list) {
                            JavaIndex.setAttribute(uRL2, DIRTY_ROOT, Boolean.TRUE.toString());
                        }
                    }
                    return linkedHashMap;
                }
                case ENABLED_WITHIN_ROOT: {
                    if (list == null) {
                        list = Collections.singletonList(uRL);
                        break;
                    }
                    for (ArrayList<URL> arrayList22 : list) {
                        JavaIndex.setAttribute(arrayList22, DIRTY_ROOT, Boolean.TRUE.toString());
                    }
                    break;
                }
                case ENABLED_WITHIN_PROJECT: {
                    if (list == null) {
                        list = Collections.singletonList(uRL);
                        break;
                    }
                    project = FileOwnerQuery.getOwner((URI)uRL.toURI());
                    if (project == null) {
                        for (Object object : list) {
                            JavaIndex.setAttribute((URL)object, DIRTY_ROOT, Boolean.TRUE.toString());
                        }
                        list = Collections.singletonList(uRL);
                        break;
                    }
                    arrayList22 = new ArrayList<URL>(list.size());
                    for (URL uRL3 : list) {
                        if (FileOwnerQuery.getOwner((URI)uRL3.toURI()) == project) {
                            arrayList22.add(uRL3);
                            continue;
                        }
                        JavaIndex.setAttribute(uRL3, DIRTY_ROOT, Boolean.TRUE.toString());
                    }
                    arrayList22.add(uRL);
                    list = Utilities.topologicalSort(arrayList22, map2);
                    break;
                }
                case ENABLED: {
                    if (list == null) {
                        list = Collections.singletonList(uRL);
                        break;
                    }
                    project = new Project(list);
                    project.add((URL)uRL);
                    list = Utilities.topologicalSort(project, map2);
                }
            }
        }
        catch (TopologicalSortException topologicalSortException) {
            JavaIndex.LOG.warning("Cycle in the source root dependencies detected: " + topologicalSortException.unsortableSets());
            arrayList22 = topologicalSortException.partialSort();
            arrayList22.retainAll(list);
            list = arrayList22;
        }
        catch (URISyntaxException uRISyntaxException) {
            list = Collections.singletonList(uRL);
        }
        project = new LinkedList<ElementHandle<TypeElement>>(collection);
        arrayList22 = new HashMap();
        for (URL uRL3 : list) {
            List<URL> list2;
            Set<URL> set;
            List<URL> list3;
            if (ClassIndexManager.getDefault().createUsagesQuery(uRL3, true).isEmpty()) continue;
            ClassIndex classIndex = ClasspathInfo.create(EMPTY, EMPTY, ClassPathSupport.createClassPath((URL[])new URL[]{uRL3})).getClassIndex();
            List<URL> list4 = list3 = map != null ? map.get(uRL3) : null;
            if (list3 != null) {
                for (URL uRL2 : list3) {
                    set = (Set)arrayList22.get(uRL2);
                    if (set == null) continue;
                    project.addAll((Collection<URL>)set);
                }
            }
            HashSet hashSet = new HashSet();
            while (!project.isEmpty()) {
                ElementHandle elementHandle = (ElementHandle)project.poll();
                if (!hashSet.add(elementHandle)) continue;
                project.addAll(classIndex.getElements(elementHandle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
            }
            arrayList22.put(uRL3, hashSet);
            HashSet<FileObject> object2 = new HashSet<FileObject>();
            set = hashSet.iterator();
            while (set.hasNext()) {
                list2 = (ElementHandle)set.next();
                object2.addAll(classIndex.getResources((ElementHandle<TypeElement>)((Object)list2), EnumSet.complementOf(EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS)), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
            }
            set = new HashSet<URL>();
            list2 = object2.iterator();
            while (list2.hasNext()) {
                FileObject fileObject = (FileObject)list2.next();
                set.add(fileObject.getURL());
            }
            if (bl && !(list2 = TaskCache.getDefault().getAllFilesInError(uRL3)).isEmpty()) {
                set.addAll(list2);
            }
            if (set.isEmpty()) continue;
            linkedHashMap.put(uRL3, set);
        }
        return linkedHashMap;
    }

    public static final class CompileTuple {
        public final FileObjects.InferableJavaFileObject jfo;
        public final Indexable indexable;
        public final boolean virtual;
        public final boolean index;

        public CompileTuple(FileObjects.InferableJavaFileObject inferableJavaFileObject, Indexable indexable, boolean bl, boolean bl2) {
            this.jfo = inferableJavaFileObject;
            this.indexable = indexable;
            this.virtual = bl;
            this.index = bl2;
        }

        public CompileTuple(FileObjects.InferableJavaFileObject inferableJavaFileObject, Indexable indexable) {
            this(inferableJavaFileObject, indexable, false, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends CustomIndexerFactory {
        public boolean scanStarted(final Context context) {
            try {
                return ClassIndexManager.getDefault().prepareWriteLock(new ClassIndexManager.ExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws IOException, InterruptedException {
                        return ClassIndexManager.getDefault().takeWriteLock(new ClassIndexManager.ExceptionAction<Boolean>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Boolean run() throws IOException, InterruptedException {
                                ClassIndexImpl classIndexImpl = ClassIndexManager.getDefault().createUsagesQuery(context.getRootURI(), true);
                                if (classIndexImpl == null) {
                                    return true;
                                }
                                if (classIndexImpl.getState() != ClassIndexImpl.State.NEW) {
                                    return true;
                                }
                                try {
                                    Boolean bl = classIndexImpl.getSourceAnalyser().isValid();
                                    return bl;
                                }
                                finally {
                                    classIndexImpl.setState(ClassIndexImpl.State.INITIALIZED);
                                }
                            }
                        });
                    }
                });
            }
            catch (IOException iOException) {
                JavaIndex.LOG.log(Level.WARNING, "Exception while checking cache validity for root: " + context.getRootURI(), iOException);
                return false;
            }
            catch (InterruptedException interruptedException) {
                JavaIndex.LOG.log(Level.WARNING, "Exception while checking cache validity for root: " + context.getRootURI(), interruptedException);
                return false;
            }
        }

        public void scanFinished(Context context) {
        }

        public CustomIndexer createIndexer() {
            return new JavaCustomIndexer();
        }

        public void filesDeleted(Iterable<? extends Indexable> iterable, Context context) {
            JavaIndex.LOG.log(Level.FINE, "filesDeleted({0})", iterable);
            JavaCustomIndexer.clearFiles(context, iterable);
        }

        public void rootsRemoved(final Iterable<? extends URL> iterable) {
            assert (iterable != null);
            final ClassIndexManager classIndexManager = ClassIndexManager.getDefault();
            try {
                classIndexManager.prepareWriteLock(new ClassIndexManager.ExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException, InterruptedException {
                        for (URL uRL : iterable) {
                            classIndexManager.removeRoot(uRL);
                        }
                        return null;
                    }
                });
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
        }

        public void filesDirty(Iterable<? extends Indexable> iterable, Context context) {
            JavaIndex.LOG.log(Level.FINE, "filesDirty({0})", iterable);
            JavaCustomIndexer.markDirtyFiles(context, iterable);
        }

        public String getIndexerName() {
            return "java";
        }

        public boolean supportsEmbeddedIndexers() {
            return true;
        }

        public int getIndexVersion() {
            return 14;
        }
    }
}

