/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.classpath;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.impl.indexing.PathRegistry;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourcePathCheck
extends JavaParserResultTask {
    private final Factory factory;

    public SourcePathCheck(Factory factory) {
        super(JavaSource.Phase.PARSED);
        this.factory = factory;
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"})
    public void run(Parser.Result result, SchedulerEvent schedulerEvent) {
        CompilationInfo compilationInfo = CompilationInfo.get(result);
        ClasspathInfo classpathInfo = compilationInfo.getClasspathInfo();
        if (classpathInfo != null) {
            ClassPath classPath = ClasspathInfoAccessor.getINSTANCE().getCachedClassPath(classpathInfo, ClasspathInfo.PathKind.SOURCE);
            ClassPath classPath2 = classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
            try {
                HashSet<URL> hashSet = new HashSet<URL>();
                if (classPath.entries().isEmpty() && !classPath2.entries().isEmpty()) {
                    for (ClassPath.Entry entry : classPath2.entries()) {
                        URL uRL = entry.getURL();
                        if (this.factory.firedFor.contains(uRL) || !JavaIndex.isLibrary(uRL) || FileOwnerQuery.getOwner((URI)uRL.toURI()) == null) continue;
                        hashSet.add(uRL);
                        this.factory.firedFor.add(uRL);
                    }
                }
                if (!hashSet.isEmpty()) {
                    PathRegistry.getDefault().registerUnknownSourceRoots(classPath2, hashSet);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                Exceptions.printStackTrace((Throwable)uRISyntaxException);
            }
        }
    }

    public int getPriority() {
        return 1;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends TaskFactory {
        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"})
        private final Set<URL> firedFor = new HashSet<URL>();

        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singleton(new SourcePathCheck(this));
        }
    }
}

