/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.text.Position;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.EditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreePathHandle {
    private static Logger log = Logger.getLogger(TreePathHandle.class.getName());
    private final Delegate delegate;

    private TreePathHandle(Delegate delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegate;
    }

    @CheckForNull
    public FileObject getFileObject() {
        return this.delegate.getFileObject();
    }

    public TreePath resolve(CompilationInfo compilationInfo) throws IllegalArgumentException {
        TreePath treePath = this.delegate.resolve(compilationInfo);
        if (treePath == null) {
            Logger.getLogger(TreePathHandle.class.getName()).info("Cannot resolve: " + this.toString());
        }
        return treePath;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TreePathHandle)) {
            return false;
        }
        if (this.delegate.getClass() != ((TreePathHandle)object).delegate.getClass()) {
            return false;
        }
        return this.delegate.equalsHandle(((TreePathHandle)object).delegate);
    }

    public int hashCode() {
        return ((Object)this.delegate).hashCode();
    }

    public Element resolveElement(CompilationInfo compilationInfo) {
        Parameters.notNull((CharSequence)"info", (Object)compilationInfo);
        Element element = this.delegate.resolveElement(compilationInfo);
        if (element == null) {
            Logger.getLogger(TreePathHandle.class.getName()).info("Cannot resolve: " + this.toString());
        }
        return element;
    }

    public Tree.Kind getKind() {
        return this.delegate.getKind();
    }

    public static TreePathHandle create(TreePath treePath, CompilationInfo compilationInfo) throws IllegalArgumentException {
        Element element;
        FileObject fileObject;
        Parameters.notNull((CharSequence)"treePath", (Object)treePath);
        Parameters.notNull((CharSequence)"info", (Object)compilationInfo);
        try {
            URL uRL = treePath.getCompilationUnit().getSourceFile().toUri().toURL();
            fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject == null) {
                log.log(Level.INFO, "There is no fileobject for source: " + uRL + ". Was this file removed?");
                return new TreePathHandle(new EmptyDelegate(uRL, treePath.getLeaf().getKind()));
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw (RuntimeException)new RuntimeException().initCause(malformedURLException);
        }
        int n = ((JCTree)treePath.getLeaf()).pos;
        if (n == -1) {
            int n2 = TreePathHandle.listChildren(treePath.getParentPath().getLeaf()).indexOf(treePath.getLeaf());
            assert (n2 != -1);
            return new TreePathHandle(new CountingDelegate(TreePathHandle.create(treePath.getParentPath(), compilationInfo), n2, treePath.getLeaf().getKind()));
        }
        PositionRef positionRef = TreePathHandle.createPositionRef(fileObject, n, Position.Bias.Forward);
        TreePath treePath2 = treePath;
        boolean bl = true;
        do {
            element = compilationInfo.getTrees().getElement(treePath2);
            treePath2 = treePath2.getParentPath();
            if (element == null || TreePathHandle.isSupported(element)) continue;
            bl = false;
        } while ((element == null || !TreePathHandle.isSupported(element)) && treePath2 != null);
        return new TreePathHandle(new TreeDelegate(positionRef, new TreeDelegate.KindPath(treePath), fileObject, ElementHandle.create(element), bl));
    }

    public static TreePathHandle create(Element element, CompilationInfo compilationInfo) throws IllegalArgumentException {
        URL uRL = null;
        String string = null;
        Symbol.ClassSymbol classSymbol = element instanceof Symbol.ClassSymbol ? (Symbol.ClassSymbol)element : (Symbol.ClassSymbol)SourceUtils.getEnclosingTypeElement(element);
        if (classSymbol != null && (classSymbol.classfile != null || classSymbol.sourcefile != null)) {
            try {
                uRL = classSymbol.sourcefile != null && classSymbol.sourcefile.getKind() == JavaFileObject.Kind.SOURCE && classSymbol.sourcefile.toUri().isAbsolute() ? classSymbol.sourcefile.toUri().toURL() : classSymbol.classfile.toUri().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            string = ((Symbol)classSymbol.getEnclosingElement()).getQualifiedName().toString();
        }
        return new TreePathHandle(new ElementDelegate(ElementHandle.create(element), uRL, string, compilationInfo.getClasspathInfo()));
    }

    private static boolean isSupported(Element element) {
        switch (element.getKind()) {
            case PACKAGE: 
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case METHOD: 
            case CONSTRUCTOR: 
            case INSTANCE_INIT: 
            case STATIC_INIT: 
            case FIELD: 
            case ANNOTATION_TYPE: 
            case ENUM_CONSTANT: {
                return true;
            }
        }
        return false;
    }

    private static PositionRef createPositionRef(FileObject fileObject, int n, Position.Bias bias) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            Node.Cookie cookie = dataObject.getCookie(OpenCookie.class);
            if (cookie instanceof CloneableEditorSupport) {
                return ((CloneableEditorSupport)cookie).createPositionRef(n, bias);
            }
            cookie = dataObject.getCookie(EditorCookie.class);
            if (cookie instanceof CloneableEditorSupport) {
                return ((CloneableEditorSupport)cookie).createPositionRef(n, bias);
            }
            EditorSupport editorSupport = (EditorSupport)dataObject.getCookie(EditorSupport.class);
            if (editorSupport != null) {
                return editorSupport.createPositionRef(n, bias);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
        }
        throw new IllegalStateException("Cannot create PositionRef for file " + fileObject.getPath() + ". CloneableEditorSupport not found");
    }

    public String toString() {
        return "TreePathHandle[delegate:" + this.delegate + "]";
    }

    private static List<Tree> listChildren(@NonNull Tree tree) {
        final LinkedList<Tree> linkedList = new LinkedList<Tree>();
        tree.accept(new TreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree tree, Void void_) {
                linkedList.add(tree);
                return null;
            }
        }, null);
        return linkedList;
    }

    private static final class CountingDelegate
    implements Delegate {
        private final TreePathHandle parent;
        private final int index;
        private final Tree.Kind kind;

        public CountingDelegate(TreePathHandle treePathHandle, int n, Tree.Kind kind) {
            this.parent = treePathHandle;
            this.index = n;
            this.kind = kind;
        }

        public FileObject getFileObject() {
            return this.parent.getFileObject();
        }

        public TreePath resolve(CompilationInfo compilationInfo) throws IllegalArgumentException {
            Tree tree;
            TreePath treePath = this.parent.resolve(compilationInfo);
            if (treePath == null) {
                return null;
            }
            List list = TreePathHandle.listChildren(treePath.getLeaf());
            if (this.index < list.size() && (tree = (Tree)list.get(this.index)).getKind() == this.kind) {
                return new TreePath(treePath, tree);
            }
            return null;
        }

        public boolean equalsHandle(Delegate delegate) {
            return this == delegate;
        }

        public Element resolveElement(CompilationInfo compilationInfo) {
            return this.parent.resolveElement(compilationInfo);
        }

        public Tree.Kind getKind() {
            return this.kind;
        }
    }

    private static final class EmptyDelegate
    implements Delegate {
        private final URL source;
        private final Tree.Kind kind;

        public EmptyDelegate(URL uRL, Tree.Kind kind) {
            this.source = uRL;
            this.kind = kind;
        }

        public FileObject getFileObject() {
            return URLMapper.findFileObject((URL)this.source);
        }

        public TreePath resolve(CompilationInfo compilationInfo) throws IllegalArgumentException {
            return null;
        }

        public boolean equalsHandle(Delegate delegate) {
            return this == delegate;
        }

        public Element resolveElement(CompilationInfo compilationInfo) {
            return null;
        }

        public Tree.Kind getKind() {
            return this.kind;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ElementDelegate
    implements Delegate {
        private final ElementHandle<? extends Element> el;
        private final URL source;
        private final String qualName;
        private final ClasspathInfo cpInfo;

        public ElementDelegate(ElementHandle<? extends Element> elementHandle, URL uRL, String string, ClasspathInfo classpathInfo) {
            this.el = elementHandle;
            this.source = uRL;
            this.qualName = string;
            this.cpInfo = classpathInfo;
        }

        @Override
        public FileObject getFileObject() {
            FileObject fileObject = SourceUtils.getFile(this.el, this.cpInfo);
            if (fileObject == null && this.source != null) {
                FileObject fileObject2 = URLMapper.findFileObject((URL)this.source);
                if (fileObject2 == null) {
                    log.log(Level.INFO, "There is no fileobject for source: " + this.source + ". Was this file removed?");
                    return fileObject;
                }
                fileObject = fileObject2;
                if (fileObject2.getNameExt().endsWith("sig")) {
                    String string = FileObjects.convertPackage2Folder(this.qualName);
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                    for (int n = 0; fileObject2 != null && n <= stringTokenizer.countTokens(); fileObject2 = fileObject2.getParent(), ++n) {
                    }
                    if (fileObject2 != null) {
                        try {
                            URL uRL = fileObject2.getURL();
                            URL uRL2 = null;
                            if (uRL2 != null) {
                                FileObject fileObject3 = URLMapper.findFileObject(uRL2);
                                String string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)URLMapper.findFileObject((URL)this.source));
                                fileObject = fileObject3.getFileObject(string2.replace(".sig", ".class"));
                            } else {
                                Logger.getLogger(TreePathHandle.class.getName()).fine("Index.getSourceRootForClassFolder(url) returned null for url=" + uRL);
                            }
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                        }
                    }
                }
            }
            return fileObject;
        }

        @Override
        public TreePath resolve(CompilationInfo compilationInfo) throws IllegalArgumentException {
            Element element = this.resolveElement(compilationInfo);
            if (element == null) {
                return null;
            }
            return compilationInfo.getTrees().getPath(element);
        }

        @Override
        public Element resolveElement(CompilationInfo compilationInfo) {
            return this.el.resolve(compilationInfo);
        }

        @Override
        public Tree.Kind getKind() {
            switch (this.el.getKind()) {
                case PACKAGE: {
                    return Tree.Kind.COMPILATION_UNIT;
                }
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case ANNOTATION_TYPE: {
                    return Tree.Kind.CLASS;
                }
                case FIELD: 
                case ENUM_CONSTANT: 
                case PARAMETER: 
                case LOCAL_VARIABLE: 
                case EXCEPTION_PARAMETER: {
                    return Tree.Kind.VARIABLE;
                }
                case METHOD: 
                case CONSTRUCTOR: {
                    return Tree.Kind.METHOD;
                }
                case INSTANCE_INIT: 
                case STATIC_INIT: {
                    return Tree.Kind.BLOCK;
                }
                case TYPE_PARAMETER: {
                    return Tree.Kind.TYPE_PARAMETER;
                }
            }
            return Tree.Kind.OTHER;
        }

        @Override
        public boolean equalsHandle(Delegate delegate) {
            ElementDelegate elementDelegate = (ElementDelegate)delegate;
            return this.el.signatureEquals((Element)((Object)elementDelegate.el)) && this.cpInfo.equals(elementDelegate.cpInfo);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.el.getSignature());
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[elementHandle:" + this.el + ", url:" + this.source + "]";
        }
    }

    private static final class TreeDelegate
    implements Delegate {
        private final PositionRef position;
        private final KindPath kindPath;
        private final FileObject file;
        private final ElementHandle enclosingElement;
        private final boolean enclElIsCorrespondingEl;
        private final Tree.Kind kind;

        private TreeDelegate(PositionRef positionRef, KindPath kindPath, FileObject fileObject, ElementHandle elementHandle, boolean bl) {
            ElementKind elementKind;
            this.kindPath = kindPath;
            this.position = positionRef;
            this.file = fileObject;
            this.enclosingElement = elementHandle;
            this.enclElIsCorrespondingEl = bl;
            this.kind = kindPath != null ? (Tree.Kind)((Object)kindPath.kindPath.get(0)) : (bl ? ((elementKind = elementHandle.getKind()).isClass() || elementKind.isInterface() ? Tree.Kind.CLASS : (elementKind.isField() ? Tree.Kind.VARIABLE : (elementKind == ElementKind.METHOD || elementKind == ElementKind.CONSTRUCTOR ? Tree.Kind.METHOD : null))) : null);
        }

        public FileObject getFileObject() {
            return this.file;
        }

        public TreePath resolve(CompilationInfo compilationInfo) throws IllegalArgumentException {
            Object object;
            assert (compilationInfo != null);
            if (!compilationInfo.getFileObject().equals(this.getFileObject())) {
                StringBuilder stringBuilder = new StringBuilder();
                FileObject fileObject = this.getFileObject();
                FileObject fileObject2 = compilationInfo.getFileObject();
                stringBuilder.append("TreePathHandle [" + FileUtil.getFileDisplayName((FileObject)fileObject) + "] was not created from " + FileUtil.getFileDisplayName((FileObject)fileObject2));
                stringBuilder.append("\n");
                try {
                    stringBuilder.append("mine: id=" + System.identityHashCode(fileObject) + ", valid=" + fileObject.isValid() + ", url=");
                    stringBuilder.append(fileObject.getURL().toExternalForm());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    stringBuilder.append(fileStateInvalidException.getMessage());
                }
                stringBuilder.append("\n");
                try {
                    stringBuilder.append("remote: id=" + System.identityHashCode(fileObject2) + ", valid=" + fileObject2.isValid() + ", url=");
                    stringBuilder.append(fileObject2.getURL().toExternalForm());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    stringBuilder.append(fileStateInvalidException.getMessage());
                }
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            Object t = this.enclosingElement.resolve(compilationInfo);
            TreePath treePath = null;
            if (t != null) {
                object = compilationInfo.getTrees().getPath((Element)t);
                if (object == null) {
                    Logger.getLogger(TreePathHandle.class.getName()).fine("compilationInfo.getTrees().getPath(element) returned null for element %s " + t + "(" + this.file.getPath() + ")");
                } else {
                    treePath = compilationInfo.getTreeUtilities().pathFor((TreePath)object, this.position.getOffset() + 1);
                }
            }
            if (treePath != null && new KindPath(treePath).equals(this.kindPath)) {
                return treePath;
            }
            for (treePath = compilationInfo.getTreeUtilities().pathFor(this.position.getOffset() + 1); treePath != null; treePath = treePath.getParentPath()) {
                object = new KindPath(treePath);
                this.kindPath.getList().remove((Object)Tree.Kind.ERRONEOUS);
                if (!((KindPath)object).equals(this.kindPath)) continue;
                return treePath;
            }
            return null;
        }

        public boolean equalsHandle(Delegate delegate) {
            TreeDelegate treeDelegate = (TreeDelegate)delegate;
            try {
                if (this.position == null && treeDelegate.position == null) {
                    assert (this.enclElIsCorrespondingEl);
                    assert (treeDelegate.enclElIsCorrespondingEl);
                    return this.enclosingElement.equals(treeDelegate.enclosingElement);
                }
                if (this.position.getPosition().getOffset() != this.position.getPosition().getOffset()) {
                    return false;
                }
                if (!(this.file == treeDelegate.file || this.file != null && this.file.equals(treeDelegate.file))) {
                    return false;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.position == null) {
                return 553 + this.enclosingElement.hashCode();
            }
            int n = 7;
            n = 79 * n + this.position.getOffset();
            n = 79 * n + (this.file != null ? this.file.hashCode() : 0);
            return n;
        }

        public Element resolveElement(CompilationInfo compilationInfo) {
            TreePath treePath = null;
            IllegalStateException illegalStateException = null;
            try {
                if (this.file != null && compilationInfo.getFileObject() != null && compilationInfo.getFileObject().equals(this.file) && this.position != null) {
                    treePath = this.resolve(compilationInfo);
                }
            }
            catch (IllegalStateException illegalStateException2) {
                illegalStateException = illegalStateException2;
            }
            if (treePath == null) {
                if (this.enclElIsCorrespondingEl) {
                    Object t = this.enclosingElement.resolve(compilationInfo);
                    if (t == null) {
                        Logger.getLogger(TreePathHandle.class.getName()).severe("Cannot resolve" + this.enclosingElement + " in " + compilationInfo.getClasspathInfo());
                    }
                    return t;
                }
                if (illegalStateException == null) {
                    return null;
                }
                throw illegalStateException;
            }
            Element element = compilationInfo.getTrees().getElement(treePath);
            if (element == null) {
                Logger.getLogger(TreePathHandle.class.toString()).fine("info.getTrees().getElement(tp) returned null for " + treePath);
                if (this.enclElIsCorrespondingEl) {
                    Object t = this.enclosingElement.resolve(compilationInfo);
                    if (t == null) {
                        Logger.getLogger(TreePathHandle.class.getName()).fine("Cannot resolve" + this.enclosingElement + " in " + compilationInfo.getClasspathInfo());
                    }
                    return t;
                }
                return null;
            }
            return element;
        }

        public Tree.Kind getKind() {
            return this.kind;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[kind:" + (Object)((Object)this.kind) + ", enclosingElement:" + this.enclosingElement + ", file:" + this.file + "]";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class KindPath {
            private ArrayList<Tree.Kind> kindPath = new ArrayList();

            KindPath(TreePath treePath) {
                while (treePath != null) {
                    this.kindPath.add(treePath.getLeaf().getKind());
                    treePath = treePath.getParentPath();
                }
            }

            public int hashCode() {
                return this.kindPath.hashCode();
            }

            public boolean equals(Object object) {
                if (object instanceof KindPath) {
                    return this.kindPath.equals(((KindPath)object).kindPath);
                }
                return false;
            }

            public ArrayList<Tree.Kind> getList() {
                return this.kindPath;
            }
        }
    }

    static interface Delegate {
        public FileObject getFileObject();

        public TreePath resolve(CompilationInfo var1) throws IllegalArgumentException;

        public boolean equalsHandle(Delegate var1);

        public int hashCode();

        public Element resolveElement(CompilationInfo var1);

        public Tree.Kind getKind();
    }
}

