/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.openide.ErrorManager;

public class CustomClassLoader
extends URLClassLoader {
    private Map<String, File> package2File = new HashMap<String, File>();
    private Logger logger = Logger.getLogger(CustomClassLoader.class.getName());

    public CustomClassLoader(URL[] uRLArray, ClassLoader classLoader) {
        super(uRLArray, classLoader);
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Initializing Custom Classloader with classpath : ");
            for (URL uRL : uRLArray) {
                this.logger.info(uRL.toExternalForm());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (string == null) {
            throw new IllegalArgumentException("class name cannot be null");
        }
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        String string2 = null;
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        if (string2 != null && (string2.startsWith("java") || string2.startsWith("javax") || string2.startsWith("com.sun") || string2.startsWith("org.hibernate") || string2.startsWith("org.dom4j") || string2.startsWith("net.sf.cglib") || string2.startsWith("org.w3c") || string2.startsWith("antlr") || string2.startsWith("org.objectweb.asm") || string2.startsWith("org.apache.commons.collections") || string2.startsWith("net.sf.ehcache") || string2.startsWith("org.netbeans"))) {
            clazz = super.loadClass(string, bl);
        }
        if (clazz != null) {
            return clazz;
        }
        if (string2 != null && string2.startsWith("org.apache.log4j")) {
            throw new ClassNotFoundException("Log4J is forbidden");
        }
        int n2 = string.indexOf(".");
        String string3 = null;
        String string4 = File.separator;
        if (string4.equals("\\")) {
            string4 = "\\\\";
        }
        string3 = n2 != -1 ? string.replaceAll("\\.", string4) + ".class" : string + ".class";
        Class clazz2 = null;
        InputStream inputStream = this.getLocalResourceAsStream(string2, string3);
        if (inputStream != null) {
            try {
                clazz2 = this.loadClass(string, inputStream);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (clazz2 != null) {
            return clazz2;
        }
        return super.loadClass(string, bl);
    }

    private Class loadClass(String string, InputStream inputStream) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[5120];
            int n = 0;
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return this.defineClass(string, byArray2, 0, byArray2.length);
        }
        catch (ClassFormatError classFormatError) {
            ErrorManager.getDefault().notify(1, (Throwable)classFormatError);
            return null;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return null;
        }
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        permissions.setReadOnly();
        return permissions;
    }

    private URL getLocalResource(String string, String string2) {
        File file = null;
        if (string != null) {
            file = this.package2File.get(string);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file != null) {
            arrayList.add(file);
        }
        for (File file2 : arrayList) {
            Object object;
            if (file2.isDirectory() && file2.exists()) {
                object = new File(file2, string2);
                if (!((File)object).exists()) continue;
                try {
                    this.package2File.put(string, file2);
                    return ((File)object).toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    continue;
                }
            }
            if (!file2.isFile() || !file2.exists()) continue;
            try {
                object = new ZipFile(file2);
                ZipEntry zipEntry = ((ZipFile)object).getEntry(string2 = string2.replaceAll("\\\\", "/"));
                if (zipEntry == null) continue;
                String string3 = file2.getAbsolutePath().replaceAll("\\\\", "/");
                if (!string3.startsWith("/")) {
                    string3 = "/" + string3;
                }
                URL uRL = new URL("jar:file://" + string3 + "!/" + string2);
                this.package2File.put(string, file2);
                return uRL;
            }
            catch (ZipException zipException) {
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private InputStream getLocalResourceAsStream(String string, String string2) {
        URL uRL = this.getLocalResource(string, string2);
        if (uRL == null) {
            return null;
        }
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public InputStream getResourceAsStream(String string) {
        if (string != null && string.equals("hibernate.properties")) {
            return this.getHibernateProperties();
        }
        InputStream inputStream = this.getLocalResourceAsStream(null, string);
        return inputStream != null ? inputStream : super.getResourceAsStream(string);
    }

    private InputStream getHibernateProperties() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("hibernate.connection.provider_class=org.netbeans.modules.hibernate.util.CustomJDBCConnectionProvider".getBytes());
        return byteArrayInputStream;
    }
}

