/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RenameTransaction
implements Transaction {
    private final Set<FileObject> files;
    protected final String origName;
    protected final String newName;
    private final List<BackupFacility.Handle> handles = new ArrayList<BackupFacility.Handle>();
    private boolean committed;

    public RenameTransaction(Set<FileObject> set, String string, String string2) {
        this.files = set;
        this.origName = string;
        this.newName = string2;
    }

    public Set<FileObject> getToBeModifiedFiles() {
        return this.files;
    }

    public String getOriginalName() {
        return this.origName;
    }

    public String getNewName() {
        return this.newName;
    }

    public void commit() {
        if (this.committed) {
            this.restore();
        } else {
            try {
                this.handles.add(BackupFacility.getDefault().backup(this.files));
                this.doChanges();
                this.committed = true;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public void rollback() {
        this.restore();
    }

    private void restore() {
        for (BackupFacility.Handle handle : this.handles) {
            try {
                handle.restore();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public abstract void doChanges();
}

