/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;

public class Utils {
    public static void revert(Node[] nodeArray) {
        for (Node node : nodeArray) {
            StoreEntry storeEntry = (StoreEntry)node.getLookup().lookup(StoreEntry.class);
            if (storeEntry == null) continue;
            Utils.revert(storeEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revert(StoreEntry storeEntry) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            FileObject fileObject = FileUtil.toFileObject((File)storeEntry.getFile());
            if (storeEntry.getStoreFile() != null) {
                if (fileObject == null) {
                    fileObject = FileUtil.createData((File)storeEntry.getFile());
                }
                outputStream = Utils.getOutputStream(fileObject);
                inputStream = storeEntry.getStoreFileInputStream();
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            } else {
                fileObject.delete();
            }
        }
        catch (Exception exception) {
            LocalHistory.LOG.log(Level.SEVERE, null, exception);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static OutputStream getOutputStream(FileObject fileObject) throws FileAlreadyLockedException, IOException, InterruptedException {
        int n = 0;
        while (true) {
            try {
                return fileObject.getOutputStream();
            }
            catch (IOException iOException) {
                if (++n > 7) {
                    throw iOException;
                }
                Thread.sleep(n * 30);
                continue;
            }
            break;
        }
    }
}

