/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.flow;

import java.util.Collection;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.flow.FlowPresenter;
import org.netbeans.modules.vmd.api.flow.visual.FlowDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowScene;
import org.netbeans.modules.vmd.api.model.AccessController;
import org.netbeans.modules.vmd.api.model.AccessControllerFactory;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowAccessController
implements AccessController {
    private DesignDocument document;
    private FlowScene scene;
    private HashSet<FlowPresenter> dirtyPresenters = new HashSet();
    private volatile long eventID = 0L;

    public FlowAccessController(DesignDocument designDocument) {
        this.document = designDocument;
        this.scene = new FlowScene(designDocument);
    }

    public void writeAccess(Runnable runnable) {
        runnable.run();
    }

    public void notifyEventFiring(DesignEvent designEvent) {
    }

    public void notifyEventFired(DesignEvent designEvent) {
        if (this.eventID < designEvent.getEventID()) {
            this.eventID = designEvent.getEventID();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FlowAccessController.this.document.getTransactionManager().readAccess(new Runnable(){

                    public void run() {
                        FlowAccessController.this.scene.setCurrentEventIDForPreferredNodeLocationProcessing(FlowAccessController.this.eventID);
                        FlowAccessController.this.resolveDirty();
                        FlowAccessController.this.scene.setCurrentEventIDForPreferredNodeLocationProcessing(null);
                        if (!"flow".equals(FlowAccessController.this.document.getSelectionSourceID())) {
                            HashSet<? extends FlowDescriptor> hashSet = new HashSet<FlowDescriptor>();
                            for (DesignComponent designComponent : FlowAccessController.this.document.getSelectedComponents()) {
                                for (FlowPresenter flowPresenter : designComponent.getPresenters(FlowPresenter.class)) {
                                    hashSet.addAll(flowPresenter.getFlowDescriptors());
                                }
                            }
                            FlowAccessController.this.scene.setSelectedObjects(hashSet);
                        }
                        FlowAccessController.this.scene.validate();
                    }
                });
            }
        });
    }

    public void notifyComponentsCreated(Collection<DesignComponent> collection) {
    }

    public FlowScene getScene() {
        return this.scene;
    }

    public JComponent getCreateView() {
        JComponent jComponent = this.scene.getView();
        if (jComponent == null) {
            jComponent = this.scene.createView();
        }
        return jComponent;
    }

    public JComponent createSatelliteView() {
        return this.scene.createSatelliteView();
    }

    public void addDirtyPresenter(FlowPresenter flowPresenter) {
        this.dirtyPresenters.add(flowPresenter);
    }

    private void resolveDirty() {
        for (FlowPresenter flowPresenter : this.dirtyPresenters) {
            flowPresenter.updateDescriptors();
        }
        for (FlowPresenter flowPresenter : this.dirtyPresenters) {
            flowPresenter.resolveRemoveBadge();
        }
        for (FlowPresenter flowPresenter : this.dirtyPresenters) {
            flowPresenter.resolveRemoveEdge();
        }
        for (FlowPresenter flowPresenter : this.dirtyPresenters) {
            flowPresenter.resolveRemovePin();
        }
        for (FlowPresenter flowPresenter : this.dirtyPresenters) {
            flowPresenter.resolveRemoveNode();
        }
        for (FlowPresenter flowPresenter : this.dirtyPresenters) {
            flowPresenter.resolveAddNode();
        }
        for (FlowPresenter flowPresenter : this.dirtyPresenters) {
            flowPresenter.resolveAddPin();
        }
        for (FlowPresenter flowPresenter : this.dirtyPresenters) {
            flowPresenter.resolveAddEdge();
        }
        for (FlowPresenter flowPresenter : this.dirtyPresenters) {
            flowPresenter.resolveAddBadge();
        }
        for (FlowPresenter flowPresenter : this.dirtyPresenters) {
            flowPresenter.resolveUpdate();
        }
        this.dirtyPresenters.clear();
        this.scene.resolveOrderInNodeDescriptors();
    }

    public static class Factory
    implements AccessControllerFactory {
        public AccessController createAccessController(DesignDocument designDocument) {
            return new FlowAccessController(designDocument);
        }
    }
}

