/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.xref.impl;

import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;
import org.netbeans.modules.cnd.xref.impl.ObjectReferenceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceSupportImpl {
    public CsmReference createObjectReference(CsmOffsetable csmOffsetable) {
        return this.createObjectReference((CsmObject)csmOffsetable, csmOffsetable);
    }

    public CsmReference createObjectReference(CsmObject csmObject, CsmOffsetable csmOffsetable) {
        int n = this.getStartRefenceOffset(csmOffsetable);
        int n2 = this.getEndReferenceOffset(csmOffsetable);
        CsmUID<CsmObject> csmUID = csmObject != null ? this.getUID(csmObject) : null;
        CsmUID<CsmOffsetable> csmUID2 = this.getUID(csmOffsetable);
        CsmUID<CsmFile> csmUID3 = this.getUID(csmOffsetable.getContainingFile());
        CsmReferenceKind csmReferenceKind = this.getObjectKind(csmObject, (CsmObject)csmOffsetable);
        return new ObjectReferenceImpl(csmUID, csmUID2, csmUID3, csmReferenceKind, n, n2);
    }

    private CsmReferenceKind getObjectKind(CsmObject csmObject, CsmObject csmObject2) {
        CsmReferenceKind csmReferenceKind = CsmReferenceKind.UNKNOWN;
        if (csmObject == null && CsmKindUtilities.isInclude((CsmObject)csmObject2)) {
            csmReferenceKind = CsmReferenceKind.DIRECT_USAGE;
        } else if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            csmReferenceKind = CsmReferenceKind.DIRECT_USAGE;
        } else if (csmObject != null) {
            if (csmObject2 != null && !csmObject2.equals(csmObject)) {
                CsmObject[] csmObjectArray = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)csmObject, (boolean)true);
                CsmObject csmObject3 = csmObjectArray[0];
                CsmObject csmObject4 = csmObjectArray[1];
                csmReferenceKind = CsmReferenceKind.DIRECT_USAGE;
                if (csmObject2.equals(csmObject4)) {
                    csmReferenceKind = CsmReferenceKind.DEFINITION;
                } else if (this.sameDeclaration(csmObject2, csmObject3)) {
                    csmReferenceKind = CsmReferenceKind.DECLARATION;
                }
            } else {
                csmReferenceKind = CsmReferenceKind.DECLARATION;
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject) || CsmKindUtilities.isVariableDefinition((CsmObject)csmObject)) {
                    csmReferenceKind = CsmReferenceKind.DEFINITION;
                }
            }
        }
        return csmReferenceKind;
    }

    private int getStartRefenceOffset(CsmOffsetable csmOffsetable) {
        return csmOffsetable.getStartOffset();
    }

    private int getEndReferenceOffset(CsmOffsetable csmOffsetable) {
        int n = csmOffsetable.getEndOffset();
        if (CsmKindUtilities.isClass((CsmObject)csmOffsetable)) {
            n = ((CsmClass)csmOffsetable).getLeftBracketOffset();
        } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmOffsetable) && ((CsmFunctionDefinition)csmOffsetable).getBody() != null) {
            n = ((CsmFunctionDefinition)csmOffsetable).getBody().getStartOffset();
        }
        return n;
    }

    public <T extends CsmObject> CsmUID<T> getUID(T t) {
        return UIDs.get(t);
    }

    private boolean sameDeclaration(CsmObject csmObject, CsmObject csmObject2) {
        if (csmObject.equals(csmObject2)) {
            return true;
        }
        if (CsmKindUtilities.isQualified((CsmObject)csmObject) && CsmKindUtilities.isQualified((CsmObject)csmObject2)) {
            CharSequence charSequence;
            CharSequence charSequence2 = ((CsmQualifiedNamedElement)csmObject).getQualifiedName();
            if (charSequence2.equals(charSequence = ((CsmQualifiedNamedElement)csmObject2).getQualifiedName())) {
                return true;
            }
            String string = ((Object)charSequence2).toString().trim();
            if (string.endsWith("const")) {
                int n = string.lastIndexOf("const");
                assert (n >= 0);
                charSequence2 = CharSequenceKey.create((CharSequence)string.substring(n));
            }
            return charSequence2.equals(charSequence);
        }
        return false;
    }
}

