/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.web.wizards.FilterMappingData;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MappingTable
extends JTable {
    private boolean fontChanged = true;
    private int margin = 6;
    private static final long serialVersionUID = 3482048644419079279L;

    MappingTable(String string, List<FilterMappingData> list) {
        this.setModel(new MappingTableModel(string, list));
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(72);
        tableColumnModel.getColumn(1).setPreferredWidth(72);
        this.setSelectionMode(0);
        this.setIntercellSpacing(new Dimension(this.margin, this.margin));
    }

    List<FilterMappingData> getFilterMappings() {
        return ((MappingTableModel)this.getModel()).getFilterMappings();
    }

    void setFilterName(String string) {
        ((MappingTableModel)this.getModel()).setFilterName(string);
        this.invalidate();
    }

    void addRow(FilterMappingData filterMappingData) {
        this.invalidate();
        ((MappingTableModel)this.getModel()).addRow(filterMappingData);
    }

    void addRow(int n, FilterMappingData filterMappingData) {
        this.invalidate();
        ((MappingTableModel)this.getModel()).addRow(n, filterMappingData);
    }

    void setRow(int n, FilterMappingData filterMappingData) {
        this.invalidate();
        ((MappingTableModel)this.getModel()).setRow(n, filterMappingData);
    }

    FilterMappingData getRow(int n) {
        return ((MappingTableModel)this.getModel()).getRow(n);
    }

    void moveRowUp(int n) {
        ((MappingTableModel)this.getModel()).moveRowUp(n);
        this.getSelectionModel().setSelectionInterval(n - 1, n - 1);
        this.invalidate();
    }

    void moveRowDown(int n) {
        ((MappingTableModel)this.getModel()).moveRowUp(n + 1);
        this.getSelectionModel().setSelectionInterval(n + 1, n + 1);
        this.invalidate();
    }

    void removeRow(int n) {
        ((MappingTableModel)this.getModel()).removeRow(n);
        this.invalidate();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    private void setColors(boolean bl) {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        Color color = !bl ? this.getBackground().darker() : Color.white;
        this.setBackground(color);
    }

    void addTableModelListener(TableModelListener tableModelListener) {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            tableModel.addTableModelListener(tableModelListener);
        }
    }

    void removeTableModelListener(TableModelListener tableModelListener) {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            tableModel.removeTableModelListener(tableModelListener);
        }
    }

    @Override
    public void setFont(Font font) {
        this.fontChanged = true;
        super.setFont(font);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.fontChanged) {
            this.fontChanged = false;
            int n = 0;
            FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
            n = fontMetrics.getHeight() + this.margin;
            if (n > this.rowHeight) {
                this.rowHeight = n;
            }
            this.setRowHeight(this.rowHeight);
            return;
        }
        super.paint(graphics);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MappingTableModel
    extends AbstractTableModel {
        private final String[] colheaders = new String[]{NbBundle.getMessage(MappingTable.class, (String)"LBL_filter_name"), NbBundle.getMessage(MappingTable.class, (String)"LBL_applies_to")};
        private List<FilterMappingData> filterMappings = null;
        private String filterName;
        private static final long serialVersionUID = 2845252365404044474L;

        MappingTableModel(String string, List<FilterMappingData> list) {
            this.filterName = string;
            this.filterMappings = list;
        }

        List<FilterMappingData> getFilterMappings() {
            return this.filterMappings;
        }

        void setFilterName(String string) {
            for (FilterMappingData filterMappingData : this.filterMappings) {
                if (!filterMappingData.getName().equals(this.filterName)) continue;
                filterMappingData.setName(string);
            }
            this.filterName = string;
        }

        @Override
        public int getColumnCount() {
            return this.colheaders.length;
        }

        @Override
        public int getRowCount() {
            return this.filterMappings.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.colheaders[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            FilterMappingData filterMappingData = this.filterMappings.get(n);
            if (n2 == 0) {
                return filterMappingData.getName();
            }
            return filterMappingData.getPattern();
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }

        void addRow(int n, FilterMappingData filterMappingData) {
            this.filterMappings.add(n, filterMappingData);
        }

        void addRow(FilterMappingData filterMappingData) {
            this.filterMappings.add(filterMappingData);
        }

        FilterMappingData getRow(int n) {
            return this.filterMappings.get(n);
        }

        void setRow(int n, FilterMappingData filterMappingData) {
            this.filterMappings.set(n, filterMappingData);
        }

        void moveRowUp(int n) {
            FilterMappingData filterMappingData = this.filterMappings.remove(n);
            this.filterMappings.add(n - 1, filterMappingData);
        }

        void removeRow(int n) {
            this.filterMappings.remove(n);
        }
    }
}

