/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.server.manager.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.DialogDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public abstract class EditDialogDescriptor
extends DialogDescriptor
implements ChangeListener {
    public static final String STATUS_PREFIX = "Status:";

    public EditDialogDescriptor(JPanel jPanel, String string, boolean bl, JComponent[] jComponentArray, HelpCtx helpCtx) {
        this(new InnerPanel(jPanel), string, bl, jComponentArray, helpCtx);
    }

    private EditDialogDescriptor(InnerPanel innerPanel, String string, boolean bl, JComponent[] jComponentArray, HelpCtx helpCtx) {
        super((Object)innerPanel, EditDialogDescriptor.getTitle(bl, string), true, 2, DialogDescriptor.OK_OPTION, 0, helpCtx, null);
        if (jComponentArray != null) {
            DocListener docListener = new DocListener(this);
            for (JComponent jComponent : jComponentArray) {
                if (!(jComponent instanceof JTextField)) continue;
                ((JTextField)jComponent).getDocument().addDocumentListener(docListener);
            }
        }
        this.checkValues();
    }

    private static String getTitle(boolean bl, String string) {
        return bl ? NbBundle.getMessage(EditDialogDescriptor.class, (String)"TTL_Add", (Object)string) : NbBundle.getMessage(EditDialogDescriptor.class, (String)"TTL_Edit", (Object)string);
    }

    public final void checkValues() {
        String string = this.validate();
        if (string == null) {
            this.setValid(true);
        } else {
            this.setValid(false);
        }
        JLabel jLabel = ((InnerPanel)this.getMessage()).getErrorLabel();
        if (string != null) {
            if (string.startsWith(STATUS_PREFIX)) {
                string = string.substring(STATUS_PREFIX.length());
                jLabel.setForeground(Color.BLACK);
            } else {
                jLabel.setForeground(Color.RED);
            }
        }
        jLabel.setText(string == null ? " " : string);
    }

    protected abstract String validate();

    public void stateChanged(ChangeEvent changeEvent) {
        this.checkValues();
    }

    public JLabel getErrorLabel() {
        return ((InnerPanel)this.getMessage()).getErrorLabel();
    }

    public static interface Panel {
        public JComponent[] getEditableComponents();
    }

    public static class DocListener
    implements DocumentListener {
        EditDialogDescriptor dialog;

        public DocListener(EditDialogDescriptor editDialogDescriptor) {
            this.dialog = editDialogDescriptor;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.dialog.checkValues();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.dialog.checkValues();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.dialog.checkValues();
        }
    }

    private static class InnerPanel
    extends JPanel {
        JLabel errorLabel;

        InnerPanel(JPanel jPanel) {
            JSeparator jSeparator = new JSeparator();
            this.errorLabel = new JLabel(" ");
            this.errorLabel.setForeground(Color.RED);
            GroupLayout groupLayout = new GroupLayout((Container)this);
            this.setLayout((LayoutManager)groupLayout);
            groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)jSeparator, -1, 380, Short.MAX_VALUE).addContainerGap()).add((Component)jPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.errorLabel, -1, 380, Short.MAX_VALUE).addContainerGap()));
            groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)jPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)jSeparator, -2, 10, -2).addPreferredGap(0).add((Component)this.errorLabel, -2, 14, -2).addContainerGap()));
        }

        void setErrorMessage(String string) {
            this.errorLabel.setText(string);
        }

        JLabel getErrorLabel() {
            return this.errorLabel;
        }
    }
}

