/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.util;

import com.sun.appserv.management.client.AppserverConnectionSource;
import com.sun.appserv.management.client.TLSParams;
import com.sun.appserv.management.client.TrustAnyTrustManager;
import com.sun.appserv.management.config.ConfigDottedNames;
import java.io.IOException;
import javax.management.Attribute;
import javax.net.ssl.X509TrustManager;

public class AppserverConnectionFactory {
    private static final String JMX_CONNECTOR_PORT_DOTTED_NAME = "server.admin-service.jmx-connector.system.port";
    private static final String SECURITY_ENABLED_DOTTED_NAME = "server.admin-service.jmx-connector.system.security-enabled";

    private AppserverConnectionFactory() {
    }

    public static AppserverConnectionSource getAppserverConnection(String host, int port, String username, String password, boolean isSecure) throws IOException {
        return AppserverConnectionFactory.getAppserverConnection(host, port, username, password, AppserverConnectionFactory.getDefaultTLSParams(isSecure), false);
    }

    public static AppserverConnectionSource getAppserverConnection(String host, int port, String username, String password, boolean isSecure, boolean forceNew) throws IOException {
        return AppserverConnectionFactory.getAppserverConnection(host, port, username, password, AppserverConnectionFactory.getDefaultTLSParams(isSecure), forceNew);
    }

    public static AppserverConnectionSource getAppserverConnection(String host, int port, String username, String password, TLSParams tlsParams, boolean forceNew) throws IOException {
        return AppserverConnectionFactory.getRMIAppserverConnectionSource(host, port, username, password, tlsParams);
    }

    public static AppserverConnectionSource getHTTPAppserverConnection(String host, int port, String username, String password, boolean isSecure) throws IOException {
        return AppserverConnectionFactory.getHTTPAppserverConnectionSource(host, port, username, password, AppserverConnectionFactory.getDefaultTLSParams(isSecure));
    }

    static AppserverConnectionSource getRMIAppserverConnectionSource(String host, int port, String username, String password, TLSParams tlsParams) throws IOException {
        AppserverConnectionSource httpConn = AppserverConnectionFactory.getHTTPAppserverConnectionSource(host, port, username, password, tlsParams);
        return new AppserverConnectionSource("sun-as-rmi", host, AppserverConnectionFactory.getJMXConnectorPort(httpConn), username, password, tlsParams, null);
    }

    static AppserverConnectionSource getHTTPAppserverConnectionSource(String host, int port, String username, String password, TLSParams tlsParams) {
        return new AppserverConnectionSource("sun-as-http", host, port, username, password, tlsParams, null);
    }

    static ConfigDottedNames getConfigDottedNames(AppserverConnectionSource conn) throws IOException {
        ConfigDottedNames names = null;
        names = conn.getDomainRoot().getConfigDottedNames();
        return names;
    }

    static int getJMXConnectorPort(AppserverConnectionSource conn) throws IOException {
        Attribute attr = (Attribute)AppserverConnectionFactory.getAttributeFromConfigDottedNames(conn, JMX_CONNECTOR_PORT_DOTTED_NAME);
        return Integer.parseInt((String)attr.getValue());
    }

    static boolean isAppserverConnectionSecurityEnabled(AppserverConnectionSource conn) throws IOException {
        Attribute attr = (Attribute)AppserverConnectionFactory.getAttributeFromConfigDottedNames(conn, SECURITY_ENABLED_DOTTED_NAME);
        return Boolean.getBoolean((String)attr.getValue());
    }

    static Object getAttributeFromConfigDottedNames(AppserverConnectionSource conn, String dottedName) throws IOException {
        return AppserverConnectionFactory.getConfigDottedNames(conn).dottedNameGet(dottedName);
    }

    private static TLSParams getDefaultTLSParams(boolean isSecure) {
        return isSecure ? new TLSParams((X509TrustManager[])TrustAnyTrustManager.getInstanceArray(), null) : null;
    }
}

