/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.properties;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.modules.css.editor.properties.CssPropertyValueAcceptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class Acceptors {
    private static Acceptors INSTANCE;
    private Map<String, CssPropertyValueAcceptor> acceptors;

    public static synchronized Acceptors instance() {
        if (INSTANCE == null) {
            INSTANCE = new Acceptors("org/netbeans/modules/css/editor/properties/acceptors");
        }
        return INSTANCE;
    }

    private Acceptors(String string) {
        this.parseSource(string);
    }

    public CssPropertyValueAcceptor getAcceptor(String string) {
        return this.acceptors.get(string.toLowerCase());
    }

    private void parseSource(String string) {
        ResourceBundle resourceBundle = NbBundle.getBundle((String)string);
        this.acceptors = new HashMap<String, CssPropertyValueAcceptor>();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            try {
                String string2 = enumeration.nextElement();
                String string3 = resourceBundle.getString(string2);
                Class<?> clazz = Class.forName(string3);
                CssPropertyValueAcceptor cssPropertyValueAcceptor = (CssPropertyValueAcceptor)clazz.newInstance();
                this.acceptors.put(string2, cssPropertyValueAcceptor);
            }
            catch (InstantiationException instantiationException) {
                Exceptions.printStackTrace((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Exceptions.printStackTrace((Throwable)illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.printStackTrace((Throwable)classNotFoundException);
            }
        }
    }
}

