/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.cnd.api.utils.FileChooser;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.SourceFileFilter;
import org.netbeans.modules.cnd.makeproject.ui.wizards.FolderEntry;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFilesPanel
extends JPanel {
    private Vector<FolderEntry> data = new Vector();
    private SourceFileTable sourceFileTable = null;
    private String baseDir;
    private String wd;
    private ChangeListener listener;
    private JButton addButton;
    private JPanel buttonPanel;
    private JButton deleteButton;
    private JPanel ignoreFolderPanel;
    private JButton ignoreFoldersDefaultButton;
    private JLabel ignoreFoldersLabel;
    private JTextField ignoreFoldersTextField;
    private JList list;
    private JScrollPane scrollPane;
    private JLabel seeAlsoLabel;
    private JLabel sourceFilesLabel;

    public SourceFilesPanel(ChangeListener changeListener) {
        this.initComponents();
        this.scrollPane.getViewport().setBackground(Color.WHITE);
        this.getAccessibleContext().setAccessibleDescription(SourceFilesPanel.getString("SourceFilesPanelAD"));
        this.addButton.getAccessibleContext().setAccessibleDescription(SourceFilesPanel.getString("AddButtonAD"));
        this.deleteButton.getAccessibleContext().setAccessibleDescription(SourceFilesPanel.getString("DeleteButtonAD"));
        this.refresh();
        this.initFocus();
        this.listener = changeListener;
        this.ignoreFoldersTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SourceFilesPanel.this.update();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SourceFilesPanel.this.update();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                SourceFilesPanel.this.update();
            }
        });
    }

    private void update() {
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
    }

    public void setSeed(String string, String string2) {
        this.baseDir = string;
        this.wd = string2;
    }

    public void setFoldersFilter(String string) {
        this.ignoreFoldersTextField.setText(string);
    }

    public String getFoldersFilter() {
        return this.ignoreFoldersTextField.getText();
    }

    public void initFocus() {
        IpeUtils.requestFocus((Component)this.addButton);
    }

    public List<FolderEntry> getListData() {
        return this.data;
    }

    private void validateSelection() {
        this.addButton.setEnabled(true);
        if (this.data.size() == 0 || this.sourceFileTable.getSelectedRow() < 0) {
            this.deleteButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(true);
        }
    }

    private void refresh() {
        this.sourceFileTable = new SourceFileTable();
        this.scrollPane.setViewportView(this.sourceFileTable);
        this.sourceFilesLabel.setLabelFor(this.sourceFileTable);
        this.validateSelection();
    }

    private void initComponents() {
        this.sourceFilesLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.list = new JList();
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.ignoreFolderPanel = new JPanel();
        this.ignoreFoldersLabel = new JLabel();
        this.ignoreFoldersTextField = new JTextField();
        this.ignoreFoldersDefaultButton = new JButton();
        this.seeAlsoLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.sourceFilesLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("SourceFileFoldersMN").charAt(0));
        this.sourceFilesLabel.setLabelFor(this.list);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle");
        this.sourceFilesLabel.setText(resourceBundle.getString("SourceFileFoldersLbl"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.sourceFilesLabel, gridBagConstraints);
        this.scrollPane.setViewportView(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.addButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("AddButtonMN").charAt(0));
        this.addButton.setText(resourceBundle.getString("AddButtonTxt"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceFilesPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.buttonPanel.add((Component)this.addButton, gridBagConstraints);
        this.deleteButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("DeleteButtonMn").charAt(0));
        this.deleteButton.setText(resourceBundle.getString("DeleteButtonTxt"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceFilesPanel.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.buttonPanel.add((Component)this.deleteButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.buttonPanel, gridBagConstraints);
        this.ignoreFolderPanel.setLayout(new GridBagLayout());
        this.ignoreFoldersLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("SourceFilesPanel.ignoreFoldersLabel.mn").charAt(0));
        this.ignoreFoldersLabel.setLabelFor(this.ignoreFoldersTextField);
        this.ignoreFoldersLabel.setText(NbBundle.getMessage(SourceFilesPanel.class, (String)"SourceFilesPanel.ignoreFoldersLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.ignoreFolderPanel.add((Component)this.ignoreFoldersLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.ignoreFolderPanel.add((Component)this.ignoreFoldersTextField, gridBagConstraints);
        this.ignoreFoldersDefaultButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("SourceFilesPanel.ignoreFoldersDefaultButton.mn").charAt(0));
        this.ignoreFoldersDefaultButton.setText(NbBundle.getMessage(SourceFilesPanel.class, (String)"SourceFilesPanel.ignoreFoldersDefaultButton.text"));
        this.ignoreFoldersDefaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceFilesPanel.this.ignoreFoldersDefaultButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.ignoreFolderPanel.add((Component)this.ignoreFoldersDefaultButton, gridBagConstraints);
        this.seeAlsoLabel.setText(NbBundle.getMessage(SourceFilesPanel.class, (String)"SourceFilesPanel.seeAlsoLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.ignoreFolderPanel.add((Component)this.seeAlsoLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.ignoreFolderPanel, gridBagConstraints);
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.sourceFileTable.getSelectedRow();
        if (n < 0 || n >= this.data.size()) {
            return;
        }
        this.data.remove(n);
        this.refresh();
        if (this.data.size() > 0) {
            if (this.data.size() > n) {
                this.sourceFileTable.getSelectionModel().setSelectionInterval(n, n);
            } else {
                this.sourceFileTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            }
        }
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        FileChooser fileChooser;
        int n;
        String string = null;
        if (FileChooser.getCurrectChooserFile() != null) {
            string = FileChooser.getCurrectChooserFile().getPath();
        }
        if (string == null) {
            string = this.wd != null && this.wd.length() > 0 && !IpeUtils.isPathAbsolute((String)this.wd) ? this.baseDir + File.separator + this.wd : (this.wd != null ? this.wd : this.baseDir);
        }
        if ((n = (fileChooser = new FileChooser(SourceFilesPanel.getString("FOLDER_CHOOSER_TITLE_TXT"), SourceFilesPanel.getString("FOLDER_CHOOSER_BUTTON_TXT"), 1, null, string, true)).showOpenDialog((Component)this)) == 1) {
            return;
        }
        if (!fileChooser.getSelectedFile().exists() || !fileChooser.getSelectedFile().isDirectory()) {
            return;
        }
        this.data.add(new FolderEntry(fileChooser.getSelectedFile(), IpeUtils.toAbsoluteOrRelativePath((String)this.baseDir, (String)fileChooser.getSelectedFile().getPath())));
        this.refresh();
    }

    private void ignoreFoldersDefaultButtonActionPerformed(ActionEvent actionEvent) {
        this.ignoreFoldersTextField.setText("^(nbproject|build|test)$");
    }

    private static String getString(String string) {
        return NbBundle.getMessage(SourceFilesPanel.class, (String)string);
    }

    class MyTableModel
    extends DefaultTableModel {
        MyTableModel() {
        }

        public String getColumnName(int n) {
            return " " + SourceFilesPanel.getString("TABLE_COLUMN_1_TXT");
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return SourceFilesPanel.this.data.size();
        }

        public Object getValueAt(int n, int n2) {
            return ((FolderEntry)SourceFilesPanel.this.data.elementAt(n)).getFolderName();
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    class SourceFileTable
    extends JTable {
        public SourceFileTable() {
            this.setModel(new MyTableModel());
            ((DefaultTableCellRenderer)this.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
            this.getSelectionModel().setSelectionMode(0);
            this.getSelectionModel().addListSelectionListener(new TargetSelectionListener());
            this.getAccessibleContext().setAccessibleDescription(SourceFilesPanel.getString("SourceFileTableAD"));
        }

        public boolean getShowHorizontalLines() {
            return false;
        }

        public boolean getShowVerticalLines() {
            return false;
        }
    }

    private class TargetSelectionListener
    implements ListSelectionListener {
        private TargetSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            SourceFilesPanel.this.validateSelection();
        }
    }

    private static class CustomFileFilter
    extends SourceFileFilter {
        String[] suffixes;

        CustomFileFilter(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.charAt(0) == '.') {
                    string2 = string2.substring(1);
                }
                vector.add(string2);
            }
            this.suffixes = vector.toArray(new String[vector.size()]);
        }

        public String getDescription() {
            return "";
        }

        public String[] getSuffixes() {
            return this.suffixes;
        }
    }
}

