/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.StringTokenizer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;

public final class ConfigurationSupport {
    private ConfigurationSupport() {
    }

    public static String appendConfName(String string, Configuration configuration) {
        return string + "," + configuration.getDisplayName();
    }

    public static String removeConfName(String string, Configuration configuration) {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = string2;
            if (string3.equals(configuration.getDisplayName())) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    public static String renameConfName(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n < 0) {
            // empty if block
        }
        String string4 = string.substring(0, n) + string3 + string.substring(n + string2.length());
        return string4;
    }

    public static String makeNameLegal(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (i == 0 && (ConfigurationSupport.isLetterOrDigit(string.charAt(i)) || string.charAt(i) == '_')) {
                stringBuilder.append(string.charAt(i));
                continue;
            }
            if (i != 0 && (ConfigurationSupport.isLetterOrDigit(string.charAt(i)) || string.charAt(i) == '_' || string.charAt(i) == '-' || string.charAt(i) == '.')) {
                stringBuilder.append(string.charAt(i));
                continue;
            }
            stringBuilder.append("_");
        }
        if (stringBuilder.length() == 0) {
            return "Configuration";
        }
        return stringBuilder.toString();
    }

    private static boolean isLetterOrDigit(char c) {
        if (c < '0' || c > 'z') {
            return false;
        }
        return Character.isLetterOrDigit(c);
    }

    public static String getNameFromDisplayName(String string) {
        return string;
    }

    public static String getUniqueName(Configuration[] configurationArray, String string) {
        String string2;
        int n = 1;
        while (!ConfigurationSupport.isNameUnique(configurationArray, string2 = n == 1 ? string : string + "-" + n)) {
            ++n;
        }
        return string2;
    }

    public static String getUniqueNewName(Configuration[] configurationArray) {
        return ConfigurationSupport.getUniqueName(configurationArray, "NewConfiguration");
    }

    public static String getUniqueCopyName(Configuration[] configurationArray, Configuration configuration) {
        String string;
        int n = 1;
        String string2 = "Copy";
        while (!ConfigurationSupport.isNameUnique(configurationArray, string = n == 1 ? string2 + "_of_" + configuration.getName() : string2 + "-" + n + "_of_" + configuration.getName())) {
            ++n;
        }
        return string;
    }

    public static boolean isNameUnique(Configuration[] configurationArray, String string) {
        boolean bl = true;
        String string2 = ConfigurationSupport.getNameFromDisplayName(string);
        for (int i = 0; i < configurationArray.length; ++i) {
            if (!configurationArray[i].getName().equals(string2)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static String getConfsPropertyValue(Configuration[] configurationArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < configurationArray.length; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(configurationArray[i].getDisplayName());
        }
        return stringBuilder.toString();
    }

    public static String getDefaultConfPropertyValue(Configuration configuration) {
        return configuration.getDisplayName();
    }

    public static MakeConfiguration getProjectActiveConfiguration(Project project) {
        MakeConfigurationDescriptor makeConfigurationDescriptor;
        ConfigurationDescriptorProvider configurationDescriptorProvider;
        if (project != null && (configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class)) != null && (makeConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor()) != null) {
            return makeConfigurationDescriptor.getActiveConfiguration();
        }
        return null;
    }
}

