/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.compilers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.netbeans.modules.cnd.api.execution.LinkSupport;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.makeproject.api.compilers.PersistentList;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CCCCompiler
extends BasicCompiler {
    private static final String DEV_NULL = "/dev/null";
    private volatile Pair compilerDefinitions;
    private static File emptyFile = null;

    protected CCCCompiler(ExecutionEnvironment executionEnvironment, CompilerSet.CompilerFlavor compilerFlavor, int n, String string, String string2, String string3) {
        super(executionEnvironment, compilerFlavor, n, string, string2, string3);
    }

    @Override
    public boolean setSystemIncludeDirectories(List<String> list) {
        assert (list != null);
        if (this.compilerDefinitions == null) {
            this.compilerDefinitions = new Pair();
        }
        if (((Object)list).equals(this.compilerDefinitions.systemIncludeDirectoriesList)) {
            return false;
        }
        PersistentList<String> persistentList = new PersistentList<String>(list);
        this.normalizePaths(persistentList);
        this.compilerDefinitions.systemIncludeDirectoriesList = persistentList;
        this.saveSystemIncludesAndDefines();
        return true;
    }

    @Override
    public boolean setSystemPreprocessorSymbols(List<String> list) {
        assert (list != null);
        if (this.compilerDefinitions == null) {
            this.compilerDefinitions = new Pair();
        }
        if (((Object)list).equals(this.compilerDefinitions.systemPreprocessorSymbolsList)) {
            return false;
        }
        this.compilerDefinitions.systemPreprocessorSymbolsList = new PersistentList<String>(list);
        this.saveSystemIncludesAndDefines();
        return true;
    }

    @Override
    public List<String> getSystemPreprocessorSymbols() {
        if (this.compilerDefinitions != null) {
            return this.compilerDefinitions.systemPreprocessorSymbolsList;
        }
        this.getSystemIncludesAndDefines();
        return this.compilerDefinitions.systemPreprocessorSymbolsList;
    }

    @Override
    public List<String> getSystemIncludeDirectories() {
        if (this.compilerDefinitions != null) {
            return this.compilerDefinitions.systemIncludeDirectoriesList;
        }
        this.getSystemIncludesAndDefines();
        return this.compilerDefinitions.systemIncludeDirectoriesList;
    }

    public void saveSystemIncludesAndDefines() {
        if (this.compilerDefinitions != null) {
            this.compilerDefinitions.systemIncludeDirectoriesList.saveList(this.getUniqueID() + "systemIncludeDirectoriesList");
            this.compilerDefinitions.systemPreprocessorSymbolsList.saveList(this.getUniqueID() + "systemPreprocessorSymbolsList");
        }
    }

    private void restoreSystemIncludesAndDefines() {
        PersistentList<String> persistentList = PersistentList.restoreList(this.getUniqueID() + "systemIncludeDirectoriesList");
        PersistentList<String> persistentList2 = PersistentList.restoreList(this.getUniqueID() + "systemPreprocessorSymbolsList");
        if (persistentList != null && persistentList2 != null) {
            this.compilerDefinitions = new Pair(persistentList, persistentList2);
        }
    }

    public boolean isReady() {
        return this.compilerDefinitions != null;
    }

    public void waitReady(boolean bl) {
        if (bl) {
            this.resetSystemIncludesAndDefines();
        } else {
            this.getSystemIncludesAndDefines();
        }
    }

    private synchronized void getSystemIncludesAndDefines() {
        if (this.compilerDefinitions == null) {
            this.restoreSystemIncludesAndDefines();
            if (this.compilerDefinitions == null) {
                CndUtils.assertNonUiThread();
                this.compilerDefinitions = this.getFreshSystemIncludesAndDefines();
                this.saveSystemIncludesAndDefines();
            }
        }
    }

    public void resetSystemIncludesAndDefines() {
        CndUtils.assertNonUiThread();
        this.compilerDefinitions = this.getFreshSystemIncludesAndDefines();
        this.saveSystemIncludesAndDefines();
    }

    public String getMTLevelOptions(int n) {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getDescriptor();
        if (compilerDescriptor != null && compilerDescriptor.getMultithreadingFlags() != null && compilerDescriptor.getMultithreadingFlags().length > n) {
            return compilerDescriptor.getMultithreadingFlags()[n];
        }
        return "";
    }

    public String getLibraryLevelOptions(int n) {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getDescriptor();
        if (compilerDescriptor != null && compilerDescriptor.getLibraryFlags() != null && compilerDescriptor.getLibraryFlags().length > n) {
            return compilerDescriptor.getLibraryFlags()[n];
        }
        return "";
    }

    public String getStandardsEvolutionOptions(int n) {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getDescriptor();
        if (compilerDescriptor != null && compilerDescriptor.getStandardFlags() != null && compilerDescriptor.getStandardFlags().length > n) {
            return compilerDescriptor.getStandardFlags()[n];
        }
        return "";
    }

    public String getLanguageExtOptions(int n) {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getDescriptor();
        if (compilerDescriptor != null && compilerDescriptor.getLanguageExtensionFlags() != null && compilerDescriptor.getLanguageExtensionFlags().length > n) {
            return compilerDescriptor.getLanguageExtensionFlags()[n];
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void getSystemIncludesAndDefines(String string, boolean bl, Pair pair) throws IOException {
        String string2 = this.getPath();
        if (string2 == null || string2.length() == 0) {
            return;
        }
        ExecutionEnvironment executionEnvironment = this.getExecutionEnvironment();
        if (executionEnvironment.isLocal() && Utilities.isWindows()) {
            string2 = LinkSupport.resolveWindowsLink((String)string2);
        }
        if (!HostInfoUtils.fileExists((ExecutionEnvironment)executionEnvironment, (String)string2)) {
            string2 = this.getDefaultPath();
        }
        if (!HostInfoUtils.fileExists((ExecutionEnvironment)executionEnvironment, (String)string2)) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(string.trim().split(" +")));
        arrayList.add(this.getEmptyFile(executionEnvironment));
        PlatformInfo platformInfo = PlatformInfo.getDefault((ExecutionEnvironment)executionEnvironment);
        NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)executionEnvironment);
        nativeProcessBuilder.setExecutable(string2);
        nativeProcessBuilder.setArguments(arrayList.toArray(new String[arrayList.size()]));
        nativeProcessBuilder.getEnvironment().prependPathVariable(platformInfo.getPathName(), IpeUtils.getDirName((String)string2));
        try {
            NativeProcess nativeProcess = nativeProcessBuilder.call();
            InputStream inputStream = bl ? nativeProcess.getInputStream() : nativeProcess.getErrorStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                this.parseCompilerOutput(bufferedReader, pair);
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    protected abstract void parseCompilerOutput(BufferedReader var1, Pair var2);

    protected abstract Pair getFreshSystemIncludesAndDefines();

    protected String getDefaultPath() {
        ToolchainManager.CompilerDescriptor compilerDescriptor = this.getDescriptor();
        if (compilerDescriptor != null && compilerDescriptor.getNames().length > 0) {
            return compilerDescriptor.getNames()[0];
        }
        return "";
    }

    protected boolean containsMacro(List<String> list, String string) {
        int n = string.length();
        for (String string2 : list) {
            if (!string2.startsWith(string)) continue;
            if (string2.length() == n) {
                return true;
            }
            if (string2.charAt(n) != '=') continue;
            return true;
        }
        return false;
    }

    protected void parseUserMacros(String string, PersistentList<String> persistentList) {
        int n = string.indexOf("-D");
        while (n >= 0) {
            String string2;
            int n2 = string.indexOf(" ", n + 1);
            if (n2 > 0) {
                string2 = string.substring(n + 2, n2);
                if (n > 0 && string.charAt(n - 1) == '\"' && string2.length() > 0 && string2.charAt(string2.length() - 1) == '\"') {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                persistentList.addUnique(string2);
                n = string.indexOf("-D", n2);
                continue;
            }
            string2 = string.substring(n + 2);
            if (n > 0 && string.charAt(n - 1) == '\"' && string2.length() > 0 && string2.charAt(string2.length() - 1) == '\"') {
                string2 = string2.substring(0, string2.length() - 1);
            }
            persistentList.addUnique(string2);
            break;
        }
    }

    private String getEmptyFile(ExecutionEnvironment executionEnvironment) {
        if (executionEnvironment.isLocal() && Utilities.isWindows()) {
            if (emptyFile == null) {
                try {
                    File file = File.createTempFile("xyz", ".c");
                    file.deleteOnExit();
                    emptyFile = file;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return emptyFile == null ? DEV_NULL : emptyFile.getAbsolutePath();
        }
        return DEV_NULL;
    }

    protected String getUniqueID() {
        if (this.getCompilerSet() == null || this.getCompilerSet().isAutoGenerated()) {
            return ((Object)((Object)this)).getClass().getName() + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.getExecutionEnvironment()).hashCode() + this.getPath().hashCode() + ".";
        }
        return ((Object)((Object)this)).getClass().getName() + this.getCompilerSet().getName() + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.getExecutionEnvironment()).hashCode() + this.getPath().hashCode() + ".";
    }

    private void dumpLists() {
        int n;
        System.out.println("==================================" + this.getDisplayName());
        for (n = 0; n < this.compilerDefinitions.systemIncludeDirectoriesList.size(); ++n) {
            System.out.println("-I" + (String)this.compilerDefinitions.systemIncludeDirectoriesList.get(n));
        }
        for (n = 0; n < this.compilerDefinitions.systemPreprocessorSymbolsList.size(); ++n) {
            System.out.println("-D" + (String)this.compilerDefinitions.systemPreprocessorSymbolsList.get(n));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class Pair {
        public PersistentList<String> systemIncludeDirectoriesList;
        public PersistentList<String> systemPreprocessorSymbolsList;

        public Pair() {
            this.systemIncludeDirectoriesList = new PersistentList();
            this.systemPreprocessorSymbolsList = new PersistentList();
        }

        public Pair(PersistentList<String> persistentList, PersistentList<String> persistentList2) {
            this.systemIncludeDirectoriesList = persistentList;
            this.systemPreprocessorSymbolsList = persistentList2;
        }
    }
}

