/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.lang.ref.WeakReference;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.swing.text.Document;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.database.DatabaseContext;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.features.DatabaseManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextASTEvaluator
extends ASTEvaluator {
    private static Map<Document, WeakReference<ContextASTEvaluator>> cache = new WeakHashMap<Document, WeakReference<ContextASTEvaluator>>();
    private Document document;
    private DatabaseContext rootContext;
    private Stack<DatabaseContext> currentContext;
    private boolean evaluated;

    static void register(Document document) {
        if (ContextASTEvaluator.get(document) != null) {
            return;
        }
        cache.put(document, new WeakReference<ContextASTEvaluator>(new ContextASTEvaluator(document)));
    }

    static void unregister(Document document) {
        ContextASTEvaluator contextASTEvaluator = ContextASTEvaluator.get(document);
        if (contextASTEvaluator != null) {
            ParserManager.get(document).removeASTEvaluator(contextASTEvaluator);
        }
        cache.remove(document);
    }

    static ContextASTEvaluator get(Document document) {
        WeakReference<ContextASTEvaluator> weakReference = cache.get(document);
        if (weakReference == null) {
            return null;
        }
        return (ContextASTEvaluator)weakReference.get();
    }

    static DatabaseContext getRootContext(Document document) {
        ContextASTEvaluator contextASTEvaluator = ContextASTEvaluator.get(document);
        if (contextASTEvaluator == null) {
            return null;
        }
        return contextASTEvaluator.rootContext;
    }

    static DatabaseContext getCurrentContext(Document document, int n) {
        ContextASTEvaluator contextASTEvaluator = ContextASTEvaluator.get(document);
        try {
            if (contextASTEvaluator == null) {
                return null;
            }
            DatabaseContext databaseContext = contextASTEvaluator.currentContext.peek();
            while (n < databaseContext.getOffset() || databaseContext.getEndOffset() <= n) {
                contextASTEvaluator.currentContext.pop();
                databaseContext = contextASTEvaluator.currentContext.peek();
            }
            return databaseContext;
        }
        catch (EmptyStackException emptyStackException) {
            return contextASTEvaluator.rootContext;
        }
    }

    static void setEvaluated(Document document, boolean bl) {
        ContextASTEvaluator contextASTEvaluator = ContextASTEvaluator.get(document);
        if (contextASTEvaluator == null) {
            return;
        }
        contextASTEvaluator.evaluated = bl;
    }

    ContextASTEvaluator(Document document) {
        this.document = document;
        ParserManager.get(document).addASTEvaluator(this);
    }

    @Override
    public void beforeEvaluation(ParserManager.State state, ASTNode aSTNode) {
        this.rootContext = new DatabaseContext(null, null, aSTNode.getOffset(), aSTNode.getEndOffset());
        this.currentContext = new Stack();
        this.currentContext.push(this.rootContext);
        this.evaluated = false;
    }

    @Override
    public void afterEvaluation(ParserManager.State state, ASTNode aSTNode) {
        if (this.evaluated) {
            DatabaseManager.setRoot(aSTNode, this.rootContext);
        }
    }

    @Override
    public void evaluate(ParserManager.State state, List<ASTItem> list, Feature feature) {
        SyntaxContext syntaxContext = SyntaxContext.create(this.document, ASTPath.create(list));
        if (!feature.getBoolean("condition", syntaxContext, true)) {
            return;
        }
        String string = (String)feature.getValue("type");
        ASTItem aSTItem = list.get(list.size() - 1);
        DatabaseContext databaseContext = ContextASTEvaluator.getCurrentContext(this.document, aSTItem.getOffset());
        DatabaseContext databaseContext2 = new DatabaseContext(databaseContext, string, aSTItem.getOffset(), aSTItem.getEndOffset());
        databaseContext.addContext(aSTItem, databaseContext2);
        this.currentContext.push(databaseContext2);
        this.evaluated = true;
    }

    @Override
    public String getFeatureName() {
        return "SEMANTIC_CONTEXT";
    }
}

