/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.ParserManagerListener;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.lexer.SLanguageHierarchy;
import org.netbeans.modules.languages.lexer.SLexer;
import org.netbeans.modules.languages.parser.LLSyntaxAnalyser;
import org.netbeans.modules.languages.parser.SyntaxError;
import org.netbeans.modules.languages.parser.TokenInputUtils;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserManagerImpl
extends ParserManager {
    private Document document;
    private TokenHierarchy tokenHierarchy;
    private ASTNode ast = ASTNode.create(null, "Root", 0);
    private ParserManager.State state = ParserManager.State.NOT_PARSED;
    private List<SyntaxError> syntaxErrors = Collections.emptyList();
    private boolean[] cancel = new boolean[]{false};
    private Set<ParserManagerListener> listeners;
    private Map<String, Set<ASTEvaluator>> evaluatorsMap;
    private static RequestProcessor rp = new RequestProcessor("Parser");
    private RequestProcessor.Task parsingTask;
    private static Map<Document, WeakReference<ParserManager>> managers = new WeakHashMap<Document, WeakReference<ParserManager>>();

    public ParserManagerImpl(Document document) {
        this.document = document;
        this.tokenHierarchy = TokenHierarchy.get((Document)document);
        String string = (String)document.getProperty("mimeType");
        if (this.tokenHierarchy == null && string != null) {
            try {
                Language language = LanguagesManager.getDefault().getLanguage(string);
                if (language.getParser() != null) {
                    document.putProperty(org.netbeans.api.lexer.Language.class, new SLanguageHierarchy(language).language());
                    this.tokenHierarchy = TokenHierarchy.get((Document)document);
                }
            }
            catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
                // empty catch block
            }
        }
        if (this.tokenHierarchy != null) {
            new DocListener(this, this.tokenHierarchy);
            if (string != null && this.state == ParserManager.State.NOT_PARSED) {
                try {
                    LanguagesManager.getDefault().getLanguage(string);
                    this.startParsing();
                }
                catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
                    // empty catch block
                }
            }
        }
        managers.put(document, new WeakReference<ParserManagerImpl>(this));
    }

    public static ParserManagerImpl getImpl(Document document) {
        return (ParserManagerImpl)ParserManagerImpl.get(document);
    }

    @Override
    public ParserManager.State getState() {
        return this.state;
    }

    public List<SyntaxError> getSyntaxErrors() {
        return this.syntaxErrors;
    }

    @Override
    public boolean hasSyntaxErrors() {
        return !this.getSyntaxErrors().isEmpty();
    }

    @Override
    public ASTNode getAST() {
        return this.ast;
    }

    @Override
    public void addListener(ParserManagerListener parserManagerListener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<ParserManagerListener>();
        }
        this.listeners.add(parserManagerListener);
    }

    @Override
    public void removeListener(ParserManagerListener parserManagerListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(parserManagerListener);
    }

    @Override
    public void addASTEvaluator(ASTEvaluator aSTEvaluator) {
        Set<ASTEvaluator> set;
        if (this.evaluatorsMap == null) {
            this.evaluatorsMap = new HashMap<String, Set<ASTEvaluator>>();
        }
        if ((set = this.evaluatorsMap.get(aSTEvaluator.getFeatureName())) == null) {
            set = new HashSet<ASTEvaluator>();
            this.evaluatorsMap.put(aSTEvaluator.getFeatureName(), set);
        }
        set.add(aSTEvaluator);
    }

    @Override
    public void removeASTEvaluator(ASTEvaluator aSTEvaluator) {
        Set<ASTEvaluator> set;
        if (this.evaluatorsMap != null && (set = this.evaluatorsMap.get(aSTEvaluator.getFeatureName())) != null) {
            set.remove(aSTEvaluator);
        }
    }

    public void fire(final ParserManager.State state, final List<ParserManagerListener> list, final Map<String, Set<ASTEvaluator>> map, final ASTNode aSTNode) {
        if (aSTNode == null) {
            throw new NullPointerException();
        }
        this.parsingTask = rp.post(new Runnable(){

            public void run() {
                ((ParserManagerImpl)ParserManagerImpl.this).cancel[0] = false;
                ParserManagerImpl.this.fire2(state, list, map, aSTNode);
            }
        });
    }

    private synchronized void startParsing() {
        this.setChange(ParserManager.State.PARSING, this.ast);
        this.cancel[0] = true;
        if (this.parsingTask != null) {
            this.parsingTask.cancel();
        }
        this.parsingTask = rp.post(new Runnable(){

            public void run() {
                ((ParserManagerImpl)ParserManagerImpl.this).cancel[0] = false;
                ParserManagerImpl.this.parse();
            }
        }, 1000);
    }

    private void setChange(ParserManager.State state, ASTNode aSTNode) {
        if (state == this.state) {
            return;
        }
        this.state = state;
        this.ast = aSTNode;
        ArrayList<ParserManagerListener> arrayList = this.listeners == null ? null : new ArrayList<ParserManagerListener>(this.listeners);
        HashMap<String, Set<ASTEvaluator>> hashMap = this.evaluatorsMap == null ? null : new HashMap<String, Set<ASTEvaluator>>(this.evaluatorsMap);
        this.fire2(state, arrayList, hashMap, aSTNode);
    }

    private void fire2(ParserManager.State state, List<ParserManagerListener> list, Map<String, Set<ASTEvaluator>> map, ASTNode aSTNode) {
        if (state == ParserManager.State.PARSING) {
            return;
        }
        if (map != null && !map.isEmpty()) {
            Iterator<Object> iterator = map.values().iterator();
            while (iterator.hasNext()) {
                for (ASTEvaluator aSTEvaluator : (Set)iterator.next()) {
                    aSTEvaluator.beforeEvaluation(state, aSTNode);
                    if (!this.cancel[0]) continue;
                    return;
                }
            }
            this.evaluate(state, aSTNode, new ArrayList<ASTItem>(), map);
            if (this.cancel[0]) {
                return;
            }
            iterator = map.values().iterator();
            while (iterator.hasNext()) {
                for (ASTEvaluator aSTEvaluator : (Set)iterator.next()) {
                    aSTEvaluator.afterEvaluation(state, aSTNode);
                    if (!this.cancel[0]) continue;
                    return;
                }
            }
        }
        if (list != null) {
            for (ParserManagerListener parserManagerListener : list) {
                parserManagerListener.parsed(state, this.ast);
                if (!this.cancel[0]) continue;
                return;
            }
        }
    }

    private void evaluate(ParserManager.State state, ASTItem aSTItem, List<ASTItem> list, Map<String, Set<ASTEvaluator>> map) {
        list.add(aSTItem);
        Language language = (Language)aSTItem.getLanguage();
        if (language != null) {
            language.getFeatureList().evaluate(state, list, map);
        }
        Iterator<ASTItem> iterator = aSTItem.getChildren().iterator();
        while (iterator.hasNext()) {
            if (this.cancel[0]) {
                return;
            }
            this.evaluate(state, iterator.next(), list, map);
        }
        list.remove(list.size() - 1);
    }

    private void parse() {
        this.setChange(ParserManager.State.PARSING, this.ast);
        String string = (String)this.document.getProperty("mimeType");
        Language language = this.getLanguage(string);
        LLSyntaxAnalyser lLSyntaxAnalyser = language.getAnalyser();
        TokenInput tokenInput = this.createTokenInput();
        if (this.cancel[0]) {
            return;
        }
        ArrayList<SyntaxError> arrayList = new ArrayList<SyntaxError>();
        try {
            this.ast = lLSyntaxAnalyser.read(tokenInput, true, arrayList, this.cancel);
            this.syntaxErrors = arrayList;
        }
        catch (ParseException parseException) {
            Utils.notify(parseException);
            this.ast = ASTNode.create(language, "Root", 0);
            this.setChange(ParserManager.State.OK, this.ast);
            return;
        }
        if (this.cancel[0]) {
            return;
        }
        try {
            ASTNode aSTNode;
            Feature feature = language.getFeatureList().getFeature("AST");
            if (feature != null && (aSTNode = (ASTNode)feature.getValue("process", SyntaxContext.create(this.document, ASTPath.create(this.ast)))) != null) {
                this.ast = aSTNode;
            }
        }
        catch (Exception exception) {
            Utils.notify(exception);
            this.ast = ASTNode.create(language, "Root", 0);
        }
        if (this.ast == null) {
            Utils.notify(new NullPointerException());
            this.ast = ASTNode.create(language, "Root", 0);
        }
        this.setChange(ParserManager.State.OK, this.ast);
    }

    private TokenInput createTokenInput() {
        final TokenInput[] tokenInputArray = new TokenInput[1];
        this.document.render(new Runnable(){

            public void run() {
                if (ParserManagerImpl.this.tokenHierarchy == null) {
                    tokenInputArray[0] = TokenInputUtils.create(Collections.emptyList());
                    return;
                }
                TokenSequence tokenSequence = ParserManagerImpl.this.tokenHierarchy.tokenSequence();
                List list = ParserManagerImpl.this.getTokens(tokenSequence);
                if (ParserManagerImpl.this.cancel[0]) {
                    return;
                }
                tokenInputArray[0] = TokenInputUtils.create(list);
            }
        });
        return tokenInputArray[0];
    }

    private List<ASTToken> getTokens(TokenSequence tokenSequence) {
        Object object;
        ArrayList<ASTToken> arrayList = new ArrayList<ASTToken>();
        if (tokenSequence == null) {
            return arrayList;
        }
        Language language = null;
        try {
            language = LanguagesManager.getDefault().getLanguage(tokenSequence.language().mimeType());
        }
        catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            // empty catch block
        }
        if (!tokenSequence.moveNext()) {
            return arrayList;
        }
        Token token = tokenSequence.token();
        int n = token.id().ordinal();
        int n2 = tokenSequence.offset();
        String string = (String)token.getProperty((Object)"type");
        List<ASTToken> list = null;
        if (string == SLexer.INJECTED_CODE) {
            object = tokenSequence.embedded();
            list = this.getTokens((TokenSequence)object);
            if (!tokenSequence.moveNext()) {
                arrayList.add(ASTToken.create((org.netbeans.api.languages.Language)language, 0, "", n2, 0, list));
                return arrayList;
            }
            token = tokenSequence.token();
            n = token.id().ordinal();
            n2 = tokenSequence.offset();
            string = (String)token.getProperty((Object)"type");
        }
        while (!this.cancel[0]) {
            if (string == null) {
                object = this.getTokens(tokenSequence.embedded());
                if (list != null) {
                    if (object != null) {
                        object.addAll(list);
                    } else {
                        object = list;
                    }
                    list = null;
                }
                arrayList.add(ASTToken.create((org.netbeans.api.languages.Language)language, n, ((Object)token.text()).toString(), n2, token.length(), (List<? extends ASTItem>)object));
                object = null;
            } else if (string == SLexer.CONTINUOUS_TOKEN_START) {
                object = new StringBuilder(token.text());
                ArrayList<ASTToken> arrayList2 = new ArrayList<ASTToken>();
                TokenSequence tokenSequence2 = tokenSequence.embedded();
                while (tokenSequence.moveNext()) {
                    if (this.cancel[0]) {
                        return null;
                    }
                    token = tokenSequence.token();
                    string = (String)token.getProperty((Object)"type");
                    if (string == null) {
                        tokenSequence.movePrevious();
                        break;
                    }
                    if (string == SLexer.INJECTED_CODE) {
                        tokenSequence2 = tokenSequence.embedded();
                        if (tokenSequence2 == null) continue;
                        List<ASTToken> list2 = this.getTokens(tokenSequence2);
                        if (this.cancel[0]) {
                            return null;
                        }
                        arrayList2.addAll(list2);
                        continue;
                    }
                    if (string == SLexer.CONTINUOUS_TOKEN_START) {
                        tokenSequence.movePrevious();
                        break;
                    }
                    if (string != SLexer.CONTINUOUS_TOKEN) {
                        throw new IllegalArgumentException();
                    }
                    if (n != token.id().ordinal()) {
                        throw new IllegalArgumentException();
                    }
                    ((StringBuilder)object).append(token.text());
                }
                int n3 = tokenSequence.offset() + tokenSequence.token().length();
                arrayList.add(ASTToken.create((org.netbeans.api.languages.Language)language, n, ((StringBuilder)object).toString(), n2, n3 - n2, arrayList2));
            } else {
                throw new IllegalArgumentException();
            }
            if (!tokenSequence.moveNext()) {
                return arrayList;
            }
            token = tokenSequence.token();
            n = token.id().ordinal();
            n2 = tokenSequence.offset();
            string = (String)token.getProperty((Object)"type");
        }
        return null;
    }

    private Language getLanguage(String string) {
        try {
            return LanguagesManager.getDefault().getLanguage(string);
        }
        catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            return Language.create(LanguagesManager.normalizeMimeType(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void refreshHack() {
        for (AbstractDocument abstractDocument : managers.keySet()) {
            abstractDocument.readLock();
            try {
                MutableTextInput mutableTextInput = (MutableTextInput)abstractDocument.getProperty(MutableTextInput.class);
                mutableTextInput.tokenHierarchyControl().rebuild();
            }
            finally {
                abstractDocument.readUnlock();
            }
        }
    }

    private static class DocListener
    implements TokenHierarchyListener {
        private WeakReference<ParserManagerImpl> pmwr;

        DocListener(ParserManagerImpl parserManagerImpl, TokenHierarchy tokenHierarchy) {
            this.pmwr = new WeakReference<ParserManagerImpl>(parserManagerImpl);
            tokenHierarchy.addTokenHierarchyListener((TokenHierarchyListener)this);
        }

        private ParserManagerImpl getPM() {
            ParserManagerImpl parserManagerImpl = (ParserManagerImpl)this.pmwr.get();
            if (parserManagerImpl != null) {
                return parserManagerImpl;
            }
            return null;
        }

        public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
            ParserManagerImpl parserManagerImpl = this.getPM();
            if (parserManagerImpl == null) {
                return;
            }
            parserManagerImpl.startParsing();
        }
    }
}

