/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.ListCellRenderer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.rubyproject.JavaClassPathUi;
import org.netbeans.modules.ruby.rubyproject.ProjectPropertyExtender;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.GeneratedFilesHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.ui.StoreGroup;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SharedRubyProjectProperties {
    private static final Logger LOGGER = Logger.getLogger(SharedRubyProjectProperties.class.getName());
    public static final String MAIN_CLASS = "main.file";
    public static final String RUBY_OPTIONS = "ruby.options";
    public static final String DIST_DIR = "dist.dir";
    public static final String BUILD_DIR = "build.dir";
    public static final String PLATFORM_ACTIVE = "platform.active";
    public static final String JAVAC_CLASSPATH = "javac.classpath";
    public static final String RAKE_ARGS = "rake.args";
    public static final String JVM_ARGS = "jvm.args";
    public static final String SOURCE_ENCODING = "source.encoding";
    public static final String APPLICATION_ARGS = "application.args";
    public static final String RUBY_OPTIONS_DEPRECATED = "run.jvmargs";
    public static final String SPEC_TASKS = "spec.tasks";
    public static final String TEST_TASKS = "test.tasks";
    public DefaultListModel JAVAC_CLASSPATH_MODEL;
    public ListCellRenderer CLASS_PATH_LIST_RENDERER;
    private final RubyBaseProject project;
    private RubyPlatform platform;
    protected final PropertyEvaluator evaluator;
    private final UpdateHelper updateHelper;
    private final GeneratedFilesHelper genFileHelper;
    private final ProjectPropertyExtender cs;
    private final StoreGroup privateGroup;
    private final StoreGroup projectGroup;
    private final Map<String, String> additionalProperties;
    private String activeConfig;
    private Map<String, Map<String, String>> runConfigs;
    public static final String[] WELL_KNOWN_PATHS = new String[]{"${javac.classpath}"};
    public static final String LIBRARY_PREFIX = "${libs.";
    public static final String LIBRARY_SUFFIX = ".classpath}";
    public static final String ANT_ARTIFACT_PREFIX = "${reference.";

    public SharedRubyProjectProperties(RubyBaseProject rubyBaseProject, PropertyEvaluator propertyEvaluator, UpdateHelper updateHelper, GeneratedFilesHelper generatedFilesHelper, ReferenceHelper referenceHelper) {
        this.project = rubyBaseProject;
        this.updateHelper = updateHelper;
        this.genFileHelper = generatedFilesHelper;
        this.evaluator = propertyEvaluator;
        this.cs = new ProjectPropertyExtender(propertyEvaluator, referenceHelper, updateHelper.getRakeProjectHelper(), WELL_KNOWN_PATHS, LIBRARY_PREFIX, LIBRARY_SUFFIX, ANT_ARTIFACT_PREFIX);
        this.additionalProperties = new HashMap<String, String>();
        this.privateGroup = new StoreGroup();
        this.projectGroup = new StoreGroup();
        this.init();
    }

    protected abstract String[] getConfigProperties();

    protected abstract String[] getConfigPrivateProperties();

    protected abstract void prePropertiesStore() throws IOException;

    protected abstract void storeProperties(EditableProperties var1, EditableProperties var2) throws IOException;

    private void init() {
        this.CLASS_PATH_LIST_RENDERER = new JavaClassPathUi.ClassPathListCellRenderer(this.evaluator);
        EditableProperties editableProperties = this.getUpdateHelper().getProperties("nbproject/project.properties");
        String string = editableProperties.get((Object)JAVAC_CLASSPATH);
        this.JAVAC_CLASSPATH_MODEL = SharedRubyProjectProperties.createListModel(this.cs.itemsIterator(string));
        this.runConfigs = this.readRunConfigs();
        this.activeConfig = this.evaluator.getProperty("config");
    }

    protected UpdateHelper getUpdateHelper() {
        return this.updateHelper;
    }

    protected RubyBaseProject getProject() {
        return this.project;
    }

    public RubyPlatform getPlatform() {
        return this.getProject().getPlatform();
    }

    public static String getRubyOptions(RubyBaseProject rubyBaseProject) {
        String string = rubyBaseProject.evaluator().getProperty(RUBY_OPTIONS);
        if (SharedRubyProjectProperties.isEmpty(string)) {
            string = null;
        }
        if (string == null && SharedRubyProjectProperties.isEmpty(string = rubyBaseProject.evaluator().getProperty(RUBY_OPTIONS_DEPRECATED))) {
            string = null;
        }
        return string;
    }

    public void setPlatform(RubyPlatform rubyPlatform) {
        this.platform = rubyPlatform;
    }

    public static void storePlatform(EditableProperties editableProperties, RubyPlatform rubyPlatform) {
        if (rubyPlatform == null) {
            LOGGER.fine("Project has invalid platform (null).");
            return;
        }
        editableProperties.setProperty(PLATFORM_ACTIVE, rubyPlatform.getID());
    }

    public String getActiveConfig() {
        return this.activeConfig;
    }

    public void setActiveConfig(String string) {
        this.activeConfig = string;
    }

    public Map<String, Map<String, String>> getRunConfigs() {
        return this.runConfigs;
    }

    private boolean isPrivateConfigProperty(String string) {
        return Arrays.asList(this.getConfigPrivateProperties()).contains(string);
    }

    /*
     * WARNING - void declaration
     */
    protected Map<String, Map<String, String>> readRunConfigs() {
        TreeMap<String, Map<String, String>> treeMap = new TreeMap<String, Map<String, String>>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string != null ? (string2 != null ? string.compareTo(string2) : 1) : (string2 != null ? -1 : 0);
            }
        });
        TreeMap<String, void> treeMap2 = new TreeMap<String, void>();
        for (String string : this.getConfigProperties()) {
            void string2;
            String string3 = this.getUpdateHelper().getProperties("nbproject/private/private.properties").getProperty(string);
            if (string3 == null) {
                String string4 = this.getUpdateHelper().getProperties("nbproject/project.properties").getProperty(string);
            }
            if (string2 == null) continue;
            treeMap2.put(string, string2);
        }
        treeMap.put(null, treeMap2);
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("nbproject/configs");
        if (fileObject != null) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (!fileObject2.hasExt("properties")) continue;
                treeMap.put(fileObject2.getName(), new TreeMap(this.getUpdateHelper().getProperties(FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject2))));
            }
        }
        if ((fileObject = this.project.getProjectDirectory().getFileObject("nbproject/private/configs")) != null) {
            for (FileObject fileObject3 : fileObject.getChildren()) {
                Map map;
                if (!fileObject3.hasExt("properties") || (map = (Map)treeMap.get(fileObject3.getName())) == null) continue;
                map.putAll(new HashMap(this.getUpdateHelper().getProperties(FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fileObject3))));
            }
        }
        return treeMap;
    }

    protected void storeRunConfigs(Map<String, Map<String, String>> map, EditableProperties editableProperties, EditableProperties editableProperties2) throws IOException {
        Object object;
        String string;
        Map<String, String> map2 = map.get(null);
        for (String string2 : this.getConfigProperties()) {
            string = map2.get(string2);
            Object object2 = object = this.isPrivateConfigProperty(string2) ? editableProperties2 : editableProperties;
            if (Utilities.compareObjects((Object)string, (Object)object.getProperty(string2))) continue;
            if (string != null && string.length() > 0) {
                object.setProperty(string2, string);
                continue;
            }
            object.remove((Object)string2);
        }
        for (Map.Entry entry : map.entrySet()) {
            String string2;
            String string3 = (String)entry.getKey();
            if (string3 == null) continue;
            string2 = "nbproject/configs/" + string3 + ".properties";
            string = "nbproject/private/configs/" + string3 + ".properties";
            object = (Map)entry.getValue();
            if (object == null) {
                this.updateHelper.putProperties(string2, null);
                this.updateHelper.putProperties(string, null);
                continue;
            }
            for (Map.Entry entry2 : object.entrySet()) {
                String string4;
                EditableProperties editableProperties3;
                String string5 = (String)entry2.getKey();
                String string6 = (String)entry2.getValue();
                if (Utilities.compareObjects((Object)string6, (Object)(editableProperties3 = this.updateHelper.getProperties(string4 = this.isPrivateConfigProperty(string5) ? string : string2)).getProperty(string5))) continue;
                if (string6 != null && (string6.length() > 0 || map2.get(string5) != null && map2.get(string5).length() > 0)) {
                    editableProperties3.setProperty(string5, string6);
                } else {
                    editableProperties3.remove((Object)string5);
                }
                this.updateHelper.putProperties(string4, editableProperties3);
            }
            this.updateHelper.putProperties(string2, this.updateHelper.getProperties(string2));
        }
    }

    public void putAdditionalProperty(String string, String string2) {
        this.additionalProperties.put(string, string2);
    }

    protected static boolean showModifiedMessage(String string) {
        String string2 = NbBundle.getMessage(SharedRubyProjectProperties.class, (String)"TXT_Regenerate");
        JButton jButton = new JButton(NbBundle.getMessage(SharedRubyProjectProperties.class, (String)"CTL_RegenerateButton"));
        jButton.setDefaultCapable(true);
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SharedRubyProjectProperties.class, (String)"AD_RegenerateButton"));
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 2);
        message.setTitle(string);
        message.setOptionType(2);
        message.setOptions(new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION});
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)message) == jButton;
    }

    private void storeCommonProperties() throws IOException {
        String[] stringArray = this.cs.encodeToStrings(SharedRubyProjectProperties.getIterator(this.JAVAC_CLASSPATH_MODEL));
        this.prePropertiesStore();
        EditableProperties editableProperties = this.getUpdateHelper().getProperties("nbproject/project.properties");
        EditableProperties editableProperties2 = this.getUpdateHelper().getProperties("nbproject/private/private.properties");
        this.storeProperties(editableProperties, editableProperties2);
        SharedRubyProjectProperties.storePlatform(editableProperties2, this.getPlatform());
        this.projectGroup.store(editableProperties);
        this.privateGroup.store(editableProperties2);
        this.storeRunConfigs(this.runConfigs, editableProperties, editableProperties2);
        EditableProperties editableProperties3 = this.getUpdateHelper().getProperties("nbproject/private/config.properties");
        if (this.activeConfig == null) {
            editableProperties3.remove((Object)"config");
        } else {
            editableProperties3.setProperty("config", this.activeConfig);
        }
        this.getUpdateHelper().putProperties("nbproject/private/config.properties", editableProperties3);
        editableProperties.setProperty(JAVAC_CLASSPATH, stringArray);
        editableProperties.putAll(this.additionalProperties);
        this.getUpdateHelper().putProperties("nbproject/project.properties", editableProperties);
        this.getUpdateHelper().putProperties("nbproject/private/private.properties", editableProperties2);
        String string = this.additionalProperties.get(SOURCE_ENCODING);
        if (string != null) {
            try {
                FileEncodingQuery.setDefaultEncoding((Charset)Charset.forName(string));
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
    }

    public void save() {
        try {
            Boolean bl = (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){
                final FileObject projectDir;
                {
                    this.projectDir = SharedRubyProjectProperties.this.getUpdateHelper().getRakeProjectHelper().getProjectDirectory();
                }

                public Boolean run() throws IOException {
                    if ((SharedRubyProjectProperties.this.genFileHelper.getBuildScriptState("nbproject/build-impl.xml", SharedRubyProjectProperties.this.project.getClass().getResource("resources/build-impl.xsl")) & 4) == 4) {
                        if (SharedRubyProjectProperties.showModifiedMessage(NbBundle.getMessage(SharedRubyProjectProperties.class, (String)"TXT_ModifiedTitle"))) {
                            FileObject fileObject = this.projectDir.getFileObject("nbproject/build-impl.xml");
                            if (fileObject != null) {
                                fileObject.delete();
                            }
                        } else {
                            return false;
                        }
                    }
                    SharedRubyProjectProperties.this.storeCommonProperties();
                    return true;
                }
            });
            if (bl == Boolean.TRUE) {
                ProjectManager.getDefault().saveProject((Project)this.getProject());
            }
        }
        catch (MutexException mutexException) {
            ErrorManager.getDefault().notify((Throwable)((IOException)mutexException.getException()));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private static DefaultListModel createListModel(Iterator iterator) {
        DefaultListModel defaultListModel = new DefaultListModel();
        while (iterator.hasNext()) {
            defaultListModel.addElement(iterator.next());
        }
        return defaultListModel;
    }

    private static Iterator<ProjectPropertyExtender.Item> getIterator(DefaultListModel defaultListModel) {
        return SharedRubyProjectProperties.getList(defaultListModel).iterator();
    }

    private static List<ProjectPropertyExtender.Item> getList(DefaultListModel defaultListModel) {
        ArrayList<ProjectPropertyExtender.Item> arrayList = Collections.list(defaultListModel.elements());
        return arrayList;
    }

    private static boolean isEmpty(String string) {
        return string != null && string.trim().length() == 0;
    }
}

